package simulation.dynamics;

import java.util.logging.Logger;

/**
 * factory class for producing step amender objects
 * 
 * @author matt (m.hall@cs.ucl.ac.uk)
 *
 */
public class StepAmenderFactory {

	public static final int ELESTIC_REFLECTOR=0;
	
	private static final Logger logger= Logger.getLogger("simulation.dynamics.StepAmenderFactory");
	
	public static final StepAmender getStepAmender(int type){
		
		if(type==ELESTIC_REFLECTOR){
			return new ElasticReflector();
		}
		else{
			logger.warning("Unknown step amender type "+type+" returning elastic reflector");
			return new ElasticReflector();
		}
		
	}
	
	
}
