package simulation.geometry;

import simulation.SimulationParams;

/**
 * Fills a fixed fraction of cells on the lattice in a contiguous block
 * 
 * 
 *
 * @author Matt Hall (m.hall@cs.ucl.ac.uk)
 *
 */
public class FixedFracCellularLattice extends CellularLattice {

    private final double filledFrac;
    
    /**
     * @param l cell size
     * @param L lattice size
     * @param filledFrac fraction of lattice to fill
     */
    public FixedFracCellularLattice(double l, int L, double filledFrac, SimulationParams simParams) {
        super(l, L, simParams);
        
        this.filledFrac=filledFrac;

        initLattice();
    }

    /* (non-Javadoc)
     * @see simulation.CellularLattice#initLattice()
     */
    public void initLattice() {

        int i;

        int divider=(int)Math.floor(filledFrac*L);

        for(i=0; i<occupiedLength; i++){
          if((i%L)<=divider){
            occupied[i]=true;
          }
          else{
            occupied[i]=false;
          }
        }

    }

    public static void main(String[] args) {
    }
}
