package tractography;


import misc.DT;
import numerics.*;

import java.util.Arrays;

/**
 * <dl>
 * <dt>Purpose: To perform Tractography operations.
 * <BR><BR>
 *
 * <dt>Description:
 * <dd> This class does streamline tractography. No interpolation is applied.
 *
 * </dl>
 *
 * @version $Id: FACT_TendFibreTracker.java,v 1.1 2008/12/08 17:48:43 bennett Exp $
 * @author  Philip Cook
 * 
 */
public class FACT_TendFibreTracker extends NonInterpolatedFibreTracker {

    // tend interpolator does not interpolate the tensor field, just does 
    // tensor deflection
    private TendInterpolator interpolator;

        
    /** Construct a tracker with additional options set.
     * @param data the dataset within which the tracking will take place.
     * @param ipThresh the minimum dot product between the tract direction over adjacent voxels.
     * @param f weighting for the local fiber orientation. Between 0.0 (ignore it) and 1.0 (trust
     * it completely, ignore tend).
     *
     * @param g relative weighting of the previous direction and the previous direction deflected by the
     * tensor. If 0.0, the tend term is the previous direction, if 1.0, the tend term is the deflected 
     * direction. 
     *
     */
    public FACT_TendFibreTracker(DT_TractographyImage data, double ipThresh, double tendF, double g) {

	super(data, ipThresh);

	interpolator = new TendInterpolator(data, tendF, g);

    }


    /** 
     * Construct a tracker with additional options set.
     * @param data the dataset within which the tracking will take place.
     * @param ipThresh the minimum dot product between the tract direction over adjacent voxels.
     * @param f local weighting for the fiber orientation. Between 0.0 (ignore it) and 1.0 (trust
     * it completely, ignore tend). Some function of FA, or tensor linearity, may be useful.
     *
     * @param g relative weighting of the previous direction and the previous direction deflected by the
     * tensor. If 0.0, the tend term is the previous direction, if 1.0, the tend term is the deflected 
     * direction. 
     *
     */
    public FACT_TendFibreTracker(DT_TractographyImage data, double ipThresh, double[][][] f, double g) {
	
	super(data, ipThresh);

	interpolator = new TendInterpolator(data, f, g);

    }

  
    protected Vector3D getTrackingDirection(int i, int j, int k, Vector3D previousDirection) {
	return interpolator.getTrackingDirection(i,j,k, previousDirection);
    }


}
