package tractography;

import numerics.*;

/**
 * Tracks through vector data using Euler's method, with linear interpolation of the 
 * vector elements.
 *
 * @version $Id: LinIntVectorEulerFibreTracker.java,v 1.1 2008/12/08 17:48:43 bennett Exp $
 * @author  Philip Cook
 * 
 */
public class LinIntVectorEulerFibreTracker extends EulerFibreTracker {
    
    /** 
     *
     * @param data the dataset within which the tracking will take place.
     * @param stepLength the distance (in mm) to move before performing the next interpolation. 
     * @param ipThresh the minimum absolute value of the cosine of the
     * angle between the tracking directions after traversing one slice thickness. 
     * So if slice thickness is 2.5 mm, and step size is 0.25mm, then the curvature will be assessed 
     * every 10 steps. 
     *
     */
    public LinIntVectorEulerFibreTracker(TractographyImage image, double stepLength, double ipThresh) {
	super(image, stepLength, ipThresh);
	
	interpolator = new VectorLinearInterpolator(image);
    }

    
}
