package edu.jhu.bme.smile.demo;
import edu.jhu.ece.iacl.io.StringReaderWriter;
import edu.jhu.ece.iacl.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.pipeline.AlgorithmRuntimeException;
import edu.jhu.ece.iacl.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.pipeline.AlgorithmInformation.AlgorithmAuthor;
import edu.jhu.ece.iacl.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.pipeline.parameter.ParamFloat;
import edu.jhu.ece.iacl.pipeline.parameter.ParamInteger;
import edu.jhu.ece.iacl.pipeline.parameter.ParamObject;
import edu.jhu.ece.iacl.pipeline.parameter.ParamOption;
import edu.jhu.ece.iacl.pipeline.parameter.ParamVolume;
import edu.jhu.ece.iacl.pipeline.parameter.ParamVolumeCollection;
import edu.jhu.ece.iacl.structures.image.ImageData;
import edu.jhu.bme.smile.commons.math.StatisticsDouble;
import edu.jhu.ece.iacl.structures.image.ImageDataFloat;
import edu.jhu.ece.iacl.structures.image.ImageDataMath;
import edu.jhu.bme.smile.commons.math.*;

public class ImageArithmetic extends ProcessingAlgorithm{
	//Input Field
	private ParamVolume in1;
	private ParamVolume in2;
	private ParamFloat implicitThreshold; 
	private ParamOption func;
	//Output Field
	private ParamVolume result;
	//CVS
	private static final String rcsid =
		"$Id: ImageArithmetic.java,v 1.3 2009/02/03 21:02:56 bennett Exp $";
	private static final String cvsversion =
		"$Revision: 1.3 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "");
	
	protected void createInputParameters(ParamCollection inputParams) {
		//Plug-in Information
		inputParams.setName("Image Arithmetic");
		inputParams.setLabel("Image Arithmetic");
		inputParams.setCategory("PAMI.demo");
		AlgorithmInformation info=getAlgorithmInformation();
		info.setWebsite("http://sites.google.com/site/jhupami/");
		info.add(new AlgorithmAuthor("Robert Kim","rkim35@jhu.edu","http://sites.google.com/a/jhu.edu/pami/"));
		info.add(new AlgorithmAuthor("Bennett Landman","landman@jhu.edu","http://sites.google.com/a/jhu.edu/pami/"));
		info.setDescription("Basic arithmetic functions (add, subtract, divide, multiply)");
		info.setAffiliation("Johns Hopkins University, Department of Biomedical Engineering");
		info.setVersion(revnum);
		
		inputParams.add(in1=new ParamVolume("First Image"));
		inputParams.add(in2=new ParamVolume("Second Image"));
		inputParams.add(func=new ParamOption("Function",new String[]{"Add","Subtract","Divide","Multiply"}));
		inputParams.add(implicitThreshold =new ParamFloat("Implicit Threshold",Float.NEGATIVE_INFINITY,Float.POSITIVE_INFINITY,Float.NEGATIVE_INFINITY));
	}
	protected void createOutputParameters(ParamCollection outputParams){
		outputParams.add(result=new ParamVolume("Result Image Volume",null,-1,-1,-1,-1));
	}
	protected void execute(CalculationMonitor monitor) throws AlgorithmRuntimeException{
		float thres = implicitThreshold.getFloat();
		ImageData input1 = in1.getImageData();
		ImageData input2 = in2.getImageData();
		ImageData out = new ImageDataFloat(input1);
		int rows = input1.getRows(), cols = input1.getCols(),slices = input1.getSlices(),components = input1.getComponents();		
		for(int i=0;i<rows;i++){
			for(int j=0;j<cols;j++){
				for(int k=0;k<slices;k++){
					for(int l=0;l<components;l++){
						float a= input1.getFloat(i, j, k, l), b=input2.getFloat(i, j, k, l);
						if(a<=thres && b<=thres) {
							out.set(i,j,k,l,Float.NaN);
						} else {
						switch(func.getIndex()){
						case 0: //Add
							out.set(i, j, k, l,a+b);
							break;
						case 1: //Subtract
							out.set(i, j, k, l, a-b);
							break;
						}
						}
					}
				}
			}
		}
		out.setName(input1.getName()+"_calc");
		result.setValue(out);		
	}
}
