package edu.jhu.ece.iacl.plugins.dti;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

import edu.jhu.bme.smile.commons.textfiles.TextFileReader;
import edu.jhu.ece.iacl.io.CubicVolumeReaderWriter;
import edu.jhu.ece.iacl.io.FileExtensionFilter;
import edu.jhu.ece.iacl.io.ModelImageReaderWriter;
import edu.jhu.ece.iacl.pipeline.AbstractCalculation;
import edu.jhu.ece.iacl.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.pipeline.AlgorithmRuntimeException;
import edu.jhu.ece.iacl.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.pipeline.AlgorithmInformation.AlgorithmAuthor;
import edu.jhu.ece.iacl.pipeline.parameter.ParamBoolean;
import edu.jhu.ece.iacl.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.pipeline.parameter.ParamFile;
import edu.jhu.ece.iacl.pipeline.parameter.ParamFileCollection;
import edu.jhu.ece.iacl.pipeline.parameter.ParamInteger;
import edu.jhu.ece.iacl.pipeline.parameter.ParamVolume;
import edu.jhu.ece.iacl.plugins.dti.DWITensorEstLLMSE.TensorEstimationWrapper;
import edu.jhu.ece.iacl.structures.image.ImageData;
import edu.jhu.ece.iacl.structures.image.ImageDataFloat;
import edu.jhu.ece.iacl.structures.image.ImageDataMath;
import edu.jhu.ece.iacl.structures.image.ImageDataMipav;
import edu.jhu.ece.iacl.structures.image.ImageHeader;
import edu.jhu.ece.iacl.utility.FileUtil;
import gov.nih.mipav.model.algorithms.AlgorithmCostFunctions;
import gov.nih.mipav.model.algorithms.AlgorithmTransform;
import gov.nih.mipav.model.algorithms.registration.AlgorithmRegOAR3D;
import gov.nih.mipav.model.file.FileInfoBase;
import gov.nih.mipav.model.structures.ModelImage;
import gov.nih.mipav.model.structures.TransMatrix;

public class ComputeMeanB0 extends ProcessingAlgorithm {

	//output params
	private ParamVolume meanb0;

	//input params
	private ParamFileCollection inputFiles;		// Slabs
	private ParamFile bvaluesTable;		// .b file with a list of b-values
	private ParamFile gradsTable;		// .grad or .dpf file with a list of gradient directions
	private ParamBoolean register;		// register the inputs before averaging?


	//Variables

	/****************************************************
	 * CVS Version Control
	 ****************************************************/
	private static final String rcsid =
		"$Id: ComputeMeanB0.java,v 1.10 2009/05/28 14:27:43 bennett Exp $";
	private static final String cvsversion =
		"$Revision: 1.10 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "");


	@Override
	protected void createInputParameters(ParamCollection inputParams) {
		/****************************************************
		 * Step 1. Set Plugin Information 
		 ****************************************************/
		inputParams.setLabel("Mean B0");
		inputParams.setName("Compute Mean B0");
		inputParams.setCategory("IACL.DTI");
		inputParams.setPackage("Base");
		AlgorithmInformation info=getAlgorithmInformation();
		info.setWebsite("http://sites.google.com/site/jhupami/");
		info.add(new AlgorithmAuthor("Bennett Landman","landman@jhu.edu",""));
		info.add(new AlgorithmAuthor("John Bogovic","bogovic@jhu.edu",""));		
		info.setDescription("Converts a ");
		info.setAffiliation("Johns Hopkins University");		
		info.setVersion(revnum);	

		// Input Parameters
		inputParams.add(inputFiles= new ParamFileCollection("Input Slab Collection",new FileExtensionFilter(ModelImageReaderWriter.supportedFileExtensions)));
		inputParams.add(gradsTable=new ParamFile("Table of diffusion weighting directions",new FileExtensionFilter(new String[]{"grad","dpf"})));
		inputParams.add(bvaluesTable=new ParamFile("Table of b-values",new FileExtensionFilter(new String[]{"b"})));
		inputParams.add(register = new ParamBoolean("Register b0's ?",true));

	}

	@Override
	protected void createOutputParameters(ParamCollection outputParams) {		
		outputParams.add(meanb0 = new ParamVolume("Mean B0 volume"));		
	}

	protected void execute(CalculationMonitor monitor) throws AlgorithmRuntimeException {		
		TensorEstimationWrapper wrapper=new TensorEstimationWrapper();
		monitor.observe(wrapper);
		wrapper.execute();
	}

	protected class TensorEstimationWrapper extends AbstractCalculation {

		protected void execute() {

			CubicVolumeReaderWriter rw  = CubicVolumeReaderWriter.getInstance();

			float [][]bs=null;		
			TextFileReader text = new TextFileReader(bvaluesTable.getValue());
			try {
				bs = text.parseFloatFile();
			} catch (IOException e) 
			{
				throw new RuntimeException("Unable to parse b-file");
			}

			float [][]grads=null;
			text = new TextFileReader(gradsTable.getValue());
			try {
				grads  = text.parseFloatFile();
			} catch (IOException e) { 

				throw new RuntimeException("Unable to parse grad-file");
			}

			// If there are 4 columns in the gradient table, remove the 1st column (indecies)
			if(grads[0].length==4) {
				float [][]g2 = new float[grads.length][3];
				for(int i=0;i<grads.length;i++) 
					for(int j=0;j<3;j++)
						g2[i][j]=grads[i][j+1];
				grads=g2;
			}

			if(grads[0].length!=3)
				throw new RuntimeException("LLMSE: Invalid gradient table. Must have 3 or 4 columns.");
			if(bs[0].length!=1)
				throw new RuntimeException("LLMSE: Invalid b-value table. Must have 1 column.");
			float []bval = new float[bs.length];
			for(int i=0;i<bval.length;i++)
				bval[i]=bs[i][0];

			String baseName = null;
			ImageData mean = null;
			float count =0;
			int firstb0index = -1;
			//		File dir = new File("/home/john/Desktop/regresults");

			ImageData vol=null;
			for(int i=0;i<inputFiles.size();i++){
				if(bval[i]==0 && !(grads[i][0]==100 && grads[i][1]==100 && grads[i][2]==100)) {
					count ++;
					vol = rw.read(inputFiles.getValue(i));
					ImageHeader hdr = vol.getHeader();
					if(mean==null){
						mean = new ImageDataFloat(vol);					
						firstb0index = i;
					} else {
						// run the registration
						if(register.getValue()){

							System.out.println("Registering volume: " + count);
							vol = register(rw.read(inputFiles.getValue(firstb0index)).getModelImage(),vol.getModelImage());
							vol.setHeader(hdr);
						}

						ImageDataMath.addFloatImage(mean, vol);
					}
					vol.dispose();
					vol=null;			
				}

			}

			ImageDataMath.scaleFloatValue(mean, (float)(1.0f/count));
			ModelImage foo = mean.getModelImage();	
			mean.setName(mean.getName()+"_meanb0");	
			meanb0.setValue(mean);

		}

		private ImageDataMipav register(ModelImage target, ModelImage src){

			float xresA = src.getResolutions(0)[0];
			float yresA = src.getResolutions(0)[1];
			float zresA = src.getResolutions(0)[2];
			int xdimA = src.getExtents()[0];
			int ydimA = src.getExtents()[1];
			int zdimA = src.getExtents()[2];
			AlgorithmRegOAR3D reg = new AlgorithmRegOAR3D(target,src,
					AlgorithmCostFunctions.NORMALIZED_XCORRELATION_SMOOTHED,6,AlgorithmTransform.TRILINEAR,
					-20,20,10,5,-20,20,10,5,-20,20,10,5,true,true,false,10,2,3);
			reg.runAlgorithm();
			TransMatrix finalMatrix = reg.getTransform();
			AlgorithmTransform transform = new AlgorithmTransform(src, finalMatrix, AlgorithmTransform.TRILINEAR,
					xresA, yresA, zresA,xdimA, ydimA, zdimA, true, false, false);
			transform.run();
			ImageDataMipav out = new ImageDataMipav(transform.getTransformedImage());

			reg.finalize(); reg=null;
			transform.finalize(); transform = null;

			return out;
		}
	}
}
