package edu.jhu.ece.iacl.plugins.dti;
/* This plugin does not compile - in development - only checked
 * in because build path became corrupt.
 */
import imaging.Scheme;
import imaging.SchemeV1;
import inverters.AlgebraicDT_Inversion;
import inverters.BallStickInversion;
import inverters.DT_Inversion;
import inverters.DiffusionInversion;
import inverters.LinearDT_Inversion;
import inverters.NonLinearDT_Inversion;
import inverters.RestoreDT_Inversion;
import inverters.TensorModelFitter;
import inverters.WeightedLinearDT_Inversion;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;

import javax.help.TOCView.DefaultTOCFactory;

import com.thoughtworks.xstream.XStream;

import edu.jhu.bme.smile.commons.textfiles.TextFileReader;
import edu.jhu.ece.iacl.algorithms.dti.EstimateTensorLLMSE;
import edu.jhu.ece.iacl.io.FileExtensionFilter;
import edu.jhu.ece.iacl.io.StringReaderWriter;
import edu.jhu.ece.iacl.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.pipeline.AlgorithmInformation.*;
import edu.jhu.ece.iacl.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.pipeline.parameter.ParamFile;
import edu.jhu.ece.iacl.pipeline.parameter.ParamFloat;
import edu.jhu.ece.iacl.pipeline.parameter.ParamInteger;
import edu.jhu.ece.iacl.pipeline.parameter.ParamObject;
import edu.jhu.ece.iacl.pipeline.parameter.ParamOption;
import edu.jhu.ece.iacl.pipeline.parameter.ParamVolume;
import edu.jhu.ece.iacl.pipeline.parameter.ParamVolumeCollection;
import edu.jhu.ece.iacl.structures.image.ImageDataFloat;
import edu.jhu.ece.iacl.structures.image.ImageDataMipav;
import edu.jhu.ece.iacl.structures.image.ImageDataUByte;
import edu.jhu.ece.iacl.utility.FileUtil;
import gov.nih.mipav.model.structures.ModelImage;

public class DWIBallStickEstCamino extends ProcessingAlgorithm{ 

	/****************************************************
	 * Input Parameters 
	 ****************************************************/
	private ParamVolume DWdata4D; 		// Imaging Data
	private ParamVolume Mask3D;			// Binary mask to indicate computation volume
	private ParamFile SchemeFile;
	/****************************************************
	 * Output Parameters
	 ****************************************************/
	private ParamVolume ballDVolume;	// A 3D volume with the diffusivity of the "ball"	
	private ParamVolume stickVecVolume;	// A 4D volume with the vector orientation of the stick
	private ParamVolume fractionVolume;	// A 3D volume with the diffusivity of the "ball"
	private ParamVolume exitCodeVolume;	// A 3D volume 
	private ParamVolume intensityVolume;// A 3D volume 

	private static final String rcsid =
		"$Id: DWIBallStickEstCamino.java,v 1.3 2009/03/27 01:28:44 bennett Exp $";
	private static final String cvsversion =
		"$Revision: 1.3 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "");
	
	protected void createInputParameters(ParamCollection inputParams) {

		/****************************************************
		 * Step 1. Set Plugin Information 
		 ****************************************************/
		inputParams.setName("Ball and Stick Estimation Camino");
		inputParams.setLabel("Ball and Stick Est");
		inputParams.setCategory("Modeling.Diffusion.WholeVolume");
		inputParams.setPackage("Camino");
		AlgorithmInformation info=getAlgorithmInformation();
		info.setWebsite("http://sites.google.com/site/jhupami/");
		info.add(new AlgorithmAuthor("Bennett Landman","landman@jhu.edu","http://sites.google.com/site/bennettlandman/"));
		info.add(new AlgorithmAuthor("Philip Cook","camino@cs.ucl.ac.uk","http://www.cs.ucl.ac.uk/research/medic/camino/"));
		info.setDescription("Fit diffusion weighted imaging data with the ball and stick model. ");
		info.setLongDescription("Fits the Behrens ball and stick model to diffusion-weighted data."+
				"The model is S(g, b) = S_0 (f \\exp[-b d (-g^T v)^2] + [1-f] \\exp[-b d]), where S(g,b) is the " +
				"DW signal along gradient direction g with b-value b, d is a diffusion coefficient, v is the " +
				"orientation of anisotropic diffusion, and f is a mixing parameter (0 <= f <= 1).."); 
		info.setAffiliation("Computer Science Department - University College London");		
		info.add(new Citation("Behrens et al, Magnetic Resonance in Medicine, 50:1077-1088, 2003"));		
		info.setVersion(revnum);	


		/****************************************************
		 * Step 2. Add input parameters to control system 
		 ****************************************************/
		inputParams.add(DWdata4D=new ParamVolume("DWI and Reference Image(s) Data (4D)",null,-1,-1,-1,-1));
		inputParams.add(SchemeFile=new ParamFile("CAMINO DTI Description (SchemeV1)",new FileExtensionFilter(new String[]{"scheme","schemev1"})));
		inputParams.add(Mask3D=new ParamVolume("Mask Volume to Determine Region of Estimation (3D)",null,-1,-1,-1,1));
		Mask3D.setMandatory(false); // Not required. A null mask will estimate all voxels.	
	}

	protected void createOutputParameters(ParamCollection outputParams) {
		/****************************************************
		 * Step 1. Add output parameters to control system 
		 ****************************************************/
		ballDVolume = new ParamVolume("Ball Diffusivity Estimate",null,-1,-1,-1,1);
		ballDVolume.setName("Ball (mm2/s)");
		outputParams.add(ballDVolume);
		stickVecVolume = new ParamVolume("Stick Vector Estimate",null,-1,-1,-1,3);
		stickVecVolume.setName("Vector (x,y,z)");
		outputParams.add(stickVecVolume);
		fractionVolume = new ParamVolume("Ball Fraction Estimate",null,-1,-1,-1,1);
		fractionVolume.setName("Ball Fraction");
		outputParams.add(fractionVolume);
		exitCodeVolume = new ParamVolume("Estimation Exit Code",null,-1,-1,-1,1);
		exitCodeVolume.setName("Exit Code");
		outputParams.add(exitCodeVolume);	
		intensityVolume = new ParamVolume("Intensity Estimate",null,-1,-1,-1,1);
		intensityVolume.setName("Intensity");
		outputParams.add(intensityVolume);

	}
	protected void execute(CalculationMonitor monitor) {
		/****************************************************
		 * Step 1. Indicate that the plugin has started.
		 * 		 	Tip: Use limited System.out.println statements
		 * 			to allow end users to monitor the status of
		 * 			your program and report potential problems/bugs
		 * 			along with information that will allow you to 
		 * 			know when the bug happened.  
		 ****************************************************/
		System.out.println("DWITensorEstLLMSE: Start");

		/****************************************************
		 * Step 2. Parse the input data 
		 ****************************************************/
		System.out.println("Load data.");System.out.flush();
		ImageDataMipav dwd=DWdata4D.getImageData();
		ImageDataFloat DWFloat=new ImageDataFloat(dwd);
		
		ImageDataMipav maskVol=Mask3D.getImageData();
		byte [][][]mask=null;
		if(maskVol!=null) {
			ImageDataUByte maskByte = new ImageDataUByte (maskVol);
			mask = maskByte.toArray3d();
		}
	
		System.out.println("Load scheme.");System.out.flush();
		SchemeV1 DTIscheme = null;
		
		XStream xstream = new XStream();
		xstream.alias("CaminoDWScheme-V1",imaging.SchemeV1.class);
		try {
			ObjectInputStream in = xstream.createObjectInputStream(new FileReader(SchemeFile.getValue()));
			DTIscheme=(SchemeV1)in.readObject();
			in.close();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			throw new RuntimeException(e);
		} catch (ClassNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			throw new RuntimeException(e);
		}
		

		/****************************************************
		 * Step 3. Perform limited error checking 
		 ****************************************************/
		System.out.println("Error checking."); System.out.flush();

		BallStickInversion dtiFit=new BallStickInversion(DTIscheme);
		String code = "ballAndStick";
		
		/****************************************************
		 * Step 4. Run the core algorithm. Note that this program 
		 * 		   has NO knowledge of the MIPAV data structure and 
		 * 		   uses NO MIPAV specific components. This dramatic 
		 * 		   separation is a bit inefficient, but it dramatically 
		 * 		   lower the barriers to code re-use in other applications.  		  
		 ****************************************************/
		System.out.println("Allocate memory."); System.out.flush();
		float [][][][]data=DWFloat.toArray4d();
		int rows = data.length;
		int cols= data[0].length;
		int slices= data[0][0].length;
		int components= data[0][0][0].length;
		float [][][][]ballDiff = new float[rows][cols][slices][1];
		float [][][][]ballFrac = new float[rows][cols][slices][1];
		float [][][][]stickVec = new float[rows][cols][slices][3];
		float [][][][]exitCode= new float[rows][cols][slices][1];
		float [][][][]intensity= new float[rows][cols][slices][1];

		
		System.out.println("Run CAMINO estimate."); System.out.flush();
		EstimateTensorLLMSE.estimateBallAndStickCamino(data,mask,dtiFit,ballDiff,ballFrac,stickVec,exitCode,intensity);

		/****************************************************
		 * Step 5. Retrieve the image data and put it into a new
		 * 			data structure. Be sure to update the file information
		 * 			so that the resulting image has the correct
		 * 		 	field of view, resolution, etc.  
		 ****************************************************/
		System.out.println("Data export."); System.out.flush();
		int []ext=DWFloat.getModelImage().getExtents();
		ModelImage img=null;
		ImageDataFloat out=new ImageDataFloat(stickVec);
		img=(out).getModelImage();		
		ext[3]=3;
		img.setExtents(ext);
		FileUtil.updateFileInfo(DWdata4D.getModelImage(),img);		
		img.calcMinMax();		
		out.setName(DWdata4D.getModelImage().getImageName()+"_Stick");
		stickVecVolume.setValue(out);
			
		out=new ImageDataFloat(ballDiff);
		img=(out).getModelImage();		
		ext[3]=1;
		img.setExtents(ext);
		FileUtil.updateFileInfo(DWdata4D.getModelImage(),img);
		img.calcMinMax();		
		out.setName(DWdata4D.getModelImage().getImageName()+"_BallDiff");
		ballDVolume.setValue(out);
		
		out=new ImageDataFloat(ballFrac);
		img=(out).getModelImage();		
		ext[3]=1;
		img.setExtents(ext);
		FileUtil.updateFileInfo(DWdata4D.getModelImage(),img);
		img.calcMinMax();		
		out.setName(DWdata4D.getModelImage().getImageName()+"_BallFrac");
		fractionVolume.setValue(out);
		
		out=new ImageDataFloat(exitCode);
		img=(out).getModelImage();		
		ext[3]=1;
		img.setExtents(ext);
		FileUtil.updateFileInfo(DWdata4D.getModelImage(),img);
		img.calcMinMax();		
		out.setName(DWdata4D.getModelImage().getImageName()+"_ExitCode");
		exitCodeVolume.setValue(out);
		
		out=new ImageDataFloat(intensity);
		img=(out).getModelImage();
		ext[3]=1;
		img.setExtents(ext);
		FileUtil.updateFileInfo(DWdata4D.getModelImage(),img);
		img.calcMinMax();
			
		out.setName(DWdata4D.getModelImage().getImageName()+"_Intensity");
		intensityVolume.setValue(out);	
		/****************************************************
		 * Step 6. Let the user know that your code is finished.  
		 ****************************************************/
		System.out.println("DWITensorEstLLMSE: FINISHED");
	}
}
