package edu.jhu.ece.iacl.plugins.dti;

import edu.jhu.ece.iacl.io.StringArrayXMLReaderWriter;
import edu.jhu.ece.iacl.io.StringReaderWriter;
import edu.jhu.ece.iacl.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.pipeline.AlgorithmRuntimeException;
import edu.jhu.ece.iacl.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.pipeline.parameter.ParamObject;

public class MedicAlgorithmAppendBvals extends ProcessingAlgorithm {
	
	private ParamObject<String> b0valsin1;
	private ParamObject<String> b0valsin2;
	
	//output parameter
	private ParamObject<String> b0valsoutgroup;
	private ParamObject<String> b0valsoutcat;
	
	//helper parameter
	private final StringArrayXMLReaderWriter saxml = new StringArrayXMLReaderWriter();
	
	/****************************************************
	 * CVS Version Control
	 ****************************************************/
	private static final String rcsid =
		"$Id: MedicAlgorithmAppendBvals.java,v 1.4 2008/12/10 16:03:49 bennett Exp $";
	private static final String cvsversion =
		"$Revision: 1.4 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "");


	@Override
	protected void createInputParameters(ParamCollection inputParams) {
		inputParams.add(b0valsin1 = new ParamObject<String>("b0 Values", new StringReaderWriter()));
		inputParams.add(b0valsin2 = new ParamObject<String>("b0 Values to append", new StringReaderWriter()));
		
		inputParams.setName("appendbvals");
		inputParams.setLabel("Create b0 list");
		inputParams.setCategory("IACL.DTI");
		
		AlgorithmInformation info=getAlgorithmInformation();		
		info.setVersion(revnum);	

	}

	@Override
	protected void createOutputParameters(ParamCollection outputParams) {
		outputParams.add(b0valsoutgroup = new ParamObject<String>("b0 Values grouped", new StringReaderWriter()));
		outputParams.add(b0valsoutcat = new ParamObject<String>("b0 Values appended", new StringReaderWriter()));
	}

	@Override
	protected void execute(CalculationMonitor monitor)
			throws AlgorithmRuntimeException {
		
		String[] b0array = new String[]{b0valsin1.getObject(), b0valsin2.getObject()};
		String out = saxml.writeStrings(b0array);
		System.out.println(out);
		b0valsoutgroup.setObject(out);
		b0valsoutgroup.setFileName("b0Values_grouped");
		
		b0valsoutcat.setObject(b0valsin1.getObject()+b0valsin2.getObject());
		b0valsoutcat.setFileName("b0Values_append");
	}
	
	

}
