package edu.jhu.ece.iacl.plugins.dti;

import java.io.File;
import java.util.ArrayList;

import edu.jhu.ece.iacl.algorithms.dti.GradientTable;
import edu.jhu.ece.iacl.io.StringReaderWriter;
import edu.jhu.ece.iacl.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.pipeline.AlgorithmRuntimeException;
import edu.jhu.ece.iacl.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.pipeline.AlgorithmInformation.AlgorithmAuthor;
import edu.jhu.ece.iacl.pipeline.AlgorithmInformation.Citation;
import edu.jhu.ece.iacl.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.pipeline.parameter.ParamObject;
import edu.jhu.ece.iacl.pipeline.parameter.ParamOption;

public class MedicAlgorithmAppendGradientTable extends ProcessingAlgorithm {

	private ParamObject<String> gradTable;
	private ParamObject<String> gradTabletoappend;
	private ParamOption tabletype;
	
	private ParamObject<String> gradOut;
	
	private static final String rcsid =
		"$Id: MedicAlgorithmAppendGradientTable.java,v 1.2 2008/10/27 14:31:18 bogovic Exp $";
	private static final String cvsversion =
		"$Revision: 1.2 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "");

	
	
	@Override
	protected void createInputParameters(ParamCollection inputParams) {
		inputParams.add(gradTable = new ParamObject<String>("Gradient Table",new StringReaderWriter()));
		inputParams.add(gradTabletoappend = new ParamObject<String>("Gradient Table to Append",new StringReaderWriter()));
		inputParams.setName("gradTableAppend");
		inputParams.setCategory("IACL.DTI");
		inputParams.setLabel("Append Gradient Table v"+revnum);
		AlgorithmInformation info=getAlgorithmInformation();
		info.setWebsite("");
		info.add(new AlgorithmAuthor("John Bogovic","bogovic@jhu.edu",""));
		info.setDescription("Appends one gradient table to another - useful when combining multiple corresponding DW acquisitions");
		info.setAffiliation("Johns Hopkins University, Department of Electrical Engineering");
		info.setVersion(revnum);
	}

	@Override
	protected void createOutputParameters(ParamCollection outputParams) {
		outputParams.add(gradOut = new ParamObject<String>("Combined Gradient Table",new StringReaderWriter()));
	}

	@Override
	protected void execute(CalculationMonitor monitor)
			throws AlgorithmRuntimeException {
		
		GradientTable gt1 = new GradientTable();
		gt1.readTable(gradTable.getValue());
		GradientTable gt2 = new GradientTable();
		gt2.readTable(gradTabletoappend.getValue());
		
		GradientTable tableout = gt1.append(gt2);
		gradOut.setObject(tableout.toDtisTable());
		gradOut.setFileName(gradTable.getValue().getName()+"_app-"+gradTabletoappend.getValue().getName());
		
	}

}
