package edu.jhu.ece.iacl.plugins.dti;

import edu.jhu.ece.iacl.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.pipeline.parameter.ParamOption;
import edu.jhu.ece.iacl.pipeline.parameter.ParamVolume;
import edu.jhu.ece.iacl.structures.image.ImageDataMipav;

public class MedicAlgorithmFlipVectorVolume extends ProcessingAlgorithm{
	
	//input params
	private ParamVolume vecvolin;
	private ParamOption flipDim;
	
	//output param
	private ParamVolume vecvolout;
	
	/****************************************************
	 * CVS Version Control
	 ****************************************************/
	private static final String rcsid =
		"$Id: MedicAlgorithmFlipVectorVolume.java,v 1.4 2009/03/19 13:55:19 bogovic Exp $";
	private static final String cvsversion =
		"$Revision: 1.4 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "");

	
	protected void createInputParameters(ParamCollection inputParams) {
		inputParams.add(vecvolin = new ParamVolume("Input Vector Volume",null,-1,-1,-1,3));
		String[] flipoptions = {"X","Y","Z"};
		inputParams.add(flipDim = new ParamOption("Gradient to Flip",flipoptions));
		
		inputParams.setName("VectorVolFlipper");
		inputParams.setLabel("Flip Vector Volume");
		inputParams.setCategory("IACL.DTI");
		getAlgorithmInformation().setVersion(revnum);
	}
	
	protected void createOutputParameters(ParamCollection outputParams) {		
		outputParams.add(vecvolout = new ParamVolume("Flipped Vector Volume",null,-1,-1,-1,3));
	}
	
	protected void execute(CalculationMonitor monitor) {
		ImageDataMipav vol = vecvolin.getImageData();
		for(int i=0;i<vol.getRows();i++){
    		for(int j=0;j<vol.getCols();j++){
    			for(int k=0;k<vol.getSlices();k++){
    				vol.set(i,j,k,flipDim.getIndex(),-vol.get(i,j,k,flipDim.getIndex()).doubleValue());
    			}
    		}
    	}   
		vecvolout.setValue(vol);
	}
	
}
