package edu.jhu.ece.iacl.plugins.dti.tractography;

import edu.jhu.ece.iacl.io.FiberCollectionReaderWriter;
import edu.jhu.ece.iacl.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.pipeline.AlgorithmRuntimeException;
import edu.jhu.ece.iacl.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.pipeline.AlgorithmInformation.AlgorithmAuthor;
import edu.jhu.ece.iacl.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.pipeline.parameter.ParamMatrix;
import edu.jhu.ece.iacl.pipeline.parameter.ParamObject;
import edu.jhu.ece.iacl.pipeline.parameter.ParamVolume;
import edu.jhu.ece.iacl.structures.fiber.FiberCollection;
import edu.jhu.ece.iacl.structures.image.VoxelType;

public class MedicAlgorithmDeformFibers extends ProcessingAlgorithm {

	//input parameters
	private ParamObject<FiberCollection> fibersin;
	private ParamVolume deffield;
	
	//output parameters
	private ParamObject<FiberCollection> deffibers;
	
	private static final String rcsid =
		"$Id: MedicAlgorithmDeformFibers.java,v 1.1 2009/03/19 15:50:26 bogovic Exp $";
	private static final String cvsversion =
		"$Revision: 1.1 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "");

	
	@Override
	protected void createInputParameters(ParamCollection inputParams) {
		inputParams.add(fibersin = new ParamObject<FiberCollection>("Input Fibers",new FiberCollectionReaderWriter()));
		inputParams.add(deffield = new ParamVolume("Deformation Field",VoxelType.FLOAT,-1,-1,-1,3));

		inputParams.setName("deform_fibers");
		inputParams.setLabel("Deform Fibers");
		inputParams.setCategory("IACL.DTI.Fiber");
		
		AlgorithmInformation info=getAlgorithmInformation();
		info.setWebsite("");
		info.add(new AlgorithmAuthor("John Bogovic","bogovic@jhu.edu",""));
		info.setDescription("Applies an affine transformation to fibers obtained from white matter tractography");
		info.setAffiliation("Johns Hopkins University, Departments of Electrical and Biomedical Engineering");	
		info.setVersion(revnum);	
	}

	@Override
	protected void createOutputParameters(ParamCollection outputParams) {
		outputParams.add(deffibers = new ParamObject<FiberCollection>("Transformed Fibers",new FiberCollectionReaderWriter()));
	}

	@Override
	protected void execute(CalculationMonitor monitor)
			throws AlgorithmRuntimeException {
//		deffibers.setObject(FiberTransformation.applyDeformation(fibersin.getObject(), deffield.getImageData()));
		deffibers.setFileName(fibersin.getValue().getName()+"_deformed");
	}

}
