/**
 * 
 */
package edu.jhu.ece.iacl.plugins.utilities.logic;

import javax.vecmath.Point3d;

import edu.jhu.ece.iacl.pipeline.AlgorithmRuntimeException;
import edu.jhu.ece.iacl.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.pipeline.parameter.ParamDouble;
import edu.jhu.ece.iacl.pipeline.parameter.ParamInteger;
import edu.jhu.ece.iacl.pipeline.parameter.ParamPointDouble;
import edu.jhu.ece.iacl.pipeline.parameter.ParamSurface;
import edu.jhu.ece.iacl.pipeline.parameter.ParamSurfaceCollection;

/**
 * @author Blake Lucas (bclucas@jhu.edu)
 *
 */
public class MedicAlgorithmFloatsToPoint extends ProcessingAlgorithm{
	ParamDouble ptx,pty,ptz;
	ParamPointDouble pt;
	protected void createInputParameters(ParamCollection inputParams) {
		setRunningInSeparateProcess(false);
		inputParams.add(ptx=new ParamDouble("X"));
		inputParams.add(pty=new ParamDouble("Y"));
		inputParams.add(ptz=new ParamDouble("Z"));
		inputParams.setName("floats2point");
		inputParams.setLabel("Floats to Point");
		inputParams.setCategory("IACL.Utilities.Logic");
	}
	protected void createOutputParameters(ParamCollection outputParams) {
		outputParams.add(pt=new ParamPointDouble("Point"));
	}
	protected void execute(CalculationMonitor monitor) throws AlgorithmRuntimeException {
		pt.setValue(new Point3d(ptx.getDouble(),pty.getDouble(),ptz.getDouble()));
	}
	
}
