/**
 * 
 */
package edu.jhu.ece.iacl.plugins.utilities.math;

import java.util.Arrays;

import edu.jhu.ece.iacl.pipeline.AlgorithmRuntimeException;
import edu.jhu.ece.iacl.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.pipeline.parameter.ParamDouble;
import edu.jhu.ece.iacl.pipeline.parameter.ParamOption;
import edu.jhu.ece.iacl.pipeline.parameter.ParamVolume;
import edu.jhu.ece.iacl.structures.image.ImageData;
import edu.jhu.ece.iacl.structures.image.ImageDataFloat;
import edu.jhu.ece.iacl.structures.image.ImageDataMipav;

/**
 * @author Blake Lucas (bclucas@jhu.edu)
 *
 */
public class MedicAlgorithmImageCalculator extends ProcessingAlgorithm{
	ParamVolume vol1Param;
	ParamVolume vol2Param;
	ParamVolume resultVolParam;
	ParamOption operation;
	protected void createInputParameters(ParamCollection inputParams) {
		inputParams.add(vol1Param=new ParamVolume("Volume 1"));
		inputParams.add(vol2Param=new ParamVolume("Volume 2"));		
		inputParams.add(operation=new ParamOption("Operation",new String[]{"Add","Subtract","Multiply","Divide"}));
		inputParams.setName("img_calc");
		inputParams.setLabel("Image Calculator");
		inputParams.setCategory("IACL.Utilities.Math");
	}
	protected void createOutputParameters(ParamCollection outputParams) {
		outputParams.add(resultVolParam=new ParamVolume("Result Volume",null,-1,-1,-1,-1));
	}
	protected void execute(CalculationMonitor monitor) throws AlgorithmRuntimeException {
		ImageDataMipav vol1=vol1Param.getImageData();
		ImageDataMipav vol2=vol2Param.getImageData();
		int rows=vol1.getRows();
		int cols=vol1.getCols();
		int slices=vol1.getSlices();
		int comps = vol1.getComponents();
		ImageDataFloat resultVol=new ImageDataFloat(vol1.getName()+"_calc",rows,cols,slices,comps);
		double tmp1,tmp2;
		for (int i = 0; i < rows; i++) {
			for (int j = 0; j < cols; j++) {
				for (int k = 0; k < slices; k++) {
					for (int l = 0; l < comps; l++) {
						tmp1=vol1.getDouble(i, j, k, l);
						tmp2=vol2.getDouble(i, j, k, l);

						switch(operation.getIndex()){
						case 0:resultVol.set(i, j, k, l, tmp1+tmp2);break;
						case 1:resultVol.set(i, j, k, l, tmp1-tmp2);break;
						case 2:resultVol.set(i, j, k, l, tmp1*tmp2);break;
						case 3:resultVol.set(i, j, k, l, tmp1/tmp2);break;
						default:
						}
					}
				}
			}
		}
		resultVolParam.setValue(resultVol);
	}
	
}
