/**
 * 
 */
package edu.jhu.ece.iacl.plugins.utilities.math;

import java.util.Arrays;

import edu.jhu.ece.iacl.pipeline.AlgorithmRuntimeException;
import edu.jhu.ece.iacl.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.pipeline.parameter.ParamDouble;
import edu.jhu.ece.iacl.pipeline.parameter.ParamOption;
import edu.jhu.ece.iacl.pipeline.parameter.ParamVolume;
import edu.jhu.ece.iacl.structures.image.ImageData;
import edu.jhu.ece.iacl.structures.image.ImageDataFloat;
import edu.jhu.ece.iacl.structures.image.ImageDataMipav;

/**
 * @author Blake Lucas (bclucas@jhu.edu)
 */
public class MedicAlgorithmMath extends ProcessingAlgorithm {
	ParamDouble valA;
	ParamDouble valB;
	ParamDouble result;
	ParamDouble valParam;
	ParamOption operation;

	protected void createInputParameters(ParamCollection inputParams) {
		setRunningInSeparateProcess(false);
		inputParams.add(valA = new ParamDouble("Value A"));
		inputParams.add(valB = new ParamDouble("Value B"));
		inputParams.add(operation = new ParamOption("Operation", new String[] { "Absolute Value: |a|", "Add: a+b", "Subtract: a-b",
				"Multiply: a*b", "Divide: a/b", "Power: a^b", "Log: log(a)", "Exp: exp(a)" }));
		inputParams.setName("math");
		inputParams.setLabel("Math");
		inputParams.setCategory("IACL.Utilities.Math");
	}

	protected void createOutputParameters(ParamCollection outputParams) {
		outputParams.add(result = new ParamDouble("Result"));
	}

	protected void execute(CalculationMonitor monitor) throws AlgorithmRuntimeException {
		double a = valA.getDouble();
		double b = valB.getDouble();
		double c = 0;
		switch (operation.getIndex()) {
		case 0:
			c = Math.abs(a);
			break;
		case 1:
			c = a + b;
			break;
		case 2:
			c = a - b;
			break;
		case 3:
			c = a * b;
			break;
		case 4:
			c = (b != 0) ? a / b : 0;
			break;
		case 5:
			c = Math.pow(a, b);
			break;
		case 6:
			c = Math.log(a);
			break;
		case 7:
			c = Math.exp(a);
			break;
		default:
		}
		result.setValue(c);
	}
}
