/**
 * 
 */
package edu.jhu.ece.iacl.plugins.utilities.surface;

import java.util.List;

import javax.vecmath.Point3f;

import edu.jhu.ece.iacl.pipeline.AlgorithmRuntimeException;
import edu.jhu.ece.iacl.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.pipeline.parameter.ParamSurface;
import edu.jhu.ece.iacl.pipeline.parameter.ParamSurfaceCollection;
import edu.jhu.ece.iacl.structures.geom.EmbeddedSurface;

/**
 * @author Blake Lucas (bclucas@jhu.edu)
 *
 */
public class MedicAlgorithmCombineSurfaceComponents extends ProcessingAlgorithm{
	
	ParamSurfaceCollection inSurfs;
	ParamSurface outSurf;
	protected void createInputParameters(ParamCollection inputParams) {
		inputParams.add(inSurfs=new ParamSurfaceCollection("Surfaces"));
		inputParams.setLabel("Combine Surface Components");
		inputParams.setName("comb_surf_comp");
		inputParams.setCategory("IACL.Utilities.Surface");
	}
	protected void createOutputParameters(ParamCollection outputParams) {
		outputParams.add(outSurf=new ParamSurface("Multi-Component Surface"));

	}

	protected void execute(CalculationMonitor monitor) throws AlgorithmRuntimeException {
		List<EmbeddedSurface> surfs=inSurfs.getSurfaceList();
		int comp=surfs.size();
		EmbeddedSurface first=surfs.get(0);
		int vertCount=first.getVertexCount();
		double[][] data=new double[vertCount][comp];
		Point3f[] verts=first.getVertexCopy();
		int[] indexes=first.getIndexCopy();
		for(int i=0;i<vertCount;i++){
			for(int l=0;l<comp;l++){
				data[i][l]=surfs.get(l).getVertexDataAtOffset(i,0);
			}
		}
		
		EmbeddedSurface csurf=new EmbeddedSurface(verts,indexes,data);
		csurf.setName(first.getName()+"_vec");
		outSurf.setValue(csurf);
	}
	
}
