/**
 * 
 */
package edu.jhu.ece.iacl.plugins.utilities.surface;

import javax.vecmath.Point2d;
import javax.vecmath.Point3f;

import edu.jhu.ece.iacl.algorithms.graphics.GeomUtil;
import edu.jhu.ece.iacl.io.ArrayDoubleReaderWriter;
import edu.jhu.ece.iacl.pipeline.AlgorithmRuntimeException;
import edu.jhu.ece.iacl.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.pipeline.parameter.ParamInteger;
import edu.jhu.ece.iacl.pipeline.parameter.ParamObject;
import edu.jhu.ece.iacl.pipeline.parameter.ParamSurface;
import edu.jhu.ece.iacl.structures.geom.EmbeddedSurface;
import edu.jhu.ece.iacl.structures.image.ImageDataMipav;

/**
 * @author Blake Lucas (bclucas@jhu.edu)
 *
 */
public class MedicAlgorithmExtractSurfaceComponent extends ProcessingAlgorithm{
	ParamInteger stIndex;
	ParamInteger endIndex;
	ParamSurface inSurf;
	ParamSurface outSurf;
	ParamObject<double[][]> dataArray;
	protected void createInputParameters(ParamCollection inputParams) {
		inputParams.add(inSurf=new ParamSurface("Mult-Component Surface"));
		inputParams.add(stIndex=new ParamInteger("Start Index",0,1000000,0));
		inputParams.add(endIndex=new ParamInteger("End Index",0,1000000,0));
		inputParams.setLabel("Extract Surface Component");
		inputParams.setName("extract_surf_comp");
		inputParams.setCategory("IACL.Utilities.Surface");
	}
	protected void createOutputParameters(ParamCollection outputParams) {
		outputParams.add(outSurf=new ParamSurface("Extracted Surface"));
		outputParams.add(dataArray=new ParamObject<double[][]>("Data",new ArrayDoubleReaderWriter()));

	}

	protected void execute(CalculationMonitor monitor) {
		EmbeddedSurface surf=inSurf.getSurface();
		int st=stIndex.getInt();
		int end=endIndex.getInt();
		
		int vertCount=surf.getVertexCount();
		double[][] data=new double[vertCount][end-st+1];
		for(int id=0;id<vertCount;id++){
			for(int l=st;l<=end;l++){
				data[id][l-st]=surf.getVertexDataAtOffset(id,l);
			}
		}
		EmbeddedSurface newSurf=new EmbeddedSurface(surf.getVertexCopy(),surf.getIndexCopy(),data);
		newSurf.setName(surf.getName()+"_"+st+"-"+end);
		
		outSurf.setValue(newSurf);
		dataArray.setObject(data);
		dataArray.setFileName(surf.getName()+"_"+st+"-"+end);
	}
	
}
