package edu.jhu.ece.iacl.plugins.utilities.surface;

import javax.vecmath.Point3f;

import edu.jhu.ece.iacl.io.ArrayDoubleReaderWriter;
import edu.jhu.ece.iacl.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.pipeline.AlgorithmInformation.AlgorithmAuthor;
import edu.jhu.ece.iacl.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.pipeline.parameter.ParamObject;
import edu.jhu.ece.iacl.pipeline.parameter.ParamOption;
import edu.jhu.ece.iacl.pipeline.parameter.ParamSurface;
import edu.jhu.ece.iacl.pipeline.parameter.ParamVolume;
import edu.jhu.ece.iacl.structures.geom.EmbeddedSurface;
import edu.jhu.ece.iacl.structures.image.ImageDataMipav;

public class MedicAlgorithmSurfaceToVolumeConverter extends ProcessingAlgorithm{
	
	private static final String rcsid =
		"$Id: MedicAlgorithmSurfaceToVolumeConverter.java,v 1.1 2008/10/21 01:39:41 bogovic Exp $";
	private static final String cvsversion =
		"$Revision: 1.1 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "");

	
	ParamSurface surf;
	ParamVolume templatevol;
	ParamOption method;
	
	//output param
	ParamVolume outVol;
	

	
	protected void createInputParameters(ParamCollection inputParams) {
		inputParams.add(surf=new ParamSurface("Surface"));
		
		inputParams.add(method=new ParamOption("Method",new String[]{"Mask","Vertex Data"}));
		inputParams.add(templatevol=new ParamVolume("Template Volume"));
		
		inputParams.setLabel("Surface To Volume v"+revnum);
		inputParams.setName("surf2vol");
		inputParams.setCategory("IACL.Utilities.Surface");
		
		AlgorithmInformation info=getAlgorithmInformation();
		info.add(new AlgorithmAuthor("John Bogovic","bogovic@@jhu.edu",""));
		info.setDescription("Converts a Surface into a simplified volumetric representation." +
				"Can either assign voxel value = 1 where vertices are present, or uses vertex data to assign voxel value");
		info.setAffiliation("Johns Hopkins University, Department of Electrical and Computer Engineering");				
		info.setVersion(revnum);	
	}

	@Override
	protected void createOutputParameters(ParamCollection outputParams) {
		outputParams.add(outVol=new ParamVolume("Volume"));
	}

	@Override
	protected void execute(CalculationMonitor monitor) {
		if(method.getIndex()==0){
			outVol.setValue(surfToVolumeMask());
		}else{
			outVol.setValue(surfToVolumeVertData());
		}
		
	}
	
	private ImageDataMipav surfToVolumeMask(){
		ImageDataMipav maskvol = templatevol.getImageData().mimic();
		EmbeddedSurface s = surf.getObject();
		maskvol.setName(s.getName()+"_volmask");
		
		for(int i=0; i<s.getVertexCount(); i++){
			Point3f pt = s.getVertex(i);
			maskvol.set(Math.round(pt.x), Math.round(pt.y), Math.round(pt.z), 1);
		}
		return maskvol;
	}
	
	private ImageDataMipav surfToVolumeVertData(){
		ImageDataMipav datavol = templatevol.getImageData().mimic();
		EmbeddedSurface s = surf.getObject();
		datavol.setName(s.getName()+"_voldata");
		for(int i=0; i<s.getVertexCount(); i++){
			Point3f pt = s.getVertex(i);
			datavol.set(Math.round(pt.x), Math.round(pt.y), Math.round(pt.z), s.getVertexData(i)[0]);
		}
		return datavol;
	}

}
