package edu.jhu.ece.iacl.plugins.utilities.volume;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

import edu.jhu.ece.iacl.io.CubicVolumeReaderWriter;
import edu.jhu.ece.iacl.io.FileExtensionFilter;
import edu.jhu.ece.iacl.io.ModelImageReaderWriter;
import edu.jhu.ece.iacl.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.pipeline.AlgorithmInformation.AlgorithmAuthor;
import edu.jhu.ece.iacl.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.pipeline.parameter.ParamFileCollection;
import edu.jhu.ece.iacl.structures.image.ImageData;
import edu.jhu.ece.iacl.structures.image.ImageDataMipav;
import edu.jhu.ece.iacl.utility.FileUtil;
import gov.nih.mipav.model.structures.ModelImage;

/**
 * 
 * @author John Bogovic 
 *
 */
public class AlgorithmVolumeFileCollectionTo3D extends ProcessingAlgorithm{
	
	//output params
	private ParamFileCollection outputFiles;	// Files to be split

	//input params
	private ParamFileCollection inputFiles;		// Files to be split
	
	/****************************************************
	 * CVS Version Control
	 ****************************************************/
	private static final String rcsid =
		"$Id: AlgorithmVolumeFileCollectionTo3D.java,v 1.4 2009/01/21 13:06:08 bennett Exp $";
	private static final String cvsversion =
		"$Revision: 1.4 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "");

	protected void createInputParameters(ParamCollection inputParams) {
		
		/****************************************************
		 * Step 1. Set Plugin Information 
		 ****************************************************/
		inputParams.setLabel("4D Volumes to 3D Volumes");
		inputParams.setName("VolumesTo3D");
		inputParams.setCategory("IACL.Utilities.Volume");
		inputParams.setPackage("Base");
		AlgorithmInformation info=getAlgorithmInformation();
		info.setWebsite("http://sites.google.com/site/jhupami/");
		info.add(new AlgorithmAuthor("John Bogovic","bogovic@jhu.edu",""));		
		info.setDescription("Extract Components of each input volume.  Organize the output as a FileCollection");
		info.setAffiliation("Johns Hopkins University");		
		info.setVersion(revnum);	
		
		// Input Parameters
		inputParams.add(inputFiles= new ParamFileCollection("Input Volume Files",new FileExtensionFilter(ModelImageReaderWriter.supportedFileExtensions)));				
	
	}
	
	protected void createOutputParameters(ParamCollection outputParams) {				
		outputParams.add(outputFiles = new ParamFileCollection("Output 3D Volume Files",new FileExtensionFilter(ModelImageReaderWriter.supportedFileExtensions)));
	}
	
	protected void execute(CalculationMonitor monitor) {
		
		
//		File outDir;
//		try{
			File outDir = this.getOutputDirectory();//MipavController.getDefaultWorkingDirectory();
//			outDir = new File(edu.jhu.ece.iacl.utility.FileUtil.forceSafeFilename(this.getOutputDirectory().getCanonicalPath().toString()+File.separator+this.getAlgorithmName()));
//			outDir = new File(edu.jhu.ece.iacl.utility.FileUtil.forceSafeFilename(this.getOutputDirectory().getCanonicalPath().toString()));
//			outDir = new File(this.getOutputDirectory().getCanonicalPath().toString());
			CubicVolumeReaderWriter rw  = CubicVolumeReaderWriter.getInstance();
			
			ArrayList<File> allfiles = new ArrayList<File>();
			
			for(File f: inputFiles.getValue()){
				ImageData vol = rw.read(f);
				ArrayList<File> thesefiles = extractAndWriteComponents(vol, outDir.getAbsolutePath(), rw);
				addFiles(allfiles,thesefiles);

				vol = null;
				System.gc();
				outputFiles.setValue(allfiles);
			}
			
//		}catch(IOException e){
//			e.printStackTrace();
//		}
	}
	
	
	private ArrayList<File> extractAndWriteComponents(ImageData vol, String dir, CubicVolumeReaderWriter rw){
        ArrayList<File> listout = new ArrayList<File>();
		for(int l=0; l<vol.getComponents(); l++){
			String num = "";
			if(l<10){
				num="0"+l;
			}else{
				num = ""+l;
			}
			ImageDataMipav nextvol = new ImageDataMipav(vol.getName()+"_"+num,vol.getType(),vol.getRows(), vol.getCols(), vol.getSlices());
			nextvol.setHeader(vol.getHeader());
			System.out.println(vol.getType());
			for(int i=0;i<vol.getRows();i++){
				for(int j=0;j<vol.getCols();j++){
					for(int k=0;k<vol.getSlices();k++){
						
						nextvol.set(i, j, k, vol.getUByte(i, j, k, l));
					}
				}
			}   
			
			/* Update Header information*/
//			ModelImage img=(nextvol).getModelImage();
//			FileUtil.updateFileInfo(vol.getModelImage(),img);
//			img.calcMinMax();
			
			System.out.println("Completed " +l+"th bolume.  Writing to file..." + nextvol.getName());
			//Write the volume to a file in the appropriate directory
			String name = nextvol.getName();
			System.out.println("got here");
			File f = new File(dir, FileUtil.forceSafeFilename(name) + "."+rw.getExtensionFilter().getPreferredExtension());
			File f2 = rw.write(nextvol, f);
			if(f2!=null){
				listout.add(f2);
				System.out.print("Success!\n");
			}
			
			// Help out the GC
			nextvol = null;

		}
		
		return listout;
		
	}
	
	private void addFiles(ArrayList<File> base, ArrayList<File> addus){
		for(File f: addus){
			base.add(f);
		}
	}
}
