package edu.jhu.ece.iacl.plugins.utilities.volume;

import java.io.File;
import java.util.ArrayList;

import edu.jhu.ece.iacl.io.CubicVolumeReaderWriter;
import edu.jhu.ece.iacl.io.FileExtensionFilter;
import edu.jhu.ece.iacl.io.ModelImageReaderWriter;
import edu.jhu.ece.iacl.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.pipeline.AlgorithmRuntimeException;
import edu.jhu.ece.iacl.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.pipeline.AlgorithmInformation.AlgorithmAuthor;
import edu.jhu.ece.iacl.pipeline.parameter.ParamBoolean;
import edu.jhu.ece.iacl.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.pipeline.parameter.ParamFile;
import edu.jhu.ece.iacl.pipeline.parameter.ParamFileCollection;
import edu.jhu.ece.iacl.pipeline.parameter.ParamInteger;
import edu.jhu.ece.iacl.pipeline.parameter.ParamVolume;
import edu.jhu.ece.iacl.structures.image.ImageData;
import edu.jhu.ece.iacl.structures.image.ImageDataFloat;
import edu.jhu.ece.iacl.structures.image.ImageDataMipav;
import edu.jhu.ece.iacl.utility.FileUtil;
import gov.nih.mipav.model.file.FileInfoBase;
import gov.nih.mipav.model.structures.ModelImage;

public class CombinedSlabCollectionToVolumeCollection extends ProcessingAlgorithm {

	//output params
	private ParamFileCollection outputFiles;		// Slabs
	private ParamVolume output4d;

	//input params
	private ParamFileCollection inputFiles;		// Slabs
	

	private ParamBoolean output4D;

	//Variables
	ArrayList<File> outVols;
	File outDir;
	CubicVolumeReaderWriter rw = CubicVolumeReaderWriter.getInstance();

	/****************************************************
	 * CVS Version Control
	 ****************************************************/
	private static final String rcsid =
		"$Id: CombinedSlabCollectionToVolumeCollection.java,v 1.1 2009/01/21 13:06:08 bennett Exp $";
	private static final String cvsversion =
		"$Revision: 1.1 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "");


	@Override
	protected void createInputParameters(ParamCollection inputParams) {
		/****************************************************
		 * Step 1. Set Plugin Information 
		 ****************************************************/
		inputParams.setLabel("Combined4DSlabCollect to VolCollect");
		inputParams.setName("Combined4DSlabsToVol");
		inputParams.setCategory("IACL.Utilities.Volume");
		inputParams.setPackage("Base");
		AlgorithmInformation info=getAlgorithmInformation();
		info.setWebsite("http://sites.google.com/site/jhupami/");
		info.add(new AlgorithmAuthor("Bennett Landman","landman@jhu.edu",""));
		info.add(new AlgorithmAuthor("John Bogovic","bogovic@jhu.edu",""));		
		info.setDescription("Converts a ");
		info.setAffiliation("Johns Hopkins University");		
		info.setVersion(revnum);	

		// Input Parameters
		inputParams.add(inputFiles= new ParamFileCollection("Input Slab Collection",new FileExtensionFilter(ModelImageReaderWriter.supportedFileExtensions)));
		inputParams.add(output4D = new ParamBoolean("Use 4D Output",true));

	}

	@Override
	protected void createOutputParameters(ParamCollection outputParams) {
		outputParams.add(outputFiles = new ParamFileCollection("Output FileVolume Collection",new FileExtensionFilter(ModelImageReaderWriter.supportedFileExtensions)));
		outputParams.add(output4d = new ParamVolume("4D Output (optional)"));
		output4d.setMandatory(false);
		
	}

	@Override
	protected void execute(CalculationMonitor monitor) throws AlgorithmRuntimeException {
		outDir = this.getOutputDirectory();//MipavController.getDefaultWorkingDirectory();
		CubicVolumeReaderWriter rw  = CubicVolumeReaderWriter.getInstance();
		boolean use4D = output4D.getValue();
		// First need to count the number of volumes (for output) and the total slices in slabs (for output size)\
		int nSlices=0;
		int nVols=0;
		int nRows=0;
		int nCols=0;
		int nComp=0;
		String baseName = null;
		for(File f: inputFiles.getValue()){
			ImageData vol = rw.read(f);
			if(baseName==null)
				baseName =  vol.getName();
			nRows=vol.getRows();
			nCols=vol.getCols();
			nVols = vol.getComponents();
			nSlices+=vol.getSlices();
			vol.dispose();
			vol=null;			
		}
		if(use4D){
			nComp=nVols;
			nVols=1;
		} else
			nComp=1;


		// Now construct the output
		outVols = new ArrayList<File>();
		ImageData outputVol=null;
		String basename = null;
		for(int jVol=0;jVol<nVols;jVol++) {
			
			int lastSlabEndSlice=-1;
			int startSlice=0, endSlice=0;
			outputVol = null;
			outputVol=new ImageDataMipav(baseName+"_Vol_"+jVol,
					nRows,nCols,nSlices,nComp);
			for(File f: inputFiles.getValue()){

				ImageData vol = rw.read(f);
				if(basename==null) {
					basename=vol.getName();
					outputVol.setHeader(vol.getHeader());
				}

				startSlice = lastSlabEndSlice+1;
				endSlice = startSlice+vol.getSlices()-1;
				lastSlabEndSlice=endSlice;
				if(use4D){
					for(int i=0;i<vol.getRows();i++)
						for(int j=0;j<vol.getCols();j++) {
							int jSlice=0;					
							for(int k=startSlice;k<=endSlice;k++) {
								for(int kComp=0;kComp<vol.getComponents();kComp++)
									outputVol.set(i,j,k,kComp,vol.getFloat(i, j, jSlice,kComp));
								jSlice++;
							}
						}	
				}else{
					for(int i=0;i<vol.getRows();i++)
						for(int j=0;j<vol.getCols();j++) {
							int jSlice=0;					
							for(int k=startSlice;k<=endSlice;k++) {
								outputVol.set(i,j,k,0,vol.getFloat(i, j, jSlice,jVol));
								jSlice++;
							}
						}			
				}
				vol.dispose();
				vol=null;			
			}
			File target=rw.write(outputVol, this.getOutputDirectory());
			if(!use4D) {
			outputVol.dispose();
			outputVol=null;
			}
			outVols.add(target);
		}
		
		outputFiles.setValue(outVols);
		if(use4D && outputVol!=null) {
			outputVol.setName(basename + "_4D");
			output4d.setValue(outputVol);
		}
	}
}
