package edu.jhu.ece.iacl.plugins.utilities.volume;

import edu.jhu.ece.iacl.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.pipeline.parameter.*;
import edu.jhu.ece.iacl.structures.image.*;
import edu.jhmi.rad.medic.utilities.CropParameters;
import edu.jhmi.rad.medic.utilities.CubicVolumeCropper;
import gov.nih.mipav.model.structures.ModelImage;
import java.util.*;

import javax.vecmath.Point3i;

/**
 * Image Cropper
 * @author Navid Shiee
 *
 */
public class MedicAlgorithmMultiCrop extends ProcessingAlgorithm{
	
	private ParamVolumeCollection inputVol;
			
	private ParamVolumeCollection outputVol;
	
	private ParamInteger borderSize;
	
	private ParamDouble threshold;
	private ParamPointInteger offset;
	private ParamPointInteger dim;
	/**
	 * Create input parameters for Cropper :cubic volume and borderSize
	 */
	public MedicAlgorithmMultiCrop(){
		setName("Multi-Crop");
	}
	protected void createInputParameters(ParamCollection inputParams) {
		inputVol = new ParamVolumeCollection("Volume Collection", null,-1,-1,-1,-1);
		borderSize = new ParamInteger("BorderSize", 0, Integer.MAX_VALUE);
		borderSize.setValue(3);
		threshold = new ParamDouble("Threshold", 0, Integer.MAX_VALUE);
		threshold.setValue(0);
		inputParams.add(inputVol);
		inputParams.add(threshold);
		inputParams.add(borderSize);
		inputParams.setLabel("Multi-Crop");
		inputParams.setCategory("IACL.Utilities.Volume");
		inputParams.setName("mcrop");
	}

	/**
	 * Create output parameters for Image Cropper: cubic volume and extents
	 */
	protected void createOutputParameters(ParamCollection outputParams) {
/*		for (int i=0; i<6; i++){
			borders[i]= new ParamInteger("border",0,Integer.MAX_VALUE);
			outputParams.add(borders[i]);
		}*/
		offset=new ParamPointInteger("Offset");
		dim=new ParamPointInteger("Dimensions");
		outputParams.add(offset);
		outputParams.add(dim);
		outputVol = new ParamVolumeCollection(null,-1,-1,-1,-1);
		outputVol.setName("cropped");
		outputVol.setLabel("Cropped Image");
		outputParams.add(outputVol);
	}

	/**
	 * Execute Image Cropper
	 */
	protected void execute(CalculationMonitor monitor) {

		CubicVolumeCropper cropper = new CubicVolumeCropper();
		monitor.observe(cropper);
		List<ImageData> result = cropper.crop(inputVol.getImageDataList(),threshold.getValue().floatValue(),borderSize.getValue().intValue());
		CropParameters params=cropper.getLastCropParams();
		if(result.size()>0){
			
			offset.setValue(new Point3i(params.xmin,params.ymin,params.zmin));	
			dim.setValue(new Point3i(params.getCroppedRows(),params.getCroppedCols(),params.getCroppedSlices()));
		}
		outputVol.setValue(result);
	}


}
