package edu.jhu.ece.iacl.plugins.utilities.volume;

import edu.jhu.ece.iacl.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.pipeline.parameter.ParamVolume;
import edu.jhu.ece.iacl.structures.image.ImageData;
import edu.jhu.ece.iacl.structures.image.ImageDataMipav;

public class MedicAlgorithmReverseComponents extends ProcessingAlgorithm{
	private ParamVolume inVol;
	private ParamVolume outVol;
	protected void createInputParameters(ParamCollection inputParams) {
		inputParams.add(inVol=new ParamVolume("Input Volume",null,-1,-1,-1,-1));
		inputParams.setLabel("Reverse Components");
		inputParams.setName("revcomp");
		inputParams.setCategory("IACL.Utilities.Volume");
	}

	@Override
	protected void createOutputParameters(ParamCollection outputParams) {
		outputParams.add(outVol=new ParamVolume("Output Volume",null,-1,-1,-1,-1));
		outputParams.setLabel("Reverse Components");
		outputParams.setName("revcomp");
	}

	@Override
	protected void execute(CalculationMonitor monitor) {
		ImageData vol=inVol.getImageData();
		int rows=vol.getCols();
		int cols=vol.getSlices();
		int slices=vol.getComponents();
		int comps=vol.getRows();
		ImageData volOut=new ImageDataMipav(vol.getName()+"_rev",vol.getType(),rows,cols,slices,comps);
		volOut.setName(vol.getName()+"_rev");
		for(int i=0;i<rows;i++){
			for(int j=0;j<cols;j++){
				for(int k=0;k<slices;k++){
					for(int c=0;c<comps;c++){
						volOut.set(i, j, k, c, vol.getDouble(c, i, j, k));
					}
				}
			}
		}
		outVol.setValue(volOut);
	}

}
