package edu.jhu.ece.iacl.plugins.utilities.volume;

import java.util.ArrayList;
import java.util.List;

import javax.vecmath.Point3i;

import edu.jhu.ece.iacl.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.pipeline.parameter.*;
import edu.jhu.ece.iacl.structures.image.*;
//import edu.jhu.ece.iacl.pipeline.view.input.ParamNumberSliderInputView;
import edu.jhmi.rad.medic.utilities.CropParameters;
import edu.jhmi.rad.medic.utilities.CubicVolumeCropper;
/**
 * Utitlity for uncropping images by adding given rows,columns and slices to original image
 * 
 * @author Navid Shiee
 *
 */
public class MedicAlgorithmUncrop extends ProcessingAlgorithm{

	private ParamVolumeCollection inputVol;
	private ParamVolumeCollection outputVol;
	private ParamPointInteger offset;
	private ParamPointInteger dim;
	private ParamDouble BackGround ;
	
	/**
	 * Create input parameters for Uncropper :cubic volume,number of rows,
	 * columns and slices need to be added on each side and 
	 * BackGround value
	 */

	protected void createInputParameters(ParamCollection inputParams){
		
		inputVol = new ParamVolumeCollection("Input Volumes");

		inputParams.add(inputVol);
		offset=new ParamPointInteger("Offset");
		dim=new ParamPointInteger("Dimensions",new Point3i(256,256,198));
		inputParams.add(offset);
		inputParams.add(dim);
		BackGround = new ParamDouble("Background Value", 0.0, Double.MAX_VALUE);
		BackGround.setValue(0.0);
		inputParams.add(BackGround);
		inputParams.setCategory("IACL.Utilities.Volume");
		inputParams.setLabel("Uncrop");
		inputParams.setName("uncrop");
	}

	/**
	 * Create output parameters for Image UnCropper: cubic volume
	 */
	protected void createOutputParameters(ParamCollection outputParams) {
		outputVol = new ParamVolumeCollection("Uncropped Images");
		outputVol.setLabel("Uncropped Image");
		outputVol.setName("uncropped");
		outputParams.add(outputVol);
	}

	/**
	 * Exectue Image UnCropper
	 */
	protected void execute(CalculationMonitor monitor) {

		CubicVolumeCropper uncrop = new CubicVolumeCropper();
		monitor.observe(uncrop);
		List<ImageData> vols=inputVol.getImageDataList();
		Point3i d=dim.getValue();
		Point3i off=offset.getValue();
		if(vols.size()>0){
			ImageData vol=vols.get(0);
			CropParameters params=new CropParameters(d.x,d.y,d.z,vol.getComponents(),off.x,vol.getRows()+off.x-1,off.y,vol.getCols()+off.y-1,off.z,vol.getSlices()+off.z-1,BackGround.getDouble());
			List<ImageData> result=uncrop.uncrop(vols, params);
			int i=0;
			for(ImageData r:result){
				r.setName(vols.get(i++).getName()+"_uncrop");
			}
			outputVol.setValue(result);
		}
	}

}
