package edu.jhu.ece.iacl.plugins.utilities.volume;
import edu.jhu.bme.smile.commons.math.HistogramGenerator;
import edu.jhu.ece.iacl.io.ArrayDoubleTxtReaderWriter;
import edu.jhu.ece.iacl.pipeline.AlgorithmRuntimeException;
import edu.jhu.ece.iacl.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.pipeline.parameter.*;
import edu.jhu.ece.iacl.plugins.MapsUtil;
import edu.jhu.ece.iacl.structures.image.ImageData;
import edu.jhu.ece.iacl.structures.image.ImageDataColor;
import edu.jhu.ece.iacl.structures.image.VoxelType;

public class MedicAlgorithmVolumeHistogram extends ProcessingAlgorithm{
	protected ParamVolume vol;
	protected ParamInteger bins;
	protected ParamDouble min,max;
	protected ParamBoolean logScale,autoMinMax,robustMinMax,yLogScale;
	protected ParamInteger rows,cols;
	protected ParamObject<double[][]> histogram;
	protected ParamVolume histImg;
	protected void createInputParameters(ParamCollection inputParams) {
		algorithmInformation.setDescription("Computes a histogram for a volume.");
		algorithmInformation.setVersion(MapsUtil.parseCVSRevision("$Revision: 1.1 $"));
		inputParams.add(vol=new ParamVolume("Volume"));
		inputParams.add(bins=new ParamInteger("Number of bins",1,10000000,256));
		inputParams.add(logScale=new ParamBoolean("Log Scale"));
		inputParams.add(min=new ParamDouble("Min"));
		inputParams.add(max=new ParamDouble("Max"));
		inputParams.add(autoMinMax=new ParamBoolean("Auto Min/Max",true));
		inputParams.add(robustMinMax=new ParamBoolean("Robust Min/Max"));
		inputParams.add(rows=new ParamInteger("Image Width",0,1600,800));
		inputParams.add(cols=new ParamInteger("Image Height",0,1600,600));
		inputParams.add(yLogScale=new ParamBoolean("Probability in Log Scale",true));
		inputParams.setName("surf_hist");
		inputParams.setLabel("Volume Histogram");
		inputParams.setCategory("IACL.Measurement.Statistics");
	}

	protected void createOutputParameters(ParamCollection outputParams) {
		outputParams.add(histogram=new ParamObject<double[][]>("Histogram",new ArrayDoubleTxtReaderWriter()));
		outputParams.add(histImg=new ParamVolume("Histogram Image",VoxelType.COLOR_FLOAT));
	}

	protected void execute(CalculationMonitor monitor)
			throws AlgorithmRuntimeException {
		HistogramGenerator hist=new HistogramGenerator();
		monitor.observe(hist);
		hist.setBins(bins.getInt());
		hist.setLogScale(logScale.getValue());
		hist.setMin(min.getDouble());
		hist.setMax(max.getDouble());
		hist.setAutoMinMax(autoMinMax.getValue());
		hist.setRobustMinMax(robustMinMax.getValue());
		ImageData img=vol.getImageData();
		double[][] histData=hist.solve(img);
		histogram.setFileName(img.getName()+"_hist");
		histogram.setObject(histData);
		ImageDataColor imgData=hist.getImage("Histogram for "+img.getName(),"Intensity",yLogScale.getValue(),rows.getInt(),cols.getInt());
		imgData.setName(img.getName()+"_plot");
		histImg.setValue(imgData);
	}

}
