package edu.jhu.cs.cisst.algorithms.geometry.surface;

import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;

import javax.vecmath.Point2f;
import javax.vecmath.Vector2f;

import edu.jhu.cs.cisst.algorithms.segmentation.gac.GeodesicActiveContour2D;
import edu.jhu.cs.cisst.algorithms.segmentation.gac.GridPoint2D;
import edu.jhu.cs.cisst.algorithms.segmentation.gac.TopologyPreservationRule2D;
import edu.jhu.cs.cisst.algorithms.util.DataOperations;
import edu.jhu.ece.iacl.jist.pipeline.AbstractCalculation;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataFloat;

public class IsoContourGeneratorGAC extends IsoContourGenerator {
	public IsoContourGeneratorGAC() {
		super();
		setLabel("Iso-Surface");
	}

	public IsoContourGeneratorGAC(TopologyPreservationRule2D.Rule rule) {
		super();
		this.rule = rule;
		setLabel("Iso-Surface");
	}

	public IsoContourGeneratorGAC(AbstractCalculation parent,
			TopologyPreservationRule2D.Rule rule) {
		super(parent);
		this.rule = rule;
		setLabel("Iso-Surface");
	}

	public ContourArray solve(GeodesicActiveContour2D gac) {
		vertCount = 0;
		this.isoLevel = 0;
		resX = resY = 1;
		this.imgMat = gac.getLevelSet().toArray2d();
		this.rows = imgMat.length;
		this.cols = imgMat[0].length;

		setTotalUnits(rows);
		Hashtable<Long, EdgeSplit> splits = new Hashtable<Long, EdgeSplit>();
		LinkedList<Edge> edges = new LinkedList<Edge>();
		// Set mesh resolutions
		List<GridPoint2D> activePoints = gac.getActivePoints();
		List<GridPoint2D>[] insidePoints = gac.getInsidePoints();
		List<GridPoint2D>[] outsidePoints = gac.getOutsidePoints();
		for (GridPoint2D gridPoint : activePoints) {
			processSquare(gridPoint.x, gridPoint.y, splits, edges);
			if (!silent)
				incrementCompletedUnits();
		}
		for (int n = 0; n < 3; n++) {
			for (GridPoint2D gridPoint : insidePoints[n]) {
				processSquare(gridPoint.x, gridPoint.y, splits, edges);
				if (!silent)
					incrementCompletedUnits();
			}
			for (GridPoint2D gridPoint : outsidePoints[n]) {
				processSquare(gridPoint.x, gridPoint.y, splits, edges);
				if (!silent)
					incrementCompletedUnits();
			}
		}
		EdgeSplit[] pts = new EdgeSplit[splits.size()];
		for (EdgeSplit split : splits.values()) {
			pts[split.vid] = split;
		}
		// Generate iso-surface from list of triangles
		int[] indexes = new int[edges.size() * 2];
		Point2f[] points = new Point2f[splits.size()];
		int index = 0;
		if (winding == Winding.CLOCKWISE) {
			for (Edge edge : edges) {
				indexes[index++] = edge.vids[0];
				indexes[index++] = edge.vids[1];
			}
		} else if (winding == Winding.COUNTER_CLOCKWISE) {
			for (Edge edge : edges) {
				indexes[index++] = edge.vids[1];
				indexes[index++] = edge.vids[0];
			}
		}
		index = 0;
		for (EdgeSplit split : splits.values()) {
			index = split.vid;
			points[index] = split.pt2d;
		}
		volMat = null;
		// Create surface
		ContourArray contour = new ContourArray(points, indexes);
		return contour;
	}

	public ContourArray solve(ImageDataFloat vol) {
		vertCount = 0;
		this.isoLevel = 0;
		this.imgMat = vol.toArray2d();
		rows = vol.getRows();
		cols = vol.getCols();

		resX = resY = 1;
		setTotalUnits(rows);
		Hashtable<Long, EdgeSplit> splits = new Hashtable<Long, EdgeSplit>();
		LinkedList<Edge> edges = new LinkedList<Edge>();
		// Set mesh resolutions
		for (int i = 0; i < rows; i++) {
			for (int j = 0; j < cols; j++) {
				// Get the image values at the corners of the square.
				processSquare(i, j, splits, edges);
			}
			if (!silent)
				incrementCompletedUnits();
		}
		EdgeSplit[] pts = new EdgeSplit[splits.size()];
		for (EdgeSplit split : splits.values()) {
			pts[split.vid] = split;
		}
		// Generate iso-surface from list of triangles
		int[] indexes = new int[edges.size() * 2];
		Point2f[] points = new Point2f[splits.size()];
		int index = 0;
		
		
		if (winding == Winding.CLOCKWISE) {
			for (Edge edge : edges) {
				indexes[index++] = edge.vids[0];
				indexes[index++] = edge.vids[1];
			}
		} else if (winding == Winding.COUNTER_CLOCKWISE) {
			for (Edge edge : edges) {
				indexes[index++] = edge.vids[1];
				indexes[index++] = edge.vids[0];
			}
		}
		index = 0;
		for (EdgeSplit split : splits.values()) {
			index = split.vid;
			points[index] = split.pt2d;
		}
		volMat = null;
		// Create surface
		ContourArray contour = new ContourArray(points, indexes);
		
		return contour;
	}
}
