package edu.jhu.cs.cisst.jist.pipeline.io;

import java.io.File;

import processing.core.PApplet;
import processing.core.PImage;
import edu.jhu.ece.iacl.jist.io.FileExtensionFilter;
import edu.jhu.ece.iacl.jist.io.FileReaderWriter;

public class PImageReaderWriter extends FileReaderWriter<PImage> {
	final static PApplet applet = new PApplet();
	protected FileExtensionFilter extensionFilter;

	public PImageReaderWriter() {
		super(new FileExtensionFilter(new String[] { "png" }));
	}

	@Override
	protected PImage readObject(File f) {
		PImage img = applet.loadImage(f.getAbsolutePath());
		return img;
	}

	@Override
	protected File writeObject(PImage img, File f) {
		try {
			if (img.parent == null)
				img.parent = applet;
			img.save(f.getAbsolutePath());
			return f;
		} catch (Exception e) {
			e.printStackTrace();
			return null;
		}
	}

	public void setExtensionFilter(FileExtensionFilter extensionFilter) {
		this.extensionFilter = extensionFilter;
	}

	public FileExtensionFilter getExtensionFilter() {
		return extensionFilter;
	}
}
