package edu.jhu.ece.iacl.algorithms.registration;

import edu.jhu.ece.iacl.jist.structures.image.ImageData;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataFloat;

public class SmoothDefField {
	/* CVS Version Info
	   $Id: SmoothDefField.java,v 1.2 2012/03/01 21:22:00 mchen55 Exp $
	 */

	/* poisson.c */
	/* Written by Xiao Han */

	/* Solve Poisson Equation using Multigrid techniques.
	 * The equation to solve is given by
	 * div( g(x) \nabla u(x)) - h(x) (u - f(x)) = 0, which
	 * is the GGVF equation
	 * For convenience, in the program, g(x) is called weight,
	 * h is called hu
	 */

	boolean JACOBI=false; 

	static int maxlevel;
	static int n1, n2;

	float[][][][] inField;
	ImageData inImage;
	//ImageData subject,target;
	public SmoothDefField(ImageData In){//, ImageData subject, ImageData target){
		//THESE FUNCTIONS RUN ON REVERSE INDEXING FOR ITS VOLUMES, [Z][Y][X], SO WE MUST CONVERT INPUT FIRST:

		int XN = In.getRows();
		int YN = In.getCols();
		int ZN = In.getSlices();
		this.inField = new float[ZN][YN][XN][3];
		this.inImage = In;
		//this.subject = subject;
	//	this.target = target;
		for(int i = 0; i<XN;i++)
			for(int j = 0; j<YN;j++)
				for(int k = 0; k<ZN;k++)
					for(int c = 0; c<3;c++){
						this.inField[k][j][i][c] = In.getFloat(i, j, k, c);
					}


	}


	public ImageData smoothDefField(){
		int XN = inImage.getRows();
		int YN = inImage.getCols();
		int ZN = inImage.getSlices();

		float[][][][] outField = new float[ZN][YN][XN][3];
		float[][][] similarityVolume = new float[ZN][YN][XN];
		double x,y,z;
		double[] max = new double[3];
		double[] min = new double[3];
		for(int c=0;c<3;c++){
			max[c] = Double.MIN_VALUE;
			min[c] = Double.MAX_VALUE;
		} 
		float[][][] SqrMagf  = new float[ZN][YN][XN];
		int W = 25;
		int W_0 = 3;
		for(int i = 0; i<XN;i++)
			for(int j = 0; j<YN;j++)
				for(int k = 0; k<ZN;k++){

				//	if((Math.max(inField[k][j][i][0],Math.max(inField[k][j][i][1],inField[k][j][i][2]))>0) ||
					//		target.getInt(i,j,k) == 0 || subject.getInt( i, j, k) == 0){
						//similarityVolume[k][j][i] = 1f;
					//	}
					
					/************
					
					if(i < W || i > XN - W || j < W || j > YN - W ||  k < W || k > ZN - W){						
						for(int q=0; q < 3; q ++)inField[k][j][i][q] = 0;
						
					}
					*/
					x = inField[k][j][i][0];
					if(x > max[0]) max[0] = x;
					if(x < min[0]) min[0] = x;
					y = inField[k][j][i][1];
					if(y > max[1]) max[1] = y;
					if(y < min[1]) min[1] = y;
					z = inField[k][j][i][2];
					if(z > max[2]) max[2] = z;
					if(z < min[2]) min[2] = z;
					
					SqrMagf[k][j][i] = (float)Math.sqrt(x*x + y*y + z*z);
					/*
					if(i < W_0 || i > XN - W_0 || j < W_0 || j > YN - W_0 ||  k < W_0 || k > ZN - W_0){
						SqrMagf[k][j][i] = 100;
					}else{
						SqrMagf[k][j][i] = (float)Math.sqrt(x*x + y*y + z*z);
					}
					*/
				}
		
		
	/*	for(int i = 0; i<XN;i++)
			for(int j = 0; j<YN;j++)
				for(int k = 0; k<ZN;k++){
					for(int c = 0; c < 3; c++) inField[k][j][i][c] -= min[c];
					for(int c = 0; c < 3; c++) inField[k][j][i][c] /= (max[c]-min[c]);
				}
	*/
		//smoothAll(outField, inField, similarityVolume, .8f);
		float lambda = .0001f;
		outField = scaleFlowGen(outField, inField, SqrMagf, lambda, ZN,YN,XN);
		
		
		ImageData outImage = new ImageDataFloat(XN,YN,ZN,3); 

		for(int i = 0; i<XN;i++)
			for(int j = 0; j<YN;j++)
				for(int k = 0; k<ZN;k++)
					for(int c = 0; c<3;c++){
						outImage.set(i,j,k,c, outField[k][j][i][c]);//*(max[c]-min[c])+min[c]);
					}

		return outImage;

	}

	
	
	
	float[][][][] scaleFlowGen(float[][][][] V, float[][][][] Gf, float[][][] SqrMagf, 
			float lambda, int ZN, int YN, int XN)
	{
		int i, x, y, z;
		double sqrmagf;
		float lambda2;
		float[][][] U, f, g, h;

		lambda2 = lambda*lambda;

		U = new float[ZN][YN][XN];//pgFcube(0,ZN-1, 0,YN-1, 0,XN-1);
		f = new float[ZN][YN][XN];//pgFcube(0,ZN-1, 0,YN-1, 0,XN-1);
		g = new float[ZN][YN][XN];//pgFcube(0,ZN-1, 0,YN-1, 0,XN-1);
		h = new float[ZN][YN][XN];//pgFcube(0,ZN-1, 0,YN-1, 0,XN-1);

		for (z=0; z<ZN; z++)
			for (y=0; y<YN; y++)
				for (x=0; x<XN; x++){
					sqrmagf = SqrMagf[z][y][x];
					g[z][y][x] = (float)Math.exp(-sqrmagf/lambda2);
					h[z][y][x] = 1 - g[z][y][x];
					g[z][y][x] /= 6.0;
					f[z][y][x] = 0 - h[z][y][x]*Gf[z][y][x][0];
					U[z][y][x] = Gf[z][y][x][0];
				}


		//printf("Solve the x-component\n");
		multigrid(U, f, g, h, XN, YN, ZN);

		for (z=0; z<ZN; z++)
			for (y=0; y<YN; y++)
				for (x=0; x<XN; x++){
					V[z][y][x][0] = U[z][y][x];
					f[z][y][x] = 0 - h[z][y][x]*Gf[z][y][x][1];
					U[z][y][x] = Gf[z][y][x][1];
				}

		//printf("Solve the y-component\n");
		multigrid(U, f, g, h, XN, YN, ZN);
		for (z=0; z<ZN; z++)
			for (y=0; y<YN; y++)
				for (x=0; x<XN; x++){
					V[z][y][x][1] = U[z][y][x];
					f[z][y][x] = 0- h[z][y][x]*Gf[z][y][x][2];
					U[z][y][x] = Gf[z][y][x][2];
				}

		//printf("Solve the z-component\n");
		multigrid(U, f, g, h, XN, YN, ZN);

		for (z=0; z<ZN; z++)
			for (y=0; y<YN; y++)
				for (x=0; x<XN; x++){
					V[z][y][x][2] = U[z][y][x];
				}

		/*
		pgFreeFcube(U, 0,ZN-1, 0,YN-1, 0,XN-1);
		pgFreeFcube(f, 0,ZN-1, 0,YN-1, 0,XN-1);
		pgFreeFcube(g, 0,ZN-1, 0,YN-1, 0,XN-1);
		pgFreeFcube(h, 0,ZN-1, 0,YN-1, 0,XN-1);
		 */
		return V;
	}


	/* Function PGfloat3d ***smoothAll(PGfloat3d ***V, PGfloat3d ***Gf, PGbyte ***deformedVoxelsVolume, float smoothing) smooths the displacement field Gf by solving the equation 
	 *  smoothing*(\nabla V)^2 - similarityVolume*(V-Gf) = 0   
	 * V: 3 dimensional float volume.  Contains the resulting displacement field after GVF smoothing
	 * Gf: 3 dimensional float volume.  Contains the displacement field that will be smoothed
	 * similarityVolume: Float volume, which stores the similarity values for each template voxel.  If the voxel (x, y, z) is not a driving voxel the value of similarityVolume(x, y, z) = 0.  Used to control the smoohting of the displacement field: high similarity value -> less smoothing.
	 * smoothing: Smoothing factor, higher value puts more weight on the laplacian, i.e. more smoothing.
	 * returns: 3d float volume V of GVF smoothed displacement field.
	 */
	void smoothAll(float[][][][] V, float[][][][] Gf, float[][][] similarityVolume, float smoothing)
	{
		int x, y, z;

		//THESE FUNCTIONS RUN ON REVERSE INDEXING FOR ITS VOLUMES, [Z][Y][X]

		//  float[][][] U, ***f, ***g, ***h;
		float[][][] U, f, g;
		int zsize = Gf.length;
		int ysize = Gf[0].length;
		int xsize = Gf[0][0].length;
		U = new float[zsize][ysize][xsize];// )pgFcube(0,zsize-1, 0,ysize-1, 0,xsize-1);
		f = new float[zsize][ysize][xsize];// )pgFcube(0,zsize-1, 0,ysize-1, 0,xsize-1);
		g = new float[zsize][ysize][xsize];// )pgFcube(0,zsize-1, 0,ysize-1, 0,xsize-1);

		for (z=0; z<zsize; z++){
			for (y=0; y<ysize; y++){
				for (x=0; x<xsize; x++){
					g[z][y][x] = smoothing;
					f[z][y][x] = 0 - similarityVolume[z][y][x]*Gf[z][y][x][0];
					U[z][y][x] = Gf[z][y][x][0];
				}
			}
		}


		//  printf("Solve the x-component\n");
		multigrid(U, f, g, similarityVolume, xsize, ysize, zsize);
		for (z=0; z<zsize; z++){
			for (y=0; y<ysize; y++){
				for (x=0; x<xsize; x++){
					V[z][y][x][0] = U[z][y][x];
					f[z][y][x] = 0 - similarityVolume[z][y][x]*Gf[z][y][x][1];
					U[z][y][x] = Gf[z][y][x][1];
				}
			}
		}

		//  printf("Solve the y-component\n");
		multigrid(U, f, g, similarityVolume, xsize, ysize, zsize);
		for (z=0; z<zsize; z++){
			for (y=0; y<ysize; y++){
				for (x=0; x<xsize; x++){
					V[z][y][x][1] = U[z][y][x];
					f[z][y][x] = 0 - similarityVolume[z][y][x]*Gf[z][y][x][2];
					U[z][y][x] = Gf[z][y][x][2];
				}
			}
		}

		//  printf("Solve the z-component\n");
		multigrid(U, f, g, similarityVolume, xsize, ysize, zsize);

		for (z=0; z<zsize; z++){
			for (y=0; y<ysize; y++){
				for (x=0; x<xsize; x++){
					V[z][y][x][2] = U[z][y][x];
				}
			}
		}

		//pgFreeFcube(U, 0,zsize-1, 0,ysize-1, 0,xsize-1);
		//pgFreeFcube(f, 0,zsize-1, 0,ysize-1, 0,xsize-1);
		//pgFreeFcube(g, 0,zsize-1, 0,ysize-1, 0,xsize-1);


	}


	void rstrct2(float[][][] out, float[][][] in, int Xo, int Yo, int Zo, 
			int Xi, int Yi, int Zi){
		int inew, jnew, knew, ic, jc, kc;
		float scalex, scaley, scalez, wx, wy,wz, tmpv;
		float zn, z0,z1,z2,yn,y0,y1,y2, xn, x0,x1,x2;
		int prevz, prevy, prevx, nextx1,nextx2, nexty1,nexty2, nextz1, nextz2;

		scalex = (float)((Xi-1.0)/(Xo - 1.0));
		scaley = (float)((Yi-1.0)/(Yo-1.0));
		scalez = (float)((Zi-1.0)/(Zo-1.0));

		for(knew = 0; knew < Zo; knew++){
			tmpv = (float)knew*scalez;
			kc = (int)Math.floor(tmpv);
			wz = tmpv - (float)kc;
			if(knew == 0){
				zn = 0.25f; z0 = 0.5f; z1 = 0.25f; z2 = 0;
				prevz = 0; kc = 0; nextz1 = 1; nextz2 = 1;
			}else if(knew == (Zo-1)){
				zn = 0.25f; z0 = 0.5f; z1 = 0.25f; z2 = 0;
				prevz = Zi-2; kc = Zi-1; nextz1 = Zi-1; nextz2 = Zi-1;
			}
			else{
				zn =  (float)((1.0-wz)*0.25); z0 =  (float)((2.0 - wz)*0.25);
				z1 =  (float)((1.0+wz)*0.25); z2 =  (float)(wz*0.25);
				prevz = kc-1; nextz1 = kc+1; nextz2 = kc+2;
			}
			for(inew = 0; inew < Yo; inew++){
				tmpv = (float)inew*scaley;
				ic = (int)Math.floor(tmpv);
				wy = tmpv - (float)ic;
				if(inew == 0){
					yn = 0.25f; y0 = 0.5f; y1 = 0.25f; y2 = 0;
					prevy = 0; ic = 0; nexty1 = 1; nexty2 = 1;
				}else if(inew == (Yo-1)){
					yn = 0.25f; y0 = 0.5f; y1 = 0.25f; y2 = 0;
					prevy = Yi-2; ic = Yi-1; nexty1 = Yi-1; nexty2 = Yi-1;
				}
				else{
					yn = (float)((1.0-wy)*0.25); y0 = (float)((2.0 - wy)*0.25);
					y1 = (float)((1.0+wy)*0.25); y2 = (float)(wy*0.25);
					prevy = ic-1; nexty1 = ic+1; nexty2 = ic+2;
				} 
				for(jnew =0; jnew < Xo; jnew++){
					tmpv = (float)jnew*scalex;
					jc = (int)Math.floor(tmpv);
					wx = tmpv - (float)jc;
					if(jnew == 0){
						xn = 0.25f; x0 = 0.5f; x1 = 0.25f; x2 = 0;
						prevx = 0; jc = 0; nextx1 = 1; nextx2 = 1;
					}else if(jnew == (Xo-1)){
						xn = 0.25f; x0 = 0.5f; x1 = 0.25f; x2 = 0;
						prevx = Xi-2; jc = Xi-1; nextx1 = Xi-1; nextx2 = Xi-1;
					}
					else{
						xn = (float)((1.0-wx)*0.25); x0 = (float)((2.0 - wx)*0.25);
						x1 = (float)((1.0+wx)*0.25); x2 = (float)(wx*0.25);
						prevx = jc-1; nextx1 = jc+1; nextx2 = jc+2;
					}

					tmpv = zn*(yn*(xn*in[prevz][prevy][prevx] + x0*in[prevz][prevy][jc] + x1*in[prevz][prevy][nextx1] + x2*in[prevz][prevy][nextx2])
							+ y0*(xn*in[prevz][ic][prevx] + x0*in[prevz][ic][jc] + x1*in[prevz][ic][nextx1] + x2*in[prevz][ic][nextx2])
							+ y1*(xn*in[prevz][nexty1][prevx] + x0*in[prevz][nexty1][jc] + x1*in[prevz][nexty1][nextx1] + x2*in[prevz][nexty1][nextx2])
							+ y2*(xn*in[prevz][nexty2][prevx] + x0*in[prevz][nexty2][jc] + x1*in[prevz][nexty2][nextx1] + x2*in[prevz][nexty2][nextx2]));

					tmpv += z0*(yn*(xn*in[kc][prevy][prevx] + x0*in[kc][prevy][jc] + x1*in[kc][prevy][nextx1] + x2*in[kc][prevy][nextx2])
							+ y0*(xn*in[kc][ic][prevx] + x0*in[kc][ic][jc] + x1*in[kc][ic][nextx1] + x2*in[kc][ic][nextx2])
							+ y1*(xn*in[kc][nexty1][prevx] + x0*in[kc][nexty1][jc] + x1*in[kc][nexty1][nextx1] + x2*in[kc][nexty1][nextx2])
							+ y2*(xn*in[kc][nexty2][prevx] + x0*in[kc][nexty2][jc] + x1*in[kc][nexty2][nextx1] + x2*in[kc][nexty2][nextx2]));

					tmpv += z1*(yn*(xn*in[nextz1][prevy][prevx] + x0*in[nextz1][prevy][jc] + x1*in[nextz1][prevy][nextx1] + x2*in[nextz1][prevy][nextx2])
							+ y0*(xn*in[nextz1][ic][prevx] + x0*in[nextz1][ic][jc] + x1*in[nextz1][ic][nextx1] + x2*in[nextz1][ic][nextx2])
							+ y1*(xn*in[nextz1][nexty1][prevx] + x0*in[nextz1][nexty1][jc] + x1*in[nextz1][nexty1][nextx1] + x2*in[nextz1][nexty1][nextx2])
							+ y2*(xn*in[nextz1][nexty2][prevx] + x0*in[nextz1][nexty2][jc] + x1*in[nextz1][nexty2][nextx1] + x2*in[nextz1][nexty2][nextx2]));

					tmpv += z2*(yn*(xn*in[nextz2][prevy][prevx] + x0*in[nextz2][prevy][jc] + x1*in[nextz2][prevy][nextx1] + x2*in[nextz2][prevy][nextx2])
							+ y0*(xn*in[nextz2][ic][prevx] + x0*in[nextz2][ic][jc] + x1*in[nextz2][ic][nextx1] + x2*in[nextz2][ic][nextx2])
							+ y1*(xn*in[nextz2][nexty1][prevx] + x0*in[nextz2][nexty1][jc] + x1*in[nextz2][nexty1][nextx1] + x2*in[nextz2][nexty1][nextx2])
							+ y2*(xn*in[nextz2][nexty2][prevx] + x0*in[nextz2][nexty2][jc] + x1*in[nextz2][nexty2][nextx1] + x2*in[nextz2][nexty2][nextx2]));

					out[knew][inew][jnew] = tmpv;

				}
			}
		}

		return;
	}

	void interp2(float[][][] out, float[][][] in, int Xo, int Yo, int Zo, 
			int Xi, int Yi, int Zi){

		int ic,jc,kc, nexti, nextj, nextk, i, j, k;
		float scalex, scaley, scalez;
		float s,t,w, tmpv;

		scalex = (float) ((Xi -1.0)/(Xo-1.0));
		scaley = (float) ((Yi-1.0)/(Yo-1.0));
		scalez = (float) ((Zi-1.0)/(Zo-1.0));

		for(k=0; k < Zo; k++){
			tmpv = (float)k*scalez;
			kc = (int)Math.floor(tmpv);
			w = tmpv - (float)kc;
			if(k==0){
				w=0; kc = 0; nextk=1;
			}else if(k == (Zo-1)){
				w=0; kc = Zi-1; nextk = Zi -1;
			}else{
				nextk = kc+1;
			}
			for(i=0; i < Yo; i++){
				tmpv = (float)i*scaley;
				ic = (int)Math.floor(tmpv);
				s = tmpv - (float)ic;
				if(i==0){
					s=0; ic = 0; nexti=1;
				}else if(i == (Yo-1)){
					s=0; ic = Yi-1; nexti = Yi -1;
				}else{
					nexti = ic+1;
				} 
				for(j=0; j < Xo; j++){
					tmpv = (float)j*scalex;
					jc = (int)Math.floor(tmpv);
					t = tmpv - (float)jc;
					if(j==0){
						t=0; jc = 0; nextj=1;
					}else if(j == (Xo-1)){
						t=0; jc = Xi-1; nextj = Xi -1;
					}else{
						nextj = jc+1;
					} 

					out[k][i][j] = (float) ((1.0-w)*((1.0-s)*((1.0-t)*in[kc][ic][jc] + t*in[kc][ic][nextj])
							+ s*((1.0 - t)*in[kc][nexti][jc] + t*in[kc][nexti][nextj]))
							+ w*((1.0-s)*((1.0-t)*in[nextk][ic][jc] + t*in[nextk][ic][nextj])
									+ s*((1.0 - t)*in[nextk][nexti][jc] + t*in[nextk][nexti][nextj])));

				}
			}
		}

		return;
	}

	void rstrct(float[][][] out, float[][][] in, int Xo, int Yo, int Zo, 
			int Xi, int Yi, int Zi){
		int inew, jnew, knew, iold, jold, kold;

		for(knew = 0; knew < Zo; knew++)
			for(inew = 0; inew < Yo; inew++)
				for(jnew =0; jnew < Xo; jnew++){
					kold = knew<<1; iold = inew <<1; jold = jnew<<1;
					if(kold > (Zi-2)) kold = Zi-2;
					if(iold > (Yi-2)) iold = Yi-2;
					if(jold > (Xi-2)) jold = Xi-2;

					out[knew][inew][jnew] = (float) 0.125*(in[kold][iold][jold]+in[kold][iold][jold+1]+in[kold][iold+1][jold]+in[kold][iold+1][jold+1] +
							in[kold+1][iold][jold]+in[kold+1][iold][jold+1]+in[kold+1][iold+1][jold]+in[kold+1][iold+1][jold+1]);

				}


		return;
	}

	void interp(float[][][] out, float[][][] in, int Xo, int Yo, int Zo, 
			int Xi, int Yi, int Zi){

		int ic,jc,kc, i,j,k;
		/*  int HX, HY, HZ; 	*/

		for(kc=0; kc < Zo; kc++)
			for(ic=0; ic < Yo; ic++)
				for(jc=0; jc < Xo; jc++){
					k = kc>>1; j = jc >> 1; i = ic >>1;
					/*		HX = (j == (Xi-1)); HY = (i == (Yi-1)); HZ = (k==(Zi-1));*/
					out[kc][ic][jc] = in[k][i][j]; /* 0.5*(in[k][i][j] + in[k+1-HZ][i+1-HY][j+1-HX]); */

				}
		return;
	}

	void addin(float[][][] uf, float[][][] uc, float[][][] res, int Xo, int Yo, int Zo, int Xi, int Yi, int Zi){
		int i,j,k;

		interp(res, uc, Xo, Yo,Zo, Xi,Yi,Zi);

		for(k=0; k < Zo; k++){
			for(i=0; i<Yo; i++){
				for(j=0; j< Xo; j++){
					uf[k][i][j] += res[k][i][j];
				}
			}
		}

		return;
	}

	void resid(float[][][] res, float[][][] u, float[][][] rhs, float[][][] w, float[][][] hu, int XN, int YN, int ZN, int lev){
		int i,j,k;
		int h;
		float cmu;

		int prek, nextk, prei, nexti, prej, nextj;

		h = 1<<(maxlevel-lev);
		h = h*h;
		cmu = (float)1.0/(float)h;

		/* If change to half-point symmetric extension, no longer converges */
		for(k=0;k<ZN; k++){
			prek = (k>0) ? (k-1) : 0;
			nextk = (k == (ZN-1)) ? (ZN-1) : (k+1);
			for(i=0; i<YN;i++){
				prei = (i>0) ? (i-1) : 0;
				nexti = (i == (YN-1)) ? (YN-1) : (i+1);

				for(j=0;j<XN;j++){
					prej = (j>0) ? (j-1) : 0;
					nextj = (j == (XN-1)) ? (XN-1) : (j+1);

					/* res[k][i][j] = hu[k][i][j]*u[k][i][j] + rhs[k][i][j] - 0.5*cmu*
		  (u[prek][i][j]*(w[prek][i][j]+w[k][i][j]) + 
		   u[nextk][i][j]*(w[nextk][i][j]+w[k][i][j]) +
		   u[k][prei][j]*(w[k][prei][j]+w[k][i][j]) +
		   u[k][nexti][j]*(w[k][nexti][j]+w[k][i][j]) +
		   u[k][i][prej]*(w[k][i][prej]+w[k][i][j]) +
		   u[k][i][nextj]*(w[k][i][nextj]+w[k][i][j]) -
		   u[k][i][j]*(6*w[k][i][j]+w[prek][i][j]+w[nextk][i][j]
			       + w[k][prei][j] + w[k][nexti][j]+w[k][i][prej]
			       + w[k][i][nextj])); */

					res[k][i][j] = hu[k][i][j]*u[k][i][j] + rhs[k][i][j] - 
					cmu*w[k][i][j]*
					(u[prek][i][j] + 
							u[nextk][i][j] +
							u[k][prei][j] +
							u[k][nexti][j] +
							u[k][i][prej] +
							u[k][i][nextj] -
							u[k][i][j]*6);
				}
			}
		}

		return;

	}


	void copymem(float[][][] out, float[][][] in, int XN, int YN, int ZN){
		int size;
		int k,i,j;

		// size = XN*YN*ZN*sizeof(PGfloat);

		//   With my Memory Allocation function, memory copy is wrong!
		//  memcpy((char *)&out[0][0][0], (char *)&in[0][0][0], size);


		for(k=0; k<ZN; k++)
			for(i=0;i <YN; i++)
				for(j=0; j<XN; j++){
					out[k][i][j] = in[k][i][j];
				}



		return;
	}

	void octant(float[][][] u, float[][][] rhs, float[][][] w, float[][][] hu, float hsquare, int XN, int YN, int ZN, int kc, int ic, int jc){

		int k, i, j;
		int prek, nextk, prei,nexti, prej, nextj;
		float tmpv;

		/* hsquare = 2*hsquare; For the first case that g is inside div() */

		for(k=kc; k<ZN; k += 2 ){
			prek = (k>0) ? (k-1) : 0;
			nextk = (k == (ZN-1)) ? (ZN-1) : (k+1);
			for(i=ic;i<YN; i+= 2){
				prei = (i>0) ? (i-1) : 0;
				nexti = (i == (YN-1)) ? (YN-1) : (i+1);

				for(j=jc;j<XN; j+= 2){
					prej = (j>0) ? (j-1) : 0;
					nextj = (j == (XN-1)) ? (XN-1) : (j+1);

					tmpv = hu[k][i][j]*hsquare;
					/* 
		u[k][i][j] = (u[prek][i][j]*(w[prek][i][j]+w[k][i][j]) + 
			      u[nextk][i][j]*(w[nextk][i][j]+w[k][i][j]) +
			      u[k][prei][j]*(w[k][prei][j]+w[k][i][j]) +
			      u[k][nexti][j]*(w[k][nexti][j]+w[k][i][j]) +
			      u[k][i][prej]*(w[k][i][prej]+w[k][i][j]) +
			      u[k][i][nextj]*(w[k][i][nextj]+w[k][i][j]) 
			      - rhs[k][i][j]*hsquare)/(6*w[k][i][j]+w[prek][i][j]+
								     w[nextk][i][j]
							 + w[k][prei][j] + w[k][nexti][j]+
							 w[k][i][prej] + w[k][i][nextj] + 
								     tmpv);
					 */

					u[k][i][j] = ((u[prek][i][j] + 
							u[nextk][i][j] +
							u[k][prei][j] +
							u[k][nexti][j] +
							u[k][i][prej] +
							u[k][i][nextj]) * w[k][i][j]               
							                          - rhs[k][i][j]*hsquare)/(6*w[k][i][j] + tmpv);

				}
			}
		}

		return;
	}


	/*kc = 1, ic = 1, jc = 1*/
	void octant111(float[][][] u, float[][][] rhs, float[][][] w, float[][][] hu, float hsquare, int XN, int YN, int ZN, int kc, int ic, int jc){

		int k, i, j;
		int prek, nextk, prei,nexti, prej, nextj;
		float tmpv;


		for(k=1; k<ZN; k += 2 ){
			prek = k-1;
			nextk = (k == (ZN-1)) ? (ZN-1) : (k+1);

			for(i=1;i<YN; i+= 2){
				prei = i-1;
				nexti = (i == (YN-1)) ? (YN-1) : (i+1);

				for(j=1;j<XN; j+= 2){
					prej = j-1;
					nextj = (j == (XN-1)) ? (XN-1) : (j+1);	
					tmpv = hu[k][i][j]*hsquare;
					u[k][i][j] = ((u[prek][i][j] + 
							u[nextk][i][j] +
							u[k][prei][j] +
							u[k][nexti][j] +
							u[k][i][prej] +
							u[k][i][nextj]) * w[k][i][j]               
							                          - rhs[k][i][j]*hsquare)/(6*w[k][i][j] + tmpv);

				}
			}
		}

		return;
	}


	/*kc = 1, ic = 1, jc = 0*/ /*DONE!!*/
	void octant110(float[][][] u, float[][][] rhs, float[][][] w, float[][][] hu, float hsquare, int XN, int YN, int ZN, int kc, int ic, int jc){

		int k, i, j;
		int prek, nextk, prei,nexti, prej, nextj;
		float tmpv;

		for(k=1; k<ZN; k += 2 ){
			prek = k-1;
			nextk = (k == (ZN-1)) ? (ZN-1) : (k+1);

			for(i=1;i<YN; i+= 2){
				prei = i-1;
				nexti = (i == (YN-1)) ? (YN-1) : (i+1);

				/*Compute for all j except j = 0*/
				for(j=2;j<XN; j+= 2){
					prej = j-1;
					nextj = (j == (XN-1)) ? (XN-1) : (j+1);	
					tmpv = hu[k][i][j]*hsquare;	
					u[k][i][j] = ((u[prek][i][j] + 
							u[nextk][i][j] +
							u[k][prei][j] +
							u[k][nexti][j] +
							u[k][i][prej] +
							u[k][i][nextj]) * w[k][i][j]               
							                          - rhs[k][i][j]*hsquare)/(6*w[k][i][j] + tmpv);

				}

				/*Compute for j = 0*/
				j = 0;
				prej = 0;
				nextj = j+1;	
				tmpv = hu[k][i][j]*hsquare;	
				u[k][i][j] = ((u[prek][i][j] + 
						u[nextk][i][j] +
						u[k][prei][j] +
						u[k][nexti][j] +
						u[k][i][prej] +
						u[k][i][nextj]) * w[k][i][j]               
						                          - rhs[k][i][j]*hsquare)/(6*w[k][i][j] + tmpv);


			}
		}

		return;
	}



	/*kc = 0, ic = 0, jc = 1*/  /*DONE!!*/
	void octant001(float[][][] u, float[][][] rhs, float[][][] w, float[][][] hu, float hsquare, int XN, int YN, int ZN, int kc, int ic, int jc){

		int k, i, j;
		int prek, nextk, prei,nexti, prej, nextj;
		float tmpv;

		/*Compute for all k except k = 0*/
		for(k=2; k<ZN; k += 2 ){
			prek = k-1;
			nextk = (k == (ZN-1)) ? (ZN-1) : (k+1);

			/*Compute for all i except i = 0*/
			for(i=2;i<YN; i+= 2){
				prei = i-1;
				nexti = (i == (YN-1)) ? (YN-1) : (i+1);

				for(j=1;j<XN; j+= 2){
					prej = j-1;
					nextj = (j == (XN-1)) ? (XN-1) : (j+1);	
					tmpv = hu[k][i][j]*hsquare;
					u[k][i][j] = ((u[prek][i][j] + 
							u[nextk][i][j] +
							u[k][prei][j] +
							u[k][nexti][j] +
							u[k][i][prej] +
							u[k][i][nextj]) * w[k][i][j]               
							                          - rhs[k][i][j]*hsquare)/(6*w[k][i][j] + tmpv);

				}
			}

			/*Compute for i = 0*/
			i = 0;
			prei = 0;
			nexti = i+1;

			for(j=1;j<XN; j+= 2){
				prej = j-1;
				nextj = (j == (XN-1)) ? (XN-1) : (j+1);	
				tmpv = hu[k][i][j]*hsquare;
				u[k][i][j] = ((u[prek][i][j] + 
						u[nextk][i][j] +
						u[k][prei][j] +
						u[k][nexti][j] +
						u[k][i][prej] +
						u[k][i][nextj]) * w[k][i][j]               
						                          - rhs[k][i][j]*hsquare)/(6*w[k][i][j] + tmpv);

			}

		}

		/*Compute for k = 0*/
		k = 0;
		prek = 0;
		nextk = k+1;

		/*Compute for all i except i = 0*/
		for(i=2;i<YN; i+= 2){
			prei = i-1;
			nexti = (i == (YN-1)) ? (YN-1) : (i+1);

			for(j=1;j<XN; j+= 2){
				prej = j-1;
				nextj = (j == (XN-1)) ? (XN-1) : (j+1);	
				tmpv = hu[k][i][j]*hsquare;
				u[k][i][j] = ((u[prek][i][j] + 
						u[nextk][i][j] +
						u[k][prei][j] +
						u[k][nexti][j] +
						u[k][i][prej] +
						u[k][i][nextj]) * w[k][i][j]               
						                          - rhs[k][i][j]*hsquare)/(6*w[k][i][j] + tmpv);

			}
		}

		/*Compute for i = 0*/
		i = 0;
		prei = 0;
		nexti = i+1;

		for(j=1;j<XN; j+= 2){
			prej = j-1;
			nextj = (j == (XN-1)) ? (XN-1) : (j+1);	
			tmpv = hu[k][i][j]*hsquare;
			u[k][i][j] = ((u[prek][i][j] + 
					u[nextk][i][j] +
					u[k][prei][j] +
					u[k][nexti][j] +
					u[k][i][prej] +
					u[k][i][nextj]) * w[k][i][j]               
					                          - rhs[k][i][j]*hsquare)/(6*w[k][i][j] + tmpv);

		}

		return;
	}



	/*kc = 1, ic = 0, jc = 1*/ /*DONE!!*/
	void octant101(float[][][] u, float[][][] rhs, float[][][] w, float[][][] hu, float hsquare, int XN, int YN, int ZN, int kc, int ic, int jc){

		int k, i, j;
		int prek, nextk, prei,nexti, prej, nextj;
		float tmpv;

		for(k=1; k<ZN; k += 2 ){
			prek = k-1;
			nextk = (k == (ZN-1)) ? (ZN-1) : (k+1);

			/*Compute for all i except i = 0*/
			for(i=2;i<YN; i+= 2){
				prei = i-1;
				nexti = (i == (YN-1)) ? (YN-1) : (i+1);

				for(j=1;j<XN; j+= 2){
					prej = j-1;
					nextj = (j == (XN-1)) ? (XN-1) : (j+1);	
					tmpv = hu[k][i][j]*hsquare;
					u[k][i][j] = ((u[prek][i][j] + 
							u[nextk][i][j] +
							u[k][prei][j] +
							u[k][nexti][j] +
							u[k][i][prej] +
							u[k][i][nextj]) * w[k][i][j]               
							                          - rhs[k][i][j]*hsquare)/(6*w[k][i][j] + tmpv);

				}
			}

			/*Compute for i = 0*/
			i = 0;
			prei = 0;
			nexti = i+1;

			for(j=1;j<XN; j+= 2){
				prej = j-1;
				nextj = (j == (XN-1)) ? (XN-1) : (j+1);	
				tmpv = hu[k][i][j]*hsquare;
				u[k][i][j] = ((u[prek][i][j] + 
						u[nextk][i][j] +
						u[k][prei][j] +
						u[k][nexti][j] +
						u[k][i][prej] +
						u[k][i][nextj]) * w[k][i][j]               
						                          - rhs[k][i][j]*hsquare)/(6*w[k][i][j] + tmpv);

			}

		}

		return;
	}


	/*kc = 0, ic = 1, jc = 1*/ /*DONE!!*/
	void octant011(float[][][] u, float[][][] rhs, float[][][] w, float[][][] hu, float hsquare, int XN, int YN, int ZN, int kc, int ic, int jc){

		int k, i, j;
		int prek, nextk, prei,nexti, prej, nextj;
		float tmpv;

		/*Compute for all k except k = 0*/
		for(k=2; k<ZN; k += 2 ){
			prek = k-1;
			nextk = (k == (ZN-1)) ? (ZN-1) : (k+1);

			for(i=1;i<YN; i+= 2){
				prei = i-1;
				nexti = (i == (YN-1)) ? (YN-1) : (i+1);

				for(j=1;j<XN; j+= 2){
					prej = j-1;
					nextj = (j == (XN-1)) ? (XN-1) : (j+1);	
					tmpv = hu[k][i][j]*hsquare;
					u[k][i][j] = ((u[prek][i][j] + 
							u[nextk][i][j] +
							u[k][prei][j] +
							u[k][nexti][j] +
							u[k][i][prej] +
							u[k][i][nextj]) * w[k][i][j]               
							                          - rhs[k][i][j]*hsquare)/(6*w[k][i][j] + tmpv);

				}
			}
		}

		/*Compute for k = 0*/
		k = 0;
		prek = 0;
		nextk = k+1;

		for(i=1;i<YN; i+= 2){
			prei = i-1;
			nexti = (i == (YN-1)) ? (YN-1) : (i+1);

			for(j=1;j<XN; j+= 2){
				prej = j-1;
				nextj = (j == (XN-1)) ? (XN-1) : (j+1);	
				tmpv = hu[k][i][j]*hsquare;
				u[k][i][j] = ((u[prek][i][j] + 
						u[nextk][i][j] +
						u[k][prei][j] +
						u[k][nexti][j] +
						u[k][i][prej] +
						u[k][i][nextj]) * w[k][i][j]               
						                          - rhs[k][i][j]*hsquare)/(6*w[k][i][j] + tmpv);

			}
		}


		return;
	}



	/*kc = 0, ic = 1, jc = 0*/   /*DONE!!*/
	void octant010(float[][][] u, float[][][] rhs, float[][][] w, float[][][] hu, float hsquare, int XN, int YN, int ZN, int kc, int ic, int jc){

		int k, i, j;
		int prek, nextk, prei,nexti, prej, nextj;
		float tmpv;

		/*Compute for all k except k = 0*/
		for(k=2; k<ZN; k += 2 ){
			prek = k-1;
			nextk = (k == (ZN-1)) ? (ZN-1) : (k+1);

			for(i=1;i<YN; i+= 2){
				prei = i-1;
				nexti = (i == (YN-1)) ? (YN-1) : (i+1);

				/*Compute for all j except j = 0*/
				for(j=2;j<XN; j+= 2){
					prej = j-1;
					nextj = (j == (XN-1)) ? (XN-1) : (j+1);
					tmpv = hu[k][i][j]*hsquare;
					u[k][i][j] = ((u[prek][i][j] + 
							u[nextk][i][j] +
							u[k][prei][j] +
							u[k][nexti][j] +
							u[k][i][prej] +
							u[k][i][nextj]) * w[k][i][j]               
							                          - rhs[k][i][j]*hsquare)/(6*w[k][i][j] + tmpv);

				}

				/*Compute for j = 0*/
				j = 0;
				prej = 0;
				nextj = j+1;
				tmpv = hu[k][i][j]*hsquare;
				u[k][i][j] = ((u[prek][i][j] + 
						u[nextk][i][j] +
						u[k][prei][j] +
						u[k][nexti][j] +
						u[k][i][prej] +
						u[k][i][nextj]) * w[k][i][j]               
						                          - rhs[k][i][j]*hsquare)/(6*w[k][i][j] + tmpv);


			}
		}

		/*Compute for k = 0*/
		k = 0;
		prek = 0;
		nextk = k+1;

		for(i=1;i<YN; i+= 2){
			prei = i-1;
			nexti = (i == (YN-1)) ? (YN-1) : (i+1);

			/*Compute for all j except j = 0*/
			for(j=2;j<XN; j+= 2){
				prej = j-1;
				nextj = (j == (XN-1)) ? (XN-1) : (j+1);
				tmpv = hu[k][i][j]*hsquare;
				u[k][i][j] = ((u[prek][i][j] + 
						u[nextk][i][j] +
						u[k][prei][j] +
						u[k][nexti][j] +
						u[k][i][prej] +
						u[k][i][nextj]) * w[k][i][j]               
						                          - rhs[k][i][j]*hsquare)/(6*w[k][i][j] + tmpv);

			}

			/*Compute for j = 0*/
			j = 0;
			prej = 0;
			nextj = j+1;
			tmpv = hu[k][i][j]*hsquare;
			u[k][i][j] = ((u[prek][i][j] + 
					u[nextk][i][j] +
					u[k][prei][j] +
					u[k][nexti][j] +
					u[k][i][prej] +
					u[k][i][nextj]) * w[k][i][j]               
					                          - rhs[k][i][j]*hsquare)/(6*w[k][i][j] + tmpv);



		}

		return;
	}

	/*kc = 1, ic = 0, jc = 0*/     /*DONE!*/
	void octant100(float[][][] u, float[][][] rhs, float[][][] w, float[][][] hu, float hsquare, int XN, int YN, int ZN, int kc, int ic, int jc){

		int k, i, j;
		int prek, nextk, prei,nexti, prej, nextj;
		float tmpv;

		for(k=1; k<ZN; k += 2 ){
			prek = k-1;
			nextk = (k == (ZN-1)) ? (ZN-1) : (k+1);

			/*Compute for all i except i = 0*/
			for(i=2;i<YN; i+= 2){
				prei = i-1;
				nexti = (i == (YN-1)) ? (YN-1) : (i+1);

				/*Compute for all j except j = 0*/
				for(j=2;j<XN; j+= 2){
					prej = j-1;
					nextj = (j == (XN-1)) ? (XN-1) : (j+1);
					tmpv = hu[k][i][j]*hsquare;
					u[k][i][j] = ((u[prek][i][j] + 
							u[nextk][i][j] +
							u[k][prei][j] +
							u[k][nexti][j] +
							u[k][i][prej] +
							u[k][i][nextj]) * w[k][i][j]               
							                          - rhs[k][i][j]*hsquare)/(6*w[k][i][j] + tmpv);

				}

				/*Compute for j = 0*/
				j = 0;
				prej = 0;
				nextj = j+1;
				tmpv = hu[k][i][j]*hsquare;
				u[k][i][j] = ((u[prek][i][j] + 
						u[nextk][i][j] +
						u[k][prei][j] +
						u[k][nexti][j] +
						u[k][i][prej] +
						u[k][i][nextj]) * w[k][i][j]               
						                          - rhs[k][i][j]*hsquare)/(6*w[k][i][j] + tmpv);


			}
			/*Compute for i = 0*/
			i = 0;
			prei = 0;
			nexti = i+1;

			/*Compute for all j except j = 0*/
			for(j=2;j<XN; j+= 2){
				prej = j-1;
				nextj = (j == (XN-1)) ? (XN-1) : (j+1);
				tmpv = hu[k][i][j]*hsquare;
				u[k][i][j] = ((u[prek][i][j] + 
						u[nextk][i][j] +
						u[k][prei][j] +
						u[k][nexti][j] +
						u[k][i][prej] +
						u[k][i][nextj]) * w[k][i][j]               
						                          - rhs[k][i][j]*hsquare)/(6*w[k][i][j] + tmpv);

			}

			/*Compute for j = 0*/
			j = 0;
			prej = 0;
			nextj = j+1;
			tmpv = hu[k][i][j]*hsquare;
			u[k][i][j] = ((u[prek][i][j] + 
					u[nextk][i][j] +
					u[k][prei][j] +
					u[k][nexti][j] +
					u[k][i][prej] +
					u[k][i][nextj]) * w[k][i][j]               
					                          - rhs[k][i][j]*hsquare)/(6*w[k][i][j] + tmpv);


		}

		return;
	}



	/*kc = 0, ic = 0, jc = 0*/  /*DONE!!*/
	void octant000(float[][][] u, float[][][] rhs, float[][][] w, float[][][] hu, float hsquare, int XN, int YN, int ZN, int kc, int ic, int jc){

		int k, i, j;
		int prek, nextk, prei,nexti, prej, nextj;
		float tmpv;

		/*Compute for all k except k = 0*/
		for(k=2; k<ZN; k += 2 ){
			prek = k-1;
			nextk = (k == (ZN-1)) ? (ZN-1) : (k+1);

			/*Compute for all i except i = 0*/
			for(i=2;i<YN; i+= 2){
				prei = i-1;
				nexti = (i == (YN-1)) ? (YN-1) : (i+1);

				/*Compute for all j except j = 0*/
				for(j=2;j<XN; j+= 2){
					prej = j-1;
					nextj = (j == (XN-1)) ? (XN-1) : (j+1);
					tmpv = hu[k][i][j]*hsquare;
					u[k][i][j] = ((u[prek][i][j] + 
							u[nextk][i][j] +
							u[k][prei][j] +
							u[k][nexti][j] +
							u[k][i][prej] +
							u[k][i][nextj]) * w[k][i][j]               
							                          - rhs[k][i][j]*hsquare)/(6*w[k][i][j] + tmpv);

				}

				/*Compute for j = 0*/
				j = 0;
				prej = 0;
				nextj = j+1;
				tmpv = hu[k][i][j]*hsquare;
				u[k][i][j] = ((u[prek][i][j] + 
						u[nextk][i][j] +
						u[k][prei][j] +
						u[k][nexti][j] +
						u[k][i][prej] +
						u[k][i][nextj]) * w[k][i][j]               
						                          - rhs[k][i][j]*hsquare)/(6*w[k][i][j] + tmpv);


			}
			/*Compute for i = 0*/
			i = 0;
			prei = 0;
			nexti = i+1;

			/*Compute for all j except j = 0*/
			for(j=2;j<XN; j+= 2){
				prej = j-1;
				nextj = (j == (XN-1)) ? (XN-1) : (j+1);
				tmpv = hu[k][i][j]*hsquare;
				u[k][i][j] = ((u[prek][i][j] + 
						u[nextk][i][j] +
						u[k][prei][j] +
						u[k][nexti][j] +
						u[k][i][prej] +
						u[k][i][nextj]) * w[k][i][j]               
						                          - rhs[k][i][j]*hsquare)/(6*w[k][i][j] + tmpv);

			}

			/*Compute for j = 0*/
			j = 0;
			prej = 0;
			nextj = j+1;
			tmpv = hu[k][i][j]*hsquare;
			u[k][i][j] = ((u[prek][i][j] + 
					u[nextk][i][j] +
					u[k][prei][j] +
					u[k][nexti][j] +
					u[k][i][prej] +
					u[k][i][nextj]) * w[k][i][j]               
					                          - rhs[k][i][j]*hsquare)/(6*w[k][i][j] + tmpv);


		}

		/*Compute for k = 0*/
		k = 0;
		prek = 0;
		nextk = k+1;

		/*Compute for all i except i = 0*/
		for(i=2;i<YN; i+= 2){
			prei = i-1;
			nexti = (i == (YN-1)) ? (YN-1) : (i+1);

			/*Compute for all j except j = 0*/
			for(j=2;j<XN; j+= 2){
				prej = j-1;
				nextj = (j == (XN-1)) ? (XN-1) : (j+1);
				tmpv = hu[k][i][j]*hsquare;
				u[k][i][j] = ((u[prek][i][j] + 
						u[nextk][i][j] +
						u[k][prei][j] +
						u[k][nexti][j] +
						u[k][i][prej] +
						u[k][i][nextj]) * w[k][i][j]               
						                          - rhs[k][i][j]*hsquare)/(6*w[k][i][j] + tmpv);

			}

			/*Compute for j = 0*/
			j = 0;
			prej = 0;
			nextj = j+1;
			tmpv = hu[k][i][j]*hsquare;
			u[k][i][j] = ((u[prek][i][j] + 
					u[nextk][i][j] +
					u[k][prei][j] +
					u[k][nexti][j] +
					u[k][i][prej] +
					u[k][i][nextj]) * w[k][i][j]               
					                          - rhs[k][i][j]*hsquare)/(6*w[k][i][j] + tmpv);


		}
		/*Compute for i = 0*/
		i = 0;
		prei = 0;
		nexti = i+1;

		/*Compute for all j except j = 0*/
		for(j=2;j<XN; j+= 2){
			prej = j-1;
			nextj = (j == (XN-1)) ? (XN-1) : (j+1);
			tmpv = hu[k][i][j]*hsquare;
			u[k][i][j] = ((u[prek][i][j] + 
					u[nextk][i][j] +
					u[k][prei][j] +
					u[k][nexti][j] +
					u[k][i][prej] +
					u[k][i][nextj]) * w[k][i][j]               
					                          - rhs[k][i][j]*hsquare)/(6*w[k][i][j] + tmpv);

		}

		/*Compute for j = 0*/
		j = 0;
		prej = 0;
		nextj = j+1;
		tmpv = hu[k][i][j]*hsquare;
		u[k][i][j] = ((u[prek][i][j] + 
				u[nextk][i][j] +
				u[k][prei][j] +
				u[k][nexti][j] +
				u[k][i][prej] +
				u[k][i][nextj]) * w[k][i][j]               
				                          - rhs[k][i][j]*hsquare)/(6*w[k][i][j] + tmpv);






		return;
	}

	void Jacobi(float[][][] u, float[][][] rhs, float[][][] w,float[][][] hu, int lev, int XN, int YN, int ZN, int iter){

		float[][][] tmpvol;

		int k, i, j, index, h;
		int prek, nextk, prei,nexti, prej, nextj;
		//int size;

		float alpha = 0.9f; /* 0.66666666666; alpha has to be large to converge in 3D */
		float hsquare, sum;

		float tmpv;

		h = 1 << (maxlevel - lev);
		hsquare = 2*h*h;

		tmpvol = new float[ZN][YN][XN];// )pgFcube(0,ZN-1,0,YN-1,0,XN-1);

		// size = XN*YN*ZN*sizeof(PGfloat);

		for(index =1; index <= iter; index++){
			for(k=0; k<ZN; k ++ ){
				prek = (k>0) ? (k-1) : 0;
				nextk = (k == (ZN-1)) ? (ZN-1) : (k+1);
				for(i=0;i<YN; i++){
					prei = (i>0) ? (i-1) : 0;
					nexti = (i == (YN-1)) ? (YN-1) : (i+1);

					for(j=0;j<XN; j++){
						prej = (j>0) ? (j-1) : 0;
						nextj = (j == (XN-1)) ? (XN-1) : (j+1);

						tmpv = hu[k][i][j]*hsquare;

						tmpvol[k][i][j] = (1-alpha)*u[k][i][j] + alpha*(u[prek][i][j]*(w[prek][i][j]+w[k][i][j]) + 
								u[nextk][i][j]*(w[nextk][i][j]+w[k][i][j]) +
								u[k][prei][j]*(w[k][prei][j]+w[k][i][j]) +
								u[k][nexti][j]*(w[k][nexti][j]+w[k][i][j]) +
								u[k][i][prej]*(w[k][i][prej]+w[k][i][j]) +
								u[k][i][nextj]*(w[k][i][nextj]+w[k][i][j]) - rhs[k][i][j]*hsquare)/(6*w[k][i][j]+w[prek][i][j]+w[nextk][i][j]					    + w[k][prei][j] + w[k][nexti][j]+w[k][i][prej] + w[k][i][nextj] + tmpv);

					}
				}
			}

			for(k=0;k<ZN;k++)
				for(i=0;i<YN;i++)
					for(j=0;j<XN;j++){
						u[k][i][j] = tmpvol[k][i][j];
					} 
			/*
	    memcpy((char *)&u[0][0][0], (char *)&tmpvol[0][0][0], size);
			 */  

			/* 
	    sum = 0.0;
	    for(k=0;k<ZN;k++)
	    for(i=0;i<YN;i++)
	    for(j=0;j<XN;j++){
	    sum += u[k][i][j] ;
	    }

	    sum /= (float)(XN*YN*ZN);

	    for(k=0;k<ZN;k++)
	    for(i=0;i<YN;i++)
	    for(j=0;j<XN;j++){
	    u[k][i][j] -= sum;
	    }

			 */
		}

		//pgFreeFcube(tmpvol, 0, ZN-1, 0, YN-1, 0, XN-1);

		return;

	}

	void Gauss_Seidel(float[][][] u, float[][][] rhs, float[][][] weight, float[][][] hu, int lev, int XN, int YN, int ZN, int iter){
		int h, i;
		float hsquare;

		h = 1 << (maxlevel - lev);
		hsquare = h*h;

		if(XN == 1 || YN == 1 || ZN == 1){
			System.out.format("OOPS!!! PROBLEM IN Gauss_Seidel USING octant\n");
			return;//exit(1);
		}

		for(i=1; i<= iter;i++){
			/* Process black first like follows gives slightly better convergence */

			octant(u,rhs,weight,hu,hsquare, XN, YN, ZN, 0, 0, 0);
			/*    octant000(u,rhs,weight,hu,hsquare, XN, YN, ZN, 0, 0, 0);*/

			octant(u,rhs,weight,hu,hsquare, XN, YN, ZN, 0, 1, 1);
			/*    octant011(u,rhs,weight,hu,hsquare, XN, YN, ZN, 0, 1, 1);*/

			octant(u,rhs,weight,hu,hsquare, XN, YN, ZN, 1, 0, 1);
			/*    octant101(u,rhs,weight,hu,hsquare, XN, YN, ZN, 1, 0, 1);*/

			octant(u,rhs,weight,hu,hsquare, XN, YN, ZN, 1, 1, 0);
			/*    octant110(u,rhs,weight,hu,hsquare, XN, YN, ZN, 1, 1, 0);*/

			octant(u,rhs,weight,hu,hsquare, XN, YN, ZN, 1, 0, 0);
			/*    octant100(u,rhs,weight,hu,hsquare, XN, YN, ZN, 1, 0, 0);*/

			octant(u,rhs,weight,hu,hsquare, XN, YN, ZN, 0, 0, 1);
			/*    octant001(u,rhs,weight,hu,hsquare, XN, YN, ZN, 0, 0, 1);*/

			octant(u,rhs,weight,hu,hsquare, XN, YN, ZN, 0, 1, 0);
			/*octant010(u,rhs,weight,hu,hsquare, XN, YN, ZN, 0, 1, 0);*/

			octant(u,rhs,weight,hu,hsquare, XN, YN, ZN, 1, 1, 1);
			/*octant111(u,rhs,weight,hu,hsquare, XN, YN, ZN, 1, 1, 1);*/
		}

		return;
	}



	void slvsml(float[][][] u, float[][][] rhs, float[][][] weight, float[][][] hu, int XN, int YN, int ZN){
		int i,j,k;
		float sum;

		for(k=0;k<ZN;k++)
			for(i=0;i<YN;i++)
				for(j=0;j<XN;j++){
					u[k][i][j] = 0;
				}




		if(JACOBI)
			Jacobi(u,rhs,weight,hu,1,XN,YN,ZN,2); 
		else
			Gauss_Seidel(u,rhs,weight,hu,1,XN,YN,ZN,2); 

		/*
	  sum = 0.0;
	  for(k=0;k<ZN;k++)
	    for(i=0;i<YN;i++)
	      for(j=0;j<XN;j++){
		sum += u[k][i][j] ;
	      }

	  sum /= (float)(XN*YN*ZN);

	  for(k=0;k<ZN;k++)
	    for(i=0;i<YN;i++)
	      for(j=0;j<XN;j++){
		u[k][i][j] -= sum;
	      }
		 */

		return;
	}

	void multigrid(float[][][] u, float[][][] f, float[][][] weight, float[][][] hu, int XN, int YN, int ZN){
		/* u is the solution for
		 * div( weight(x) \nabla u(x)) - hu(x) ( u(x) - f(x)) = 0;
		 */

		int m, n, l, mf;
		int iters;
		int[] mo, no, lo;

		int j, jcycle, jj;
		int msize, nsize, lsize;

		float maxerr=10, tmpv;

		float[][][][] ires, irho, irhs, iu, iwei, ih;

		float[][][] uold;

		/* Computer maximum level */
		m = 0;
		mf = ZN;
		while((mf >> (m+1)) > 0) m++;
		maxlevel = m;
		m = 0;
		mf = YN;
		while((mf >> (m+1)) > 0) m++;
		if(maxlevel > m) maxlevel = m;
		m = 0;
		mf = XN;
		while((mf >> (m+1)) > 0) m++;
		if(maxlevel > m) maxlevel = m;

		//System.out.format("Maxlevel:" + maxlevel +"\n");

		//  printf("Simple scheme: maxlevel = %d \n", maxlevel);

		/* Set pre-smoothing steps */
		n1 = 2;
		/* Set post-smoothing steps */
		n2 = 2;

		/* Allocate memory */
		ires =new float[maxlevel+1][][][];// *)malloc((maxlevel+1)*sizeof(float[][][] ));
		irho =new float[maxlevel+1][][][];// *)malloc((maxlevel+1)*sizeof(float[][][] ));
		irhs =new float[maxlevel+1][][][];// *)malloc((maxlevel+1)*sizeof(float[][][] ));
		iu =new float[maxlevel+1][][][];// *)malloc((maxlevel+1)*sizeof(float[][][] ));
		iwei =new float[maxlevel+1][][][];// *)malloc((maxlevel+1)*sizeof(float[][][] ));
		ih =new float[maxlevel+1][][][];// *)malloc((maxlevel+1)*sizeof(float[][][] ));
		mo =new int[maxlevel+1]; //*)malloc((maxlevel+1)*sizeof(int));
		no =new int[maxlevel+1];// *)malloc((maxlevel+1)*sizeof(int));
		lo =new int[maxlevel+1];// *)malloc((maxlevel+1)*sizeof(int));

		uold =new float[ZN][YN][XN];// )pgFcube(0, ZN-1, 0, YN-1, 0, XN-1); 
		msize = ZN;
		nsize = YN;
		lsize = XN;


		for(j=maxlevel;j>=1;j--){
			ires[j] =new float[msize][nsize][lsize];// )pgFcube(0, msize-1, 0, nsize-1, 0, lsize-1); 
			irho[j] =new float[msize][nsize][lsize];// )pgFcube(0, msize-1, 0, nsize-1, 0, lsize-1); 
			irhs[j] =new float[msize][nsize][lsize];// )pgFcube(0, msize-1, 0, nsize-1, 0, lsize-1); 
			iu[j] =new float[msize][nsize][lsize];// )pgFcube(0, msize-1, 0, nsize-1, 0, lsize-1); 
			ih[j] =new float[msize][nsize][lsize];// )pgFcube(0, msize-1, 0, nsize-1, 0, lsize-1); 
			iwei[j] =new float[msize][nsize][lsize];// )pgFcube(0, msize-1, 0, nsize-1, 0, lsize-1); 

			mo[j] = msize;
			no[j] = nsize;
			lo[j] = lsize;
			msize = (msize+1)>>1;
		nsize = (nsize + 1)>>1;
		lsize = (lsize+1)>>1;
		}

		/*	for(j=maxlevel;j>=1;j--){
			System.out.format("mo" + mo[j]+ "no" + no[j]+"lo" +lo[j]+"\n");
		}
		 */
		//  printf("n1=%d, n2=%d, x1=%d,y1=%d,z1=%d\n",n1,n2,lo[1],no[1],mo[1]);

		for(m=0;m<ZN;m++)
			for(n=0;n<YN;n++)
				for(l=0;l<XN;l++){
					iwei[maxlevel][m][n][l] = weight[m][n][l];
					ih[maxlevel][m][n][l] = hu[m][n][l];
					uold[m][n][l] = 0.0f;
				}

		for(j = maxlevel-1; j >= 1; j--){
			rstrct(iwei[j],iwei[j+1],lo[j], no[j],mo[j],lo[j+1], no[j+1], mo[j+1]);
			rstrct(ih[j],ih[j+1],lo[j], no[j],mo[j],lo[j+1], no[j+1], mo[j+1]);
		} 


		/* Now start multigrid processing */
		for(iters = 1; iters <= 10; iters++){

			/* Several iterations of fmgv */
			/* Compute the initial residue */
			resid(irho[maxlevel], u, f, iwei[maxlevel], ih[maxlevel], XN,YN,ZN, maxlevel);
			maxerr = 0.0f;
			for(m=0;m<ZN;m++)
				for(n=0;n<YN;n++)
					for(l=0;l<XN;l++){
						tmpv = irho[maxlevel][m][n][l];
						if(tmpv < 0) tmpv = 0-tmpv;
						if(maxerr < tmpv) maxerr = tmpv;
					}


			//      printf("Maximum Residue is %g \n", maxerr); 
			if(maxerr < 0.0001) break;    

			for(j = maxlevel-1; j >= 1; j--){
				rstrct(irho[j],irho[j+1],lo[j],no[j],mo[j],lo[j+1],no[j+1], mo[j+1]); 
			} 

			/*Now solve the PDE at level 1, the coarsest level */
			slvsml(iu[1], irho[1], iwei[1], ih[1], lo[1], no[1], mo[1]); /* Initial solution on coarest grid */


			/* Now start Full-Multigrid V or W cycle */
			for(j=2; j<= maxlevel;j++){

				interp(iu[j],iu[j-1], lo[j], no[j], mo[j], lo[j-1], no[j-1],mo[j-1]); /* Get the initial guess of the solution of the original eq */

				copymem(irhs[j], irho[j],lo[j], no[j],mo[j]); /* Set up right hand side */
				/* Now begin mgv.m 12-9-03 */
				for(jcycle = 1; jcycle <= 1; jcycle ++){
					for(jj=j; jj>=2; jj--){ /* Down stroke of the V */
						if(JACOBI)
							Jacobi(iu[jj], irhs[jj], iwei[jj], ih[jj], jj, lo[jj],no[jj],mo[jj], n1); 
						else
							Gauss_Seidel(iu[jj], irhs[jj], iwei[jj], ih[jj], jj, lo[jj],no[jj],mo[jj], n1);	  

						resid(ires[jj], iu[jj], irhs[jj], iwei[jj], ih[jj],lo[jj],no[jj],mo[jj],jj); /* Defect */

						/* Does the following initialization only need to be done at jj=2
						 * or doesn't need to be done at all ?? No! It need to be done 
						 * at all level, otherwise, the addin need to be changed!
						 * Why not get rid of += in addin, and get rid of all these 
						 * initialization?? Am I missing something?? Indeed, no change
						 * should be made here!
						 */
						for(m=0; m < mo[jj-1]; m++) /*loop over image */
							for(n=0;n< no[jj-1];n++)
								for(l=0;l<lo[jj-1];l++){
									iu[jj-1][m][n][l] = 0; /* Initial value for errors at levels from j-1 to 1 which are iu[j-1] ~ iu[1] and are zeros */
								}

						rstrct(irhs[jj-1], ires[jj], lo[jj-1], no[jj-1],mo[jj-1],lo[jj],no[jj],mo[jj]); /* mf, nf is the size of the first parameter */

					}


					slvsml(iu[1], irhs[1], iwei[1],ih[1],lo[1],no[1],mo[1]); /* Bottom of the V */
					/* Now iu[1] stores the solution of the error at the coarest level */	

					for(jj=2; jj <=j; jj++){ /*Upard stroke of V */
						addin(iu[jj], iu[jj-1], ires[jj],lo[jj],no[jj],mo[jj],lo[jj-1],no[jj-1],mo[jj-1]);
						/*ires[jj] is used for temporary storage inside addint */

						/* Post-smooyhing */
						if(JACOBI)
							Jacobi(iu[jj], irhs[jj], iwei[jj], ih[jj], jj, lo[jj],no[jj],mo[jj], n1);
						else
							Gauss_Seidel(iu[jj], irhs[jj], iwei[jj], ih[jj], jj,lo[jj],no[jj],mo[jj], n2); 
					}

				}

			}

			/*
	    maxerr = 0.0;
	    for(m=0;m<=(ZN-1);m++)
	      for(n=0;n<=(YN-1);n++)
		for(l=0;l<=(XN-1);l++){
		  tmpv = iu[maxlevel][m][n][l];
		  if(tmpv < 0) tmpv = 0-tmpv;
		  if(maxerr < tmpv) maxerr = tmpv;
		}

	    if(maxerr < 0.0001){
	      printf("Converged after %d iterations\n", iters);
	      break;
	    }else{
	      printf("Error after %d multigrid iters is %g \n", iters, maxerr); 
	    }
			 */

			/* Update solution */
			maxerr = 0;
			for(m=0; m < ZN; m++)
				for(n=0;n< YN;n++)
					for(l=0;l<XN; l++){
						
							u[m][n][l] += iu[maxlevel][m][n][l];
							
						/* if(maxerr < u[m][n][l]) maxerr = u[m][n][l]; */
					}
			/* printf("maximal solution value =%g\n", maxerr); */

		} /* endof for (iters) */

		//pgFreeFcube(uold, 0, ZN-1, 0, YN-1, 0, XN-1); 

		for(j=maxlevel;j>=1;j--){
			msize = mo[j]; nsize = no[j]; lsize = lo[j];
			//pgFreeFcube(ires[j], 0, msize-1, 0, nsize-1, 0, lsize-1); 
			//pgFreeFcube(irhs[j], 0, msize-1, 0, nsize-1, 0, lsize-1); 
			//pgFreeFcube(irho[j], 0, msize-1, 0, nsize-1, 0, lsize-1); 
			//pgFreeFcube(iu[j], 0, msize-1, 0, nsize-1, 0, lsize-1); 
			//pgFreeFcube(ih[j], 0, msize-1, 0, nsize-1, 0, lsize-1); 
			//pgFreeFcube(iwei[j], 0, msize-1, 0, nsize-1, 0, lsize-1); 
		}

		//free(ih);
		//free(iu);
		//free(ires);
		//free(irho);
		//free(irhs);
		//free(iwei);

		//free(mo); //free(no); //free(lo);

		return;
	}



}
