package edu.jhu.ece.iacl.plugins.dti;

import java.util.ArrayList;

import edu.jhu.ece.iacl.jist.io.StringReaderWriter;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation.AlgorithmAuthor;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation.Citation;
import edu.jhu.ece.iacl.jist.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.jist.pipeline.DevelopmentStatus;
import edu.jhu.ece.iacl.jist.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamInteger;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamObject;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamVolume;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamVolumeCollection;
import edu.jhu.ece.iacl.jist.structures.image.ImageData;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataMipav;
import edu.jhu.ece.iacl.jist.structures.image.ImageHeader;
import edu.jhu.ece.iacl.jist.utility.FileUtil;
import gov.nih.mipav.model.structures.ModelImage;

public class MedicAlgorithmExtractDOTSCBSubset extends ProcessingAlgorithm{
	private ParamVolume in;
	//private ParamVolume fa; //for header
	private ParamVolume out;
	private ParamVolume outwml;
	/*private ParamVolume scpr;
	private ParamVolume mcp;
	private ParamVolume icpl;
	private ParamVolume icpr;*/
	private static final String cvsversion = "$Revision: 1.1 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "").replace(" ", "");
	private static final String shortDescription = "Extract DOTS CP labels";
	private static final String longDescription = "";
	protected void createInputParameters(ParamCollection inputParams) {
		inputParams.add(in=new ParamVolume("DOTS 4D Volume",null,-1,-1,-1,-1));
		//inputParams.add(fa=new ParamVolume("for header use",null,-1,-1,-1,-1));
		inputParams.setPackage("IACL");
		inputParams.setCategory("DTI");
		inputParams.setLabel("Extract DOTS CB Subset");
		inputParams.setName("Extract_DOTS_CB_Subset");
		
		AlgorithmInformation info = getAlgorithmInformation();
		info.add(new AlgorithmAuthor("Chuyang Ye", "cye4@jhu.edu", "http://iacl.ece.jhu.edu/Chuyang"));
		info.setWebsite("");
		info.setAffiliation("");
		info.setDescription(shortDescription);
		info.setLongDescription(shortDescription + longDescription);
		info.setVersion(revnum);
		info.setEditable(false);
		info.setStatus(DevelopmentStatus.RC);
	}
	protected void createOutputParameters(ParamCollection outputParams) {
		outputParams.add(out=new ParamVolume("DOTS CB Subset",null,-1,-1,-1,-1));
		outputParams.add(outwml=new ParamVolume("DOTS CB ML Subset",null,-1,-1,-1,-1));
		/*outputParams.add(scpr=new ParamVolume("SCPR label",null,-1,-1,-1,1));
		outputParams.add(mcp=new ParamVolume("MCP label",null,-1,-1,-1,1));
		outputParams.add(icpl=new ParamVolume("ICPL label",null,-1,-1,-1,1));
		outputParams.add(icpr=new ParamVolume("ICPR label",null,-1,-1,-1,1));*/
	}
	protected void execute(CalculationMonitor monitor) {
		ImageData vol = in.getImageData();
        ImageHeader hdr = vol.getHeader();
        ImageDataMipav CB = new ImageDataMipav(vol.getName()+"_CB_Subset",vol.getType(),vol.getRows(), vol.getCols(), vol.getSlices(),7);
        ImageDataMipav CBML = new ImageDataMipav(vol.getName()+"_CB_Subset_ML",vol.getType(),vol.getRows(), vol.getCols(), vol.getSlices(),9);
        
        int ICPL = 15;
        int ICPR = 16;
        int MCP = 21;
        int MLL = 22;
        int MLR = 23;
        int SCPL = 30;
        int SCPR = 31;
        
        //ImageDataMipav labelSCPL = new ImageDataMipav(vol.getName()+"_SCP_labels",vol.getType(),vol.getRows(), vol.getCols(), vol.getSlices());
        //ImageDataMipav labelSCPR = new ImageDataMipav(vol.getName()+"_SCP_labels",vol.getType(),vol.getRows(), vol.getCols(), vol.getSlices());
       
        for(int i=0;i<vol.getRows();i++){
			for(int j=0;j<vol.getCols();j++){
				for(int k=0;k<vol.getSlices();k++){
					//labelSCPL.set(i, j, k, SCPL);
					//labelSCPR.set(i, j, k, SCPR);
					CB.set(i, j, k, 0, vol.getDouble(i, j, k, 0));
					CB.set(i, j, k, 1, vol.getDouble(i, j, k, 1));
					CB.set(i, j, k, 2, vol.getDouble(i, j, k, ICPL));
					CB.set(i, j, k, 3, vol.getDouble(i, j, k, ICPR));
					CB.set(i, j, k, 4, vol.getDouble(i, j, k, MCP));
					CB.set(i, j, k, 5, vol.getDouble(i, j, k, SCPL));
					CB.set(i, j, k, 6, vol.getDouble(i, j, k, SCPR));
					
					CBML.set(i, j, k, 0, vol.getDouble(i, j, k, 0));
					CBML.set(i, j, k, 1, vol.getDouble(i, j, k, 1));
					CBML.set(i, j, k, 2, vol.getDouble(i, j, k, ICPL));
					CBML.set(i, j, k, 3, vol.getDouble(i, j, k, ICPR));
					CBML.set(i, j, k, 4, vol.getDouble(i, j, k, MCP));
					CBML.set(i, j, k, 5, vol.getDouble(i, j, k, MLL));
					CBML.set(i, j, k, 6, vol.getDouble(i, j, k, MLR));
					CBML.set(i, j, k, 7, vol.getDouble(i, j, k, SCPL));
					CBML.set(i, j, k, 8, vol.getDouble(i, j, k, SCPR));
				}
			}
		}
        CB.setHeader(hdr);
        CBML.setHeader(hdr);
        //scpl.setName(vol.getName()+"_SCPL_labels");
        out.setValue(CB);
        outwml.setValue(CBML);

	}
}
