package edu.jhu.ece.iacl.plugins.dti.tractography;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.vecmath.Point3f;


import edu.jhu.ece.iacl.jist.io.*;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation.AlgorithmAuthor;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmRuntimeException;
import edu.jhu.ece.iacl.jist.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.jist.pipeline.DevelopmentStatus;
import edu.jhu.ece.iacl.jist.pipeline.ProcessingAlgorithm;
//import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation.AlgorithmAuthor;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamFileCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamInteger;
//import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamInteger;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamObject;
//import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamOption;
//import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamVolume;
import edu.jhu.ece.iacl.jist.structures.fiber.FiberCollection;
import edu.jhu.ece.iacl.jist.structures.fiber.Fiber;


public class MedicAlgorithmMergeFibers extends ProcessingAlgorithm {
	//input param
	/*private ParamObject<FiberCollection> fiberset1;
	private ParamObject<FiberCollection> fiberset2;
	private ParamObject<FiberCollection> fiberset3;
	private ParamObject<FiberCollection> fiberset4;
	private ParamObject<FiberCollection> fiberset5;
	private ParamObject<FiberCollection> fiberset6;
	private ParamObject<FiberCollection> fiberset7;*/
	private ParamFileCollection fiberToMerge;
	//private ParamInteger num;
	
	//output param
	//private ParamFileCollection fibersetout;
	private ParamObject<FiberCollection> fibersetout;
	
	private FiberCollectionReaderWriter fcrw = FiberCollectionReaderWriter.getInstance();

	private static final String cvsversion = "$Revision: 1.2 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "").replace(" ", "");
	private static final String shortDescription = "Merge Fibers";
	private static final String longDescription = "Merge Fibers";


	@Override
	protected void createInputParameters(ParamCollection inputParams) {
		inputParams.add(fiberToMerge = new ParamFileCollection("Fibers to Merge", new FileExtensionFilter(new String[]{"dat"})));
		
		/*inputParams.add(fiberset1 = new ParamObject<FiberCollection>("Fiber Set 1", new FiberCollectionReaderWriter()));
		inputParams.add(fiberset2 = new ParamObject<FiberCollection>("Fiber Set 2", new FiberCollectionReaderWriter()));
		inputParams.add(fiberset3 = new ParamObject<FiberCollection>("Fiber Set 3", new FiberCollectionReaderWriter()));
		inputParams.add(fiberset4 = new ParamObject<FiberCollection>("Fiber Set 4", new FiberCollectionReaderWriter()));
		inputParams.add(fiberset5 = new ParamObject<FiberCollection>("Fiber Set 5", new FiberCollectionReaderWriter()));
		inputParams.add(fiberset6 = new ParamObject<FiberCollection>("Fiber Set 6", new FiberCollectionReaderWriter()));
		inputParams.add(fiberset7 = new ParamObject<FiberCollection>("Fiber Set 7", new FiberCollectionReaderWriter()));
		fiberset1.setMandatory(false);
		fiberset2.setMandatory(false);
		fiberset3.setMandatory(false);
		fiberset4.setMandatory(false);
		fiberset5.setMandatory(false);
		fiberset6.setMandatory(false);
		fiberset7.setMandatory(false);
		inputParams.add(num = new ParamInteger("Label",7));*/
		inputParams.setPackage("IACL");
		inputParams.setCategory("DTI.Fiber");
		inputParams.setLabel("Merge Fibers");
		inputParams.setName("Merge Fibers");


		AlgorithmInformation info = getAlgorithmInformation();
		//info.setWebsite("");
		info.add(new AlgorithmAuthor("Chuyang Ye", "cye4@jhu.edu", "http://iacl.ece.jhu.edu/Chuyang"));
		info.setAffiliation("Johns Hopkins University, Departments of Electrical and Computer Engineering");
		info.setDescription(shortDescription);
		info.setLongDescription(longDescription);
		info.setVersion(revnum);
		info.setEditable(false);
		info.setStatus(DevelopmentStatus.RC);
	}


	@Override
	protected void createOutputParameters(ParamCollection outputParams) {
		//outputParams.add(fibersetout = new ParamFileCollection("Mergerd Fibers",new FileExtensionFilter(new String[]{"dat","vtk"})));
		outputParams.add(fibersetout = new ParamObject<FiberCollection>("Mergerd Fibers",new FiberCollectionReaderWriter()));
		
	}


	@Override
	protected void execute(CalculationMonitor monitor)
			throws AlgorithmRuntimeException {
		System.out.println("Fiber merging started");
		File dir = new File(this.getOutputDirectory()+File.separator+edu.jhu.ece.iacl.jist.utility.FileUtil.forceSafeFilename(this.getAlgorithmName()));
		try{
			if(!dir.isDirectory()){
				(new File(dir.getCanonicalPath())).mkdir();
			}
		}catch(IOException e){
			e.printStackTrace();
		}
		
		
		FiberCollection tract = new FiberCollection();
		FiberCollection OutFibers = new FiberCollection();
		
		for(int i = 0; i < fiberToMerge.size();i++){
			File f = fiberToMerge.getValue(i);
			tract = fcrw.read(f);
			for(Fiber fiber : tract){
				OutFibers.add(fiber);
			}
		}
		
		
		
		OutFibers.setResolutions(tract.getResolutions());
		OutFibers.setDimensions(tract.getDimensions());
		OutFibers.setName(tract.getName()+"_merge");
		System.out.println("Resolution: " + OutFibers.getResolutions().x + " " + OutFibers.getResolutions().y + " " + OutFibers.getResolutions().z);
		
		File f = writeFibers(OutFibers,dir);
		fibersetout.setObject(OutFibers);
		//fibersetout.add(f);
		System.out.println("Merge complete");
	}


	

	private File writeFibers(FiberCollection fibers, File dir){
		File out = null;
		out = fcrw.write(fibers, dir);
		return out;
	}
}
