package edu.jhu.ece.iacl.plugins.labeling;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import edu.jhu.bme.smile.commons.textfiles.TextFileReader;
import edu.jhu.ece.iacl.jist.io.FileExtensionFilter;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmRuntimeException;
import edu.jhu.ece.iacl.jist.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.jist.pipeline.DevelopmentStatus;
import edu.jhu.ece.iacl.jist.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation.AlgorithmAuthor;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamBoolean;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamFile;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamInteger;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamVolume;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamVolumeCollection;
import edu.jhu.ece.iacl.jist.structures.image.ImageData;
import edu.jhu.ece.iacl.jist.structures.image.ImageHeader;
import edu.jhu.ece.iacl.jist.utility.JistLogger;
import edu.jhu.ece.iacl.utility.ArrayUtil;

public class MedicAlgorithmLabelCombine extends ProcessingAlgorithm {

	//input params
	public  ParamVolumeCollection 	labelVolume;
	public  ParamFile				combineParam;
	public  ParamBoolean			replace;

	//output params
	public ParamVolumeCollection	 combinedLabelVolume;
	
	//helper objects
	TextFileReader tfr;
	private int[][] combs;
	private boolean doreplace;
	
	public boolean writeNow = true;
	
	private static final String cvsversion = "$Revision: 1.6 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "").replace(" ", "");
	private static final String shortDescription = "Given a volume with N labels, creates a new volume with M labels (M<=N) by combining" +
			"the labels as specified.";
	private static final String longDescription = "The Label combine/replacement specification is a text file that describes how labels" +
			"will be combined or replaced.  If the \"Replacement?\" option is unchecked, the specification can have multiple label values per row." +
			"Any label value in the ith row will be replaced by label 'i'.  IT IS OFTEN USEFUL TO HAVE A '0' (ZERO) IN THE FIRST ROW.  If a label" +
			"value appears in multiple lines, it will be replaced by the index of the first line in which it appears.\n\n" +
			"If the \"Replacement?\" option is checked, this module results in label values being replaced rather than combined. " +
			"The text file must have at least two columns, values in the third column or later will be ignored.  The method will locate" +
			"any label in the first column of the specification and replace it with the label in the second column.";
	
	public void setCombinationParams(int[][] combs){
		this.combs=combs;
	}
	public void setReplace(boolean rep){
		doreplace = rep;
	}
	
	protected void createInputParameters(ParamCollection inputParams) {
		
		inputParams.add(labelVolume = new ParamVolumeCollection("Label Volumes"));
		labelVolume.setDescription("Volume of labels whose labels will be combined.");
		labelVolume.setLoadAndSaveOnValidate(false);
		
		inputParams.add(combineParam = new ParamFile("Label combination/replacement specification",new FileExtensionFilter(new String[]{"txt","csv"})));
		inputParams.add(replace = new ParamBoolean("Replacement ?", false));
		
		inputParams.setPackage("IACL");
		inputParams.setCategory("Labeling");
		inputParams.setLabel("Label Combine/Replace");
		inputParams.setName("Combine_Replace_Labels");

		AlgorithmInformation info = getAlgorithmInformation();
		info.setWebsite("http://www.iacl.ece.jhu.edu/");
		info.add(new AlgorithmAuthor("John Bogovic", "bogovic@jhu.edu", "http://www.iacl.ece.jhu.edu/John"));
		info.setDescription(shortDescription);
		info.setLongDescription(shortDescription + longDescription);
		info.setVersion(revnum);
		info.setEditable(false);
		info.setStatus(DevelopmentStatus.BETA);

	}

	@Override
	protected void createOutputParameters(ParamCollection outputParams) {
		outputParams.add(combinedLabelVolume = new ParamVolumeCollection("Combined Label Volumes"));
		combinedLabelVolume.setDescription("Volume of labels after combination.");
		combinedLabelVolume.setLoadAndSaveOnValidate(false);

	}

	@Override
	protected void execute(CalculationMonitor monitor)
			throws AlgorithmRuntimeException {
	
		if(combs==null){
			int[][] mycombs = null;
			tfr = new TextFileReader(combineParam.getValue());
			try {
				mycombs = tfr.parseIntFile();
				setCombinationParams(mycombs);
			} catch (IOException e) { 
				JistLogger.logError(JistLogger.WARNING, "LabelCombine: Unable to parse combination-file.");
				throw new RuntimeException("LabelCombine: Unable to parse combination-file.");
			}
		}
//		System.out.println(ArrayUtil.printArray(combs));
		
		
		setReplace(replace.getValue());
		
		if(!doreplace)removeduplicates(combs);//if combining, remove duplicates 

		
//		ImageData labelvol = labelVolume.getImageData();
		List<ImageData> srcfiles = labelVolume.getImageDataList();
		System.out.println(" labelVolume.getImageDataList().size(): " + labelVolume.getImageDataList().size());
		int n=0;
		ImageHeader hdr = null;
		for(ImageData src: srcfiles){
			Boolean isFourDimBinary = false;
//			ImageData src = vol.getImageData();
			System.out.println("Label rep: " + src);
			if(n==0){
				System.out.println("img0 " + src);
				hdr = src.getHeader();
			}
			
			if(src.getComponents() > 1){
				if(isBinary(src)){
					isFourDimBinary=true;
				}
			}

			ImageData outvol = src.mimic();

			if(isFourDimBinary){
				
				if(doreplace){
					outvol = src.clone();
					for(int i=0; i<src.getRows(); i++) 
						for(int j=0; j<src.getCols(); j++) 
							for(int k=0; k<src.getSlices(); k++)
								for(int c = 0; c < combs.length; c++){
									outvol.set(i,j,k,combs[c][0],0);
									outvol.set(i,j,k,combs[c][1],Math.max(src.getInt(i,j,k,combs[c][0]),outvol.getInt(i,j,k,combs[c][1])));
								}
				}else{
					outvol = src.mimic(src.getRows(),src.getCols(),src.getSlices(),combs.length);
					int union;
					for(int i=0; i<src.getRows(); i++) 
						for(int j=0; j<src.getCols(); j++) 
							for(int k=0; k<src.getSlices(); k++)
								for(int c = 0; c < combs.length; c++){
									union = 0;
									for(int c2 = 0; c2 < combs[0].length; c2++){
										if(combs[c][c2] > Integer.MIN_VALUE)
											union = Math.max(union, src.getInt(i,j,k,combs[c][c2]));
										
									}
									outvol.set(i,j,k,c,union);
								}
				}
			}else{
				if(doreplace){
					for(int i=0; i<src.getRows(); i++) for(int j=0; j<src.getCols(); j++) for(int k=0; k<src.getSlices(); k++){
							outvol.set(i,j,k,replace(combs,src.getInt(i,j,k)));
					}
				}else{
					for(int i=0; i<src.getRows(); i++) for(int j=0; j<src.getCols(); j++) for(int k=0; k<src.getSlices(); k++){
							outvol.set(i,j,k,search(combs,src.getInt(i,j,k)));
					}
				}
			}
			outvol.setHeader(hdr);
			outvol.setName(src.getName()+"_labelCombine");
			combinedLabelVolume.add(outvol);
			if(writeNow){
				combinedLabelVolume.writeAndFreeNow(this);
			}
			src.dispose();
			n++;
		}

	}
	
	private void removeduplicates(int[][] in){
		
		int currentVal = 0;
		for(int i = 0; i < in.length;i++ )
			for(int j = 0; j < in[i].length;j++){
				
				currentVal = in[i][j];
				if(currentVal > Integer.MIN_VALUE){
					for(int ii = i; ii < in.length;ii++ )
						for(int jj = 0; jj < in[ii].length;jj++){
							if(!(i == ii && j == jj) && in[ii][jj] == in[i][j]){
								in[ii][jj] = Integer.MIN_VALUE;
							}
						}
				}
			}
		
	}
	
	/**
	 * check if ImageData is Binary
	 * @param src
	 * @return
	 */
	private boolean isBinary(ImageData src){
		
		for(int i=0; i<src.getRows(); i++) 
			for(int j=0; j<src.getCols(); j++) 
				for(int k=0; k<src.getSlices(); k++)
					for(int c=0; c<src.getComponents(); c++){
						if(src.getInt(i, j, k, c) != 0 && src.getInt(i, j, k, c) != 1)
							return false;
					}
		return true;
	}
	
	/**
	 * returns the (first) row in array that contains val
	 * @param array
	 * @param val
	 * @return
	 */
	private int search(int[][] array, int val){
		for(int i=0; i<array.length; i++){
			for(int j=0; j<array[0].length; j++){
				if(array[i][j]==val){
					return i;
				}
			}
		}
		return -1;
	}
	
	/**
	 * returns the (first) row in array that contains val
	 * @param array
	 * @param val
	 * @return
	 */
	private int replace(int[][] array, int val){
		for(int i=0; i<array.length; i++){
			if(array[i][0]==val){
				return array[i][1];
			}
		}
		return val;
	}

}
