package edu.jhu.ece.iacl.plugins.qualitycontrol;

import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.jist.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.jist.pipeline.DevelopmentStatus;
import edu.jhu.ece.iacl.jist.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamBoolean;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamDouble;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamFile;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamOption;

public class MedicAlgorithmQualityControlNumber extends ProcessingAlgorithm{
	private ParamOption inParamPassCondition;	
	private ParamDouble inParamNumber, inParamUpperRange, inParamLowerRange;
	private ParamFile inParamSaveValues;
	private ParamBoolean outTestPassed;

	/****************************************************
	 * CVS Version Control
	 ****************************************************/
	private static final String cvsversion = "$Revision: 1.2 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "").replace(" ", "");
	private static final String shortDescription = "Checks if a measurement is within a certain range";
	private static final String longDescription = "";


	protected void createInputParameters(ParamCollection inputParams) {
		inputParams.add(inParamNumber=new ParamDouble("Number to monitor",0));
		String[] passConditions = {"Inside Range", "Outside Range", "Above Upper Range", "Below Lower Range"}; 
		inputParams.add(inParamPassCondition=new ParamOption("Monitor Pass When",passConditions));
		inputParams.add(inParamUpperRange=new ParamDouble("Upper Range",0));
		inputParams.add(inParamLowerRange=new ParamDouble("Lower Range",0));
		inputParams.setPackage("IACL");
		inputParams.setCategory("Quality Control");
		inputParams.setLabel("Quality Control - Number");
		inputParams.setName("QC_Number");


		AlgorithmInformation info = getAlgorithmInformation();
		info.setWebsite("");
		info.setAffiliation("");
		info.setDescription(shortDescription);
		info.setLongDescription(shortDescription + longDescription);
		info.setVersion(revnum);
		info.setEditable(false);
		info.setStatus(DevelopmentStatus.RC);
	}


	protected void createOutputParameters(ParamCollection outputParams) {
		outputParams.add(outTestPassed = new ParamBoolean("Quality Control Passed"));
	}


	protected void execute(CalculationMonitor monitor) {
		//check if metric passes condition
		double upperD = inParamUpperRange.getDouble();
		double lowerD = inParamLowerRange.getDouble();
		outTestPassed.setValue(false);//we set as fail by default and set true if it passes

		double metric = inParamNumber.getDouble();
		
		switch(inParamPassCondition.getIndex()){
		case 0: //Inside Range   
			if(metric < upperD && metric > lowerD) outTestPassed.setValue(true);
			break;
		case 1: //Outside Range
			if(metric > upperD && metric < lowerD) outTestPassed.setValue(true);
			break;
		case 2: //Above Upper Range
			if(metric > upperD) outTestPassed.setValue(true);
			break;
		case 3: //Below Lower Range
			if(metric < lowerD) outTestPassed.setValue(true);
			break;
		default:
			outTestPassed.setValue(false);
			break;
		}
	}


}
