/*
 *
 */
package edu.jhu.ece.iacl.plugins.registration;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import Jama.Matrix;

//import edu.jhu.ece.iacl.algorithms.PrinceGroupAuthors;
import edu.jhu.ece.iacl.algorithms.registration.RegistrationUtilities;
import edu.jhu.ece.iacl.algorithms.registration.RegistrationUtilities.InterpolationType;
import edu.jhu.ece.iacl.algorithms.registration.SmoothDefField;
import edu.jhu.ece.iacl.jist.io.ArrayDoubleMtxReaderWriter;
import edu.jhu.ece.iacl.jist.io.ArrayDoubleReaderWriter;
import edu.jhu.ece.iacl.jist.io.FileExtensionFilter;
import edu.jhu.ece.iacl.jist.io.ImageDataReaderWriter;
import edu.jhu.ece.iacl.jist.pipeline.AbstractCalculation;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation.AlgorithmAuthor;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation.Citation;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmRuntimeException;
import edu.jhu.ece.iacl.jist.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.jist.pipeline.DevelopmentStatus;
import edu.jhu.ece.iacl.jist.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamDouble;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamFileCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamFloat;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamInteger;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamMatrix;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamModel;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamOption;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamVolume;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamVolumeCollection;
import edu.jhu.ece.iacl.jist.structures.image.ImageData;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataFloat;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataMipav;
import edu.jhu.ece.iacl.jist.structures.image.ImageHeader;
import edu.jhu.ece.iacl.jist.utility.JistLogger;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamBoolean;
//import edu.jhu.ece.iacl.plugins.registration.MedicAlgorithmFLIRTCollection.FlirtWrapper;
import edu.jhu.ece.iacl.utility.ArrayUtil;


/*
 * @author Min Chen (mchen55@jhu.edu)
 *
 */
public class MedicAlgorithmDefFieldUtilities extends ProcessingAlgorithm{
	//Inputs
	public ParamVolume inParamDefField1;
	public ParamVolume inParamDefField2;
	public ParamOption inParamFieldTypeIn;
	public ParamOption inParamFieldTypeOut;
	public ParamOption inParamAlgorithmIn;
	public ParamOption inParamAlgorithmOut;
	public ParamOption inParamOperation;
	public ParamOption inParamAlgorithm;
	public ParamDouble  inParamN;
	//public ParamDouble inParamScaleFactor;

	//Outputs
	public ParamVolume outParamDefField;


	//Internal Variables
	int XN, YN, ZN, CN; 
	//int chN = 3;

	//Other Variables
	private static final String revnum = RegistrationUtilities.getVersion();
	private static final String shortDescription = "Utilities for deformation and displacement fields.";
	private static final String longDescription = "";


	protected void createInputParameters(ParamCollection inputParams) {
		inputParams.add(inParamDefField1 = new ParamVolume("Input Deformation Field 1"));
		inputParams.add(inParamDefField2 = new ParamVolume("Input Deformation Field 2(Optional)"));
		
		inParamDefField2.setMandatory(false);
		inputParams.add(inParamFieldTypeIn = new ParamOption("Input Field Type",
				new String[] { "Displacement","Deformation"}));
		inputParams.add(inParamAlgorithmIn = new ParamOption("Input From Algorithm",
				new String[] { "VABRA","SyN","DRAMMS"}));
		inputParams.add(inParamFieldTypeOut = new ParamOption("Output Field Type",
				new String[] { "Displacement","Deformation"}));
		inputParams.add(inParamAlgorithmOut = new ParamOption("Output For Algorithm",
				new String[] { "VABRA"}));

		inputParams.add(inParamOperation = new ParamOption("Operation",
				new String[] { "Convert Type", "Invert Field", "Smooth Field-NOT FUNCTIONAL", "Compose Field - F1(F2(x)) ",
								"Reorder Dimension: XYZT->TXYZ","Reorder Dimension: TXYZ->XYZT", "Find Field Magnitude", 
								"Find Field Jacobian Determinant", "Resample Field by Factor N", "Matrix Exponential (SS using N Steps)-NOT FUNCTIONAL", "Matrix Logarithm (ISS using N Steps)-NOT FUNCTIONAL"}));
		inputParams.add(inParamN = new ParamDouble("N Param (Specified in Operation)", 1));
		
		
		inputParams.setPackage("IACL");
		inputParams.setCategory("Registration.Volume");
		inputParams.setLabel("Deformation Field Utilities");
		inputParams.setName("DefFieldUtil");


		AlgorithmInformation info = getAlgorithmInformation();
		info.setWebsite("http://www.iacl.ece.jhu.edu/");
		info.add(new AlgorithmAuthor("Min Chen", "", ""));
		info.setDescription(shortDescription);
		info.setLongDescription(shortDescription + longDescription);
		info.setVersion(revnum);
		info.setEditable(false);
		info.setStatus(DevelopmentStatus.BETA);
	}


	protected void createOutputParameters(ParamCollection outputParams) {
		outputParams.add(outParamDefField=new ParamVolume("Output Deformation Field",null,-1,-1,-1,-1));
	}


	protected void execute(CalculationMonitor monitor) throws AlgorithmRuntimeException {
		ExecuteWrapper wrapper=new ExecuteWrapper();
		monitor.observe(wrapper);
		wrapper.execute(this);
	}


	protected class ExecuteWrapper extends AbstractCalculation{
		public void execute(ProcessingAlgorithm alg){

			//All operations are performed as displacement fields 

			ImageData inField1 = inParamDefField1.getImageData();
			ImageData inField2 = inParamDefField2.getImageData();
			ImageData outField;
			String nameSuffix;
			
			//convert to VABRA story type
			switch(inParamAlgorithmIn.getIndex()){
				case 0:
					//VABRA - Defalt JIST representation. Vectors are split into scalar maps at each components so c1=xxxx... c2=yyyy... c3=zzzz... 
					//Doesn't use header info.  
					break;
				case 1:
					//SyN- Vectors elements are split into scalar maps at each components so c1=xxxx... c2=yyyy... c3=zzzz... 
					//Uses header info.
					inField1 = RegistrationUtilities.synToVABRA(inParamDefField1.getImageData());
					if(inField2 != null)inField2 = RegistrationUtilities.synToVABRA(inParamDefField2.getImageData());
					break;
				case 2:
					//DRAMMS Vectors are presented sequentially. X/Y components flipped. So stored as YXZYXZYXZYXZ...
					//Doesn't use header info.  
					inField1 = RegistrationUtilities.drammsToVABRA(inParamDefField1.getImageData());
					if(inField2 != null)inField2 = RegistrationUtilities.drammsToVABRA(inParamDefField2.getImageData());
					break;
				default:
					break;
			
			}
			
			//convert to displacement field
			if(inParamFieldTypeIn.getIndex() == 1){
				RegistrationUtilities.convertField(inField1, true);
				if(inField2 != null) RegistrationUtilities.convertField(inField2, true);
			}

			System.out.format("Type:"+inParamOperation.getIndex() +"\n");
			
			switch(inParamOperation.getIndex()){

			case 0://Nothing needed for a conversion
				 outField = inField1;
				 nameSuffix="convert";
				 break;
			case 1://invert using Lotta's iterative method
				outField = inField1.mimic();
				RegistrationUtilities.invertDisplacementField(inField1, outField);
				nameSuffix = "inverse";
				break;
			case 2://Smooth with GVF (not grea) 
				SmoothDefField smooth = new SmoothDefField(inField1);
				outField = smooth.smoothDefField();
				nameSuffix = "smooth";
				break;
			case 3://Compose two deformations returns F1(F2(x)) 
				outField = RegistrationUtilities.composeDeformations(inField1, inField2);
				nameSuffix = "composed";
				break;
			case 4://move the 4th component into the first dimension
				outField = RegistrationUtilities.reorderDimension(inField1, true);
				nameSuffix = "reorderTDimToTXYZ";
				break;
			case 5://move the 4th component into the last dimension
				outField = RegistrationUtilities.reorderDimension(inField1, false);
				nameSuffix = "reorderTDimToXYZT";
				break;
			case 6://find magnitude of each vector
				outField = RegistrationUtilities.findFieldMagnitude(inField1);
				nameSuffix = "magnitude";
				break;
			case 7://find Jacobian at each voxel
				outField = new ImageDataFloat(RegistrationUtilities.computeJacobianDet(ArrayUtil.getFloatArray4d(inField1)));
				nameSuffix = "jacobian";
				break;
			case 8:
				XN = inField1.getRows();
				YN = inField1.getCols();
				ZN = inField1.getSlices();
				CN = inField1.getComponents();
				float resampleFactor = inParamN.getFloat();
				ImageDataFloat outFieldFloat = new ImageDataFloat((int)(XN*resampleFactor),(int)(YN*resampleFactor),(int)(ZN*resampleFactor), CN);
				RegistrationUtilities.DeformationFieldResample3DM(ArrayUtil.getFloatArray4d(inField1), outFieldFloat);
				outField = outFieldFloat;
				nameSuffix = "resample";
				break;
			case 9://exponential map of deformation field (not functional) 
				outField = RegistrationUtilities.findFieldExponentialSS(inField1,inParamN.getInt());
				nameSuffix = "exp";
				break;
			case 10://log map of deformation field (not functional)
				outField = RegistrationUtilities.findFieldLogarithmISS(inField1, inParamN.getInt());
				nameSuffix = "log";
				break;
			default://erro
				outField = inField1;
				nameSuffix="ERROR";
			}


			
			//convert to output field type
			if(inParamFieldTypeOut.getIndex() == 1) RegistrationUtilities.convertField(outField, false);
			outField.setName(inField1.getName() + "_" + nameSuffix);
			outParamDefField.setValue(outField);
		}
	}

	
}