package edu.jhu.ece.iacl.plugins.utilities.volume;

import java.util.ArrayList;
import java.util.List;

import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation.AlgorithmAuthor;
import edu.jhu.ece.iacl.jist.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.jist.pipeline.DevelopmentStatus;
import edu.jhu.ece.iacl.jist.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamBoolean;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamFloat;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamVolume;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamVolumeCollection;
import edu.jhu.ece.iacl.jist.structures.image.ImageData;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataFloat;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataUByte;
import edu.jhu.ece.iacl.jist.structures.image.ImageHeader;

public class MedicAlgorithmThresholdToBinaryMask extends ProcessingAlgorithm{
	//input params
	private ParamVolumeCollection volumes;
	private ParamFloat minValueText, maxValueText;
	private ParamBoolean useImageMax;

	private float minValue = 0.0f, maxValue = 0.0f;

	//output params
	private ParamVolumeCollection binmasks;

	//helper variables

	private static final String revnum = "$Revision: 1.2 $".replace("Revision: ", "").replace("$", "").replace(" ", "");
	private static final String shortDescription = "Given a volume and an intensity range create a binary mask for values within that range.\n";
	private static final String longDescription = "";


	protected void createInputParameters(ParamCollection inputParams) {
		volumes = new ParamVolumeCollection("Label Volumes", null, -1, -1, -1, -1);
		volumes.setDescription("Input volumes");
		volumes.setLoadAndSaveOnValidate(false);
		
		minValueText = new ParamFloat("Minimum Threshold", -10e8f, 10e8f, minValue);
		minValueText.setDescription("Minimum threshold value.");

		maxValueText = new ParamFloat("Maximum Threshold", -10e8f, 10e8f, maxValue);
		maxValueText.setDescription("Maximum threshold value.");

		useImageMax = new ParamBoolean("Use the images max intensity as the max value of the range", true);
		useImageMax.setDescription("Use the images max intensity as the max value of the range.");

		inputParams.add(volumes);
		inputParams.add(minValueText);
		inputParams.add(maxValueText);
		inputParams.add(useImageMax);


		inputParams.setPackage("IACL");
		inputParams.setCategory("Utilities.Volume");
		inputParams.setName("threshold_to_binary_mask");
		inputParams.setLabel("Threshold to Binary Mask");


		AlgorithmInformation info = getAlgorithmInformation();
		info.setWebsite("http://www.iacl.ece.jhu.edu/");
		info.add(new AlgorithmAuthor("Aaron Carass", "aaron_carass@jhu.edu", "http://www.iacl.ece.jhu.edu/"));
		info.setDescription(shortDescription);
		info.setLongDescription(shortDescription + longDescription);
		info.setVersion(revnum);
		info.setEditable(false);
		info.setStatus(DevelopmentStatus.RC);
	}


	protected void createOutputParameters(ParamCollection outputParams) {	
		outputParams.add(binmasks = new ParamVolumeCollection("Binary Mask",null, -1, -1, -1, -1));
		binmasks.setLoadAndSaveOnValidate(false);
	}


	protected void execute(CalculationMonitor monitor) {
		
		List<ParamVolume> srcfiles = volumes.getParamVolumeList();
		minValue = minValueText.getFloat();
		maxValue = maxValueText.getFloat();
		
		for(ParamVolume pv: srcfiles){
			//read the source filess
			ImageData image = pv.getImageData();
			
			int XN = image.getRows();
			int YN = image.getCols();
			int ZN = image.getSlices();
			int i = 0, j = 0, k = 0;

			float[][][] dataVol = (new ImageDataFloat(image)).toArray3d();
			ImageDataUByte bin_image = new ImageDataUByte(XN, YN, ZN);
			System.out.println("min value="+minValue+",max value="+maxValue+"\n");

			for (k = 0; k < ZN; k++){
				for (j = 0; j < YN; j++){
					for (i = 0; i < XN; i++){
						if (dataVol[i][j][k] > minValue && (dataVol[i][j][k] < maxValue || useImageMax.getValue()))
						{
							bin_image.set(i, j, k, 1);
						}
						else
							bin_image.set(i, j, k, 0);
					}
				}
			}
			ImageHeader info = image.getHeader();
			String name=image.getName()+"_binmask";
			System.out.println("name="+name+"\n");	
			bin_image.setName(name);
			bin_image.setHeader(info);
			
			binmasks.add(bin_image);
			binmasks.writeAndFreeNow(this);
			
		}

	}
}
