package edu.vanderbilt.VUIIS.algorithms;

import edu.jhu.bme.smile.commons.math.Spline;
import edu.jhu.ece.iacl.jist.structures.image.ImageData;
import edu.jhu.ece.iacl.jist.structures.image.ImageDataFloat;
import edu.jhu.ece.iacl.jist.utility.JistLogger;

public class CESTSmooth {

	public double[] getyinterp_right(Spline func,int interp,double[] offsetArray){
		double max = -Double.MAX_VALUE;
		double min = Double.MAX_VALUE;
		for(int i=0;i<offsetArray.length;i++) {
			max = (max<offsetArray[i]?offsetArray[i]:max);
			min = (min>offsetArray[i]?offsetArray[i]:min);
		}
		double delta = max/(interp-1);
		double[] y = new double[interp];
		double i=0;
		for(int idx=0;idx<interp;idx++){
			i = delta*idx;
			y[idx] = func.spline_value(i);
		}
		return y;
	}
	
	public double[] getxinterp_right(Spline func,int interp,double[] offsetArray){
		double max = -Double.MAX_VALUE;
		double min = Double.MAX_VALUE;
		for(int i=0;i<offsetArray.length;i++) {
			max = (max<offsetArray[i]?offsetArray[i]:max);
			min = (min>offsetArray[i]?offsetArray[i]:min);
		}
		double delta = max/(interp-1);
		double[] x = new double[interp];
		for(int idx=0;idx<interp;idx++){
			x[idx] = delta*idx;
		}
		return x;
	}
	
	public double[] getyinterp_left(Spline func,int interp,double[] offsetArray){
		double max = -Double.MAX_VALUE;
		double min = Double.MAX_VALUE;
		for(int i=0;i<offsetArray.length;i++) {
			max = (max<offsetArray[i]?offsetArray[i]:max);
			min = (min>offsetArray[i]?offsetArray[i]:min);
		}
		double delta = max/(interp-1);
		double[] y = new double[interp];
		double i=0;
		for(int idx=0;idx<interp;idx++){
			i = min + delta*idx;
			y[idx] = func.spline_value(i);
		}
		return y;
	}
	
	public double[] getxinterp_left(Spline func,int interp,double[] offsetArray){
		double max = -Double.MAX_VALUE;
		double min = Double.MAX_VALUE;
		for(int i=0;i<offsetArray.length;i++) {
			max = (max<offsetArray[i]?offsetArray[i]:max);
			min = (min>offsetArray[i]?offsetArray[i]:min);
		}
		double delta = max/(interp-1);
		double[] x = new double[interp];
		for(int idx=0;idx<interp;idx++){
			x[idx] = min + delta*idx;
		}
		return x;
	}
	
	public double[] getsmooth(double[] y, int window){
		int interp = y.length;
		int half = (window-1)/2;
		double[] smooth = new double[interp];
		for(int i=0; i<half;i++){
			int count = 0;
			for(int j=i;j>=-i;j--){
				smooth[i] = smooth[i] + y[i-j];
				count++;
			}
			smooth[i] = smooth[i]/count;
		}
		for(int i=half;i<interp-half;i++){
			int count = 0;
			for(int j=half;j>=-half;j--){
			smooth[i] = smooth[i] + y[i-j];
			count++;
			}
			smooth[i] = smooth[i]/window;
		}
		int idx = 0;
		int start = half-1;
		for(int i=interp-half;i<interp;i++){
			int count = 0;
			for(int j=start-idx;j>=-start+idx;j--){
				smooth[i] = smooth[i] + y[i-j];
				count++;
			}
			smooth[i] = smooth[i]/count;
			idx++;
		}
		return smooth;
	}

}