package edu.vanderbilt.VUIIS.algorithms;

import edu.jhu.bme.smile.commons.math.Spline;
import edu.jhu.ece.iacl.jist.utility.JistLogger;

public class GaussianFunction {
	
	
	public double[] createGaussianCurve(double stdDev, double mean, int N) {
		
		double[] y = new double[N];
		double variance = stdDev*stdDev;
		
		double adj_std = .5;
		stdDev = adj_std*stdDev;
		
		double adj_h = 1;
		
		for(int idx=0;idx<N;idx++){
			y[idx] = Math.pow(Math.exp(-((idx - mean) * (idx - mean)) / (2 * variance)), 1 / (stdDev * Math.sqrt(2 * Math.PI)))*adj_h;
		}
		
		return y;
	}
	
	public double[] createGaussian(double[] offsetArray, int tcest, double adj_mid, double adj_h, double adj_w){
		double max = -Double.MAX_VALUE;
		double min = Double.MAX_VALUE;
		for(int i=0;i<offsetArray.length;i++) {
			max = (max<offsetArray[i]?offsetArray[i]:max);
			min = (min>offsetArray[i]?offsetArray[i]:min);
		}
		int num = Math.round((float)(max-min));
		if(num<20)
			num = num*70;
		double[] x = new double[num];
		double[] y = new double[num];
		double delta_x = num/tcest;
		double mean = adj_mid*delta_x;
		
		double stdDev = (delta_x/(2*Math.sqrt(2*Math.log(2))))*adj_w;
		
		for(int idx=0;idx<num;idx++){
			x[idx] = idx;
			y[idx] = Math.pow(Math.exp(-((idx-mean)*(idx-mean)/((2*stdDev*stdDev)))),(1/(stdDev*Math.sqrt(2*Math.PI))));
		}
		
		Spline gauss_spline = new Spline(x,y);
		
		double[] x_spline = new double[tcest];
		double[] y_spline = new double[tcest];
		
		double step = num/tcest;
		double count = 0;
		
		for(int idx=0;idx<tcest;idx++){
			x_spline[idx] = idx;
			y_spline[idx] = gauss_spline.spline_value(count)*adj_h;
			count = count + step;
		}
		return y_spline;
	}
	
	public double[] createCauchy(double[] offsetArray,int tcest,double adj_mid, double adj_h, double adj_w){
		double max = -Double.MAX_VALUE;
		double min = Double.MAX_VALUE;
		for(int i=0;i<offsetArray.length;i++) {
			max = (max<offsetArray[i]?offsetArray[i]:max);
			min = (min>offsetArray[i]?offsetArray[i]:min);
		}
		int num = Math.round((float)(max-min));
		if(num<20)
			num = num*70;
		double[] x = new double[num];
		double[] y = new double[num];
		double delta_x = num/tcest;
		double mean = adj_mid*delta_x;
		
		double gamma = (delta_x/(2*Math.sqrt(2*Math.log(2))))*adj_w;
		
		for(int idx=0;idx<num;idx++){
			x[idx] = idx;
			y[idx] = (1/Math.PI)*(gamma/(Math.pow(idx-mean,2)+Math.pow(gamma,2)));
		}
		
		Spline gauss_spline = new Spline(x,y);
		
		double[] x_spline = new double[tcest];
		double[] y_spline = new double[tcest];
		double y_max = 0;
		double count = 0;
		for(int idx=0;idx<tcest;idx++){
			x_spline[idx] = idx;
			y_spline[idx] = gauss_spline.spline_value(count);
			if(y_spline[idx]>y_max){
				y_max = y_spline[idx];
			}
			count = count + delta_x;
		}
		double scale = 1/y_max;
		for(int idx=0;idx<tcest;idx++){
			y_spline[idx] = y_spline[idx]*scale;
			y_spline[idx] = y_spline[idx]*adj_h;
		}
		
		return y_spline;
	}
	
	public double[] createLaplacian(double[] offsetArray,int tcest,double adj_mid, double adj_h, double adj_w){
		double max = -Double.MAX_VALUE;
		double min = Double.MAX_VALUE;
		for(int i=0;i<offsetArray.length;i++) {
			if(offsetArray[i]>max)
				max = offsetArray[i];
			if(offsetArray[i]<min)
				min = offsetArray[i];
		}
		int num = Math.round((float)(max-min));
		if(num<20)
			num = num*70;
		double[] x = new double[num];
		double[] y = new double[num];
		double delta_x = num/tcest;
		double mean = adj_mid*delta_x;
		
		double b = (delta_x/(2*Math.sqrt(2*Math.log(2))))*adj_w;
		
		for(int idx=0;idx<num;idx++){
			x[idx] = idx;
			y[idx] = (1/(2*b))*Math.exp(-(Math.abs(idx-mean)/b));
		}
		
		Spline gauss_spline = new Spline(x,y);
		
		double[] x_spline = new double[tcest];
		double[] y_spline = new double[tcest];
		double y_max = 0;
		double count = 0;
		for(int idx=0;idx<tcest;idx++){
			x_spline[idx] = idx;
			y_spline[idx] = gauss_spline.spline_value(count);
			if(y_spline[idx]>y_max){
				y_max = y_spline[idx];
			}
			count = count + delta_x;
		}
		double scale = 1/y_max;
		for(int idx=0;idx<tcest;idx++){
			y_spline[idx] = y_spline[idx]*scale;
			y_spline[idx] = y_spline[idx]*adj_h;
		}
		
		return y_spline;
	}
}
	
