package edu.vanderbilt.masi.algorithms.clasisfication;

import java.io.*;
import java.util.*;
import org.json.*;

import edu.vanderbilt.masi.algorithms.clasisfication.decisiontree.DecisionTreeClassifier;

public abstract class Classifier {
	
	public boolean trained=false;
	
	public abstract void writeToFile(File f);
	
	public abstract void buildFromJSON(JSONObject obj);
	
	public static Classifier readFromFile(File f){
		Classifier c = null;
		try {
			FileReader fstream = new FileReader(f);
			BufferedReader br = new BufferedReader(fstream);
			String line = br.readLine();
			JSONObject obj = new JSONObject(line);
			if(obj.getString("classifier_type").equals("Decision Tree")){
				c = new DecisionTreeClassifier();
				c.buildFromJSON(obj);
			}
			br.close();
			fstream.close();
		} catch (IOException e) {
			e.printStackTrace();
		} catch (JSONException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return c;
	}

	public abstract void train(float[][] features,int[] target, float[] weight);
	
	public abstract Classifier basicClone();
	
	public abstract HashMap<Integer,Float> score(float[] features);

}
