package edu.vanderbilt.masi.algorithms.clasisfication;

import java.io.*;

import org.json.*;

import java.util.*;
import java.util.zip.GZIPInputStream;

import edu.jhu.ece.iacl.jist.structures.image.ImageData;
import edu.jhu.ece.iacl.jist.utility.JistLogger;

public class ErrorClassificationRunner {

	private ImageData hostLabels;
	private ImageData manualLabels;
	private HashMap<Integer,Classifier> classifiers;
	private boolean ignore_backgroud;


	public ErrorClassificationRunner(List<File> classifiers, File features,
			ImageData hostLabels, ImageData manualLabels, boolean ignore_background) {
		JistLogger.logOutput(JistLogger.INFO, "Started Loading Classifiers");
		this.hostLabels = hostLabels;
		this.manualLabels = manualLabels;
		this.classifiers = new HashMap<Integer,Classifier>(1000,(float).3);
		this.ignore_backgroud=ignore_background;
		for(File f:classifiers){
			String name = f.getName();
			name = name.replace("Classifier", "");
			name = name.replace(".json","");
			this.classifiers.put(Integer.parseInt(name),Classifier.readFromFile(f));
		}
		JistLogger.logOutput(JistLogger.INFO, "There were "+this.classifiers.size()+" in total");
		this.runClassification(features);
	}

	private void runClassification(File features){
		try {
			JistLogger.logOutput(JistLogger.INFO, "Starting calculations and such");
			JistLogger.logFlush();
			int numFixed = 0;
			int numCreated = 0;
			int n=0;
			InputStream fileStream = new FileInputStream(features.getAbsoluteFile());
			InputStream gzipStream = new GZIPInputStream(fileStream);
			Reader decoder = new InputStreamReader(gzipStream, "utf-8");
			BufferedReader br = new BufferedReader(decoder);
			String line = br.readLine();
			JSONObject obj = new JSONObject(line);
			int number = obj.getInt("number");
			JistLogger.logOutput(JistLogger.INFO, "There are "+number+" features" );
			JistLogger.logFlush();
			while((line=br.readLine())!=null){
				n++;
				if(n % 100000==0){
					JistLogger.logOutput(JistLogger.INFO, "On number "+n+" out of "+number);
					JistLogger.logFlush();
				}
				obj = new JSONObject(line);
				int x = obj.getInt("x");
				int y = obj.getInt("y");
				int z = obj.getInt("z");
				if(!(this.hostLabels.getInt(x, y,z)==0&&this.ignore_backgroud)){
					Classifier c = this.classifiers.get(this.hostLabels.getInt(x,y,z));
					JSONArray a = obj.getJSONArray("features");
					float[] featureVector = new float[a.length()];
					for(int i=0;i<a.length();i++) featureVector[i] = (float) a.getDouble(i);
					HashMap<Integer,Float> scores = c.score(featureVector);
					if(scores.containsKey(-1)&&scores.get(-1)>0.95){
						if(this.hostLabels.getInt(x,y,z)==this.manualLabels.getInt(x,y,z)) numCreated++;
						else numFixed++;
					}
				}

			}
			br.close();
			decoder.close();
			JistLogger.logOutput(JistLogger.INFO, "There were "+numCreated+" misclassified voxels created and "+numFixed+" voxels fixed" );
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (JSONException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

}
