package edu.vanderbilt.masi.algorithms.dti;

import java.io.File;
import java.io.IOException;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;



public class ExamCardParser {
	File examcard;
	Document doc;
	final protected String basePath="/dump/folder/examcard";
	/**
	 * Reference scan information
	 */
	String refScanName;
	int[] refFOV = new int[3];
	float[] refAcquiredVoxels=new float[3];
	float refSliceThickness;
	boolean refFoldOverSupression;
	String refSliceOrientation;
	String refFoldOverDirection;
	String refFatShiftDir;
	float[] refOffCenter=new float[3];			//AP/RL/FH
	float[] refAngulation=new float[3];			//AP/RL/FH
	float refNumberOfSlices;
	
	//These aren't in the exam card
	int refOverscanM;
	int refOverscanP;
	int refNumCoils;
	int refBodyCoilInd;
	
	/**
	 * DWI scan information
	 */
	
	String dwiScanName;
	Boolean dwiZOOM;
	String dwiShotMode;
	int dwiNSA;
	int dwiNumCoil;
	float[] dwiFOV = new float[3];
	int dwiAcqVoxM;
	float dwiSliceThickness;
	int dwiAcqRes;
	int dwiReconRes;
	int dwiSenseFact;
	float dwiSliceGap;
	String dwiSliceOrientation;
	String dwiFoldOverDir;
	String dwiFatShiftDir;
	String dwiScanMode;
	float[] dwiOffCenter=new float[3];
	float[] dwiAngulation= new float[3];
	Boolean dwiIsEPI;
	int[] dwiEPIFactor = new int[2];
	int dwiNumEC;
	int dwiNumRow;
	String dwiDirRes;
	Boolean dwiGradOverplus;
	float[][][] dwiGradTable;
	int dwiNumGrad;
	int[] dwiTRB = new int[2];
	int[] dwiBW = new int[2];
	int dwiReducedAcqTime;
	int dwiSTDStart;
	int dwiPHCStart;
	String dwiSSHFname;
	int dwiSSHtrb;
	int dwiSSHNumSlice;
	int dwiSSHSliceThickness;
	int dwiSSHNGrad;
	float[] dwiSSHVoxMPS=new float[3];
	int dwiAcqVoxP;
	int dwiNumShots;
	int navEPIFactor;
	int dwiNumEchoes;
	
	
	public ExamCardParser(){
	}
	
	public ExamCardParser(File f){
		this.examcard = f;
	}
	
	public ExamCardParser(File f,String dwiScanName){
		this.examcard = f;
		this.dwiScanName = dwiScanName;
	}
	
	//Default constructor to set the file and init
	public ExamCardParser(File f,String dwiScanName,String refScanName) throws ParserConfigurationException, SAXException, IOException{
		this.examcard = f;
		this.dwiScanName = dwiScanName;
		this.refScanName = refScanName;
		init();
	}
	
	/**
	 * init the xml document
	 */
	private void init() throws ParserConfigurationException, SAXException, IOException {
		DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
		DocumentBuilder builder = factory.newDocumentBuilder();
		doc = builder.parse(examcard);
	}
	
	/**
	 * Method to parse all the reference scan params.
	 * @throws XPathExpressionException
	 * @throws ExamCardParserException
	 */
	public void parseRef() throws XPathExpressionException, ExamCardParserException{
		
		XPath xPath =  XPathFactory.newInstance().newXPath();
		
		//FH FOV
		XPathExpression expr = xPath.compile("//protocol[@id='"+refScanName+"']/group[@name='geometry']/parameter[@name_ppe='EX_GEO_fov']/@value");
		Object result = expr.evaluate(doc,XPathConstants.STRING);
		refFOV[0]= Integer.valueOf(result.toString());
		
		//RL FOV
		expr = xPath.compile("//protocol[@id='"+refScanName+"']/group[@name='geometry']/parameter[@name_ppe='EX_GEO_fov']/subparameter[@name_ppe='EX_GEO_fov_p']/@value");
		result = expr.evaluate(doc,XPathConstants.STRING);
		refFOV[1]= Integer.valueOf(result.toString());
		
		//AP FOV
		expr = xPath.compile("//protocol[@id='"+refScanName+"']/group[@name='geometry']/parameter[@name_ppe='EX_GEO_fov']/subparameter[@name_ppe='EX_GEO_cur_stack_fov_s']/@value");
		result = expr.evaluate(doc,XPathConstants.STRING);
		refFOV[2]= Integer.valueOf(result.toString());
		
		//FH Voxel Size
		expr = xPath.compile("//protocol[@id='"+refScanName+"']/group[@name='geometry']/parameter[@name_ppe='EX_GEO_voxel_size_m']/@value");
		result = expr.evaluate(doc,XPathConstants.STRING);
		refAcquiredVoxels[0]= Float.valueOf(result.toString());
		
		//RL Voxel Size
		expr = xPath.compile("//protocol[@id='"+refScanName+"']/group[@name='geometry']/parameter[@name_ppe='EX_GEO_voxel_size_m']/subparameter[@name_ppe='EX_GEO_voxel_size_p']/@value");
		result = expr.evaluate(doc,XPathConstants.STRING);
		refAcquiredVoxels[1]= Float.valueOf(result.toString());
		
		//AP Voxel Size
		expr = xPath.compile("//protocol[@id='"+refScanName+"']/group[@name='geometry']/parameter[@name_ppe='EX_GEO_voxel_size_m']/subparameter[@name_ppe='EX_GEO_voxel_size_s']/@value");
		result = expr.evaluate(doc,XPathConstants.STRING);
		refAcquiredVoxels[2]= Float.valueOf(result.toString());
		
		//Slice Thickness
		expr = xPath.compile("//protocol[@id='"+refScanName+"']/group[@name='geometry']/parameter[@name_ppe='EX_GEO_stacks']/subparameter[@name_ppe='EX_GEO_slice_thickness']/@value");
		result = expr.evaluate(doc,XPathConstants.STRING);
		refSliceThickness = Float.valueOf(result.toString());
		
		//Fold over supression
		expr = xPath.compile("//protocol[@id='"+refScanName+"']/group[@name='geometry']/parameter[@name_ppe='EX_ACQ_foldover_sup']/@value");
		result = expr.evaluate(doc,XPathConstants.STRING);
		System.out.println(result);
		if (result.toString().equals("yes")){
			refFoldOverSupression = true;
		}else if (result.toString().equals("no")){
			refFoldOverSupression = false;
		}else{
			throw new ExamCardParserException("Error: Fold over suppression value could not be parsed.");
		}
		
		//Slice orientation
		expr = xPath.compile("//protocol[@id='"+refScanName+"']/group[@name='geometry']/parameter[@name_ppe='EX_GEO_stacks']/subparameter[@name_ppe='EX_GEO_cur_stack_orientation']/@value");
		result = expr.evaluate(doc,XPathConstants.STRING);
		refSliceOrientation = result.toString();
		
		//Fold over Direction
		expr = xPath.compile("//protocol[@id='"+refScanName+"']/group[@name='geometry']/parameter[@name_ppe='EX_GEO_stacks']/subparameter[@name_ppe='EX_GEO_cur_stack_prep_dir']/@value");
		result = expr.evaluate(doc,XPathConstants.STRING);
		refFoldOverDirection = result.toString();
		
		//Fat shift direction
		expr = xPath.compile("//protocol[@id='"+refScanName+"']/group[@name='geometry']/parameter[@name_ppe='EX_GEO_stacks']/subparameter[@name_ppe='EX_GEO_cur_stack_fat_shift_dir']/@value");
		result = expr.evaluate(doc,XPathConstants.STRING);
		refFatShiftDir=result.toString();
		
		//Off Center AP
		expr = xPath.compile("//protocol[@id='"+refScanName+"']/group[@name='offc/ang']/parameter[@name_ppe='EX_GEO_cur_stack_ap_offcentre']/@value");
		result = expr.evaluate(doc,XPathConstants.STRING);
		refOffCenter[0]= Float.valueOf(result.toString());
		
		//Off Center RL
		expr = xPath.compile("//protocol[@id='"+refScanName+"']/group[@name='offc/ang']/parameter[@name_ppe='EX_GEO_cur_stack_ap_offcentre']/subparameter[@name_ppe='EX_GEO_cur_stack_lr_offcentre']/@value");
		result = expr.evaluate(doc,XPathConstants.STRING);
		refOffCenter[1] = Float.valueOf(result.toString());
		
		//Off Center FH
		expr = xPath.compile("//protocol[@id='"+refScanName+"']/group[@name='offc/ang']/parameter[@name_ppe='EX_GEO_cur_stack_ap_offcentre']/subparameter[@name_ppe='EX_GEO_cur_stack_fh_offcentre']/@value");
		result = expr.evaluate(doc,XPathConstants.STRING);
		refOffCenter[2] = Float.valueOf(result.toString());
		
		//Angulation AP
		expr = xPath.compile("//protocol[@id='"+refScanName+"']/group[@name='offc/ang']/parameter[@name_ppe='EX_GEO_cur_stack_ap_offcentre']/subparameter[@name_ppe='EX_GEO_cur_stack_ap_angulation']/@value");
		result = expr.evaluate(doc,XPathConstants.STRING);
		refAngulation[0]= Float.valueOf(result.toString());
		
		//Angulation RL
		expr = xPath.compile("//protocol[@id='"+refScanName+"']/group[@name='offc/ang']/parameter[@name_ppe='EX_GEO_cur_stack_ap_offcentre']/subparameter[@name_ppe='EX_GEO_cur_stack_lr_angulation']/@value");
		result = expr.evaluate(doc,XPathConstants.STRING);
		refAngulation[1] = Float.valueOf(result.toString());
		
		//Angulation FH
		expr = xPath.compile("//protocol[@id='"+refScanName+"']/group[@name='offc/ang']/parameter[@name_ppe='EX_GEO_cur_stack_ap_offcentre']/subparameter[@name_ppe='EX_GEO_cur_stack_fh_angulation']/@value");
		result = expr.evaluate(doc,XPathConstants.STRING);
		refAngulation[2] = Float.valueOf(result.toString());

	}
	
	public void parseDWI() throws XPathExpressionException, ExamCardParserException{
		
		XPath xPath =  XPathFactory.newInstance().newXPath();
		//Scan Mode
		XPathExpression expr = xPath.compile("//protocol[@id='"+dwiScanName+"']/group[@name='contrast']/parameter[@name_ppe='EX_ACQ_scan_mode']/@value");
		Object result = expr.evaluate(doc,XPathConstants.STRING);
		dwiScanMode = result.toString();
		
		//Shot mode
		expr = xPath.compile("//protocol[@id='"+dwiScanName+"']/group[@name='contrast']/parameter[@name_ppe='EX_ACQ_fast_imaging_mode']/subparameter['EX_ACQ_shot_mode']/@value");
		result = expr.evaluate(doc,XPathConstants.STRING);
		dwiShotMode= result.toString();
		
		//EPI Factor - EPI Factor
		expr = xPath.compile("//protocol[@id='"+dwiScanName+"']/group[@name='contrast']/parameter[@name_ppe='EX_ACQ_epi_factor']/@value");
		result = expr.evaluate(doc,XPathConstants.STRING);
		dwiEPIFactor[0] = Integer.valueOf(result.toString());
		
		//EPI Factor - Navigator	- This needs to already be set.
		dwiEPIFactor[1]=navEPIFactor;
		
		//Echoes
		expr = xPath.compile("//protocol[@id='"+dwiScanName+"']/group[@name='contrast']/parameter[@name_ppe='EX_ACQ_echoes']/@value");
		result = expr.evaluate(doc,XPathConstants.STRING);
		dwiNumEchoes = Integer.valueOf(result.toString());
		
		//Halfscan factor
		
		//FOV FH
		expr = xPath.compile("//protocol[@id='"+dwiScanName+"']/group[@name='geometry']/parameter[@name_ppe='EX_GEO_fov']/@value");
		result = expr.evaluate(doc,XPathConstants.STRING);
		dwiFOV[0] = Float.valueOf(result.toString());
		
		//FOV RL
		expr = xPath.compile("//protocol[@id='"+dwiScanName+"']/group[@name='geometry']/parameter[@name_ppe='EX_GEO_fov']/subparameter[@name_ppe='EX_GEO_fov_p']/@value");
		result = expr.evaluate(doc,XPathConstants.STRING);
		dwiFOV[1] = Float.valueOf(result.toString());
		
		//FOV AP
		expr = xPath.compile("//protocol[@id='"+dwiScanName+"']/group[@name='geometry']/parameter[@name_ppe='EX_GEO_fov']/subparameter[@name_ppe='EX_GEO_cur_stack_fov_s']/@value");
		result = expr.evaluate(doc,XPathConstants.STRING);
		dwiFOV[2] = Float.valueOf(result.toString());
		
		//SENSE Factor -- GET BY NAME RATHER THAN NAME_PPE BECAUSE THEY AREN'T ALL DEFINED IN EXAMCARD
		expr = xPath.compile("//protocol[@id='"+dwiScanName+"']/group[@name='geometry']/parameter[@name_ppe='EX_GEO_sense_enable']/subparameter[@name='P reduction (RL)']/@value");
		Object resultRL = expr.evaluate(doc,XPathConstants.STRING);
		expr = xPath.compile("//protocol[@id='"+dwiScanName+"']/group[@name='geometry']/parameter[@name_ppe='EX_GEO_sense_enable']/subparameter[@name='P reduction (AP)']/@value");
		Object resultAP = expr.evaluate(doc,XPathConstants.STRING);
		expr = xPath.compile("//protocol[@id='"+dwiScanName+"']/group[@name='geometry']/parameter[@name_ppe='EX_GEO_sense_enable']/subparameter[@name='P reduction (FH)']/@value");
		Object resultFH = expr.evaluate(doc,XPathConstants.STRING);
		if (resultRL.toString().equals("") && resultAP.toString().equals("") && resultFH.toString().equals("")){
			throw new ExamCardParserException("Can not determin SENSE factor");
		}else if(!resultRL.toString().equals("")){
			dwiSenseFact = Integer.valueOf(resultRL.toString());
		}else if(!resultAP.toString().equals("")){
			dwiSenseFact = Integer.valueOf(resultAP.toString());
		}else if(!resultFH.toString().equals("")){
			dwiSenseFact = Integer.valueOf(resultFH.toString());
		}
		
		
		
		
		
		
		
		
		/*  NOT IN EXAMCARD
		 *  Boolean dwiZOOM
		 *  int dwiAcqVoxM;
		 *  int dwiNSA;
			int dwiNumCoil
			
			
			** IN EXAMCARD			
			float dwiSliceThickness;
			int dwiAcqRes;
			int dwiReconRes;
			float dwiSliceGap;
			String dwiSliceOrientation;
			String dwiFoldOverDir;
			String dwiFatShiftDir;
			float[] dwiOffCenter=new float[3];
			float[] dwiAngulation= new float[3];
			Boolean dwiIsEPI;
			int dwiNumEC;
			int dwiNumRow;
			String dwiDirRes;
			Boolean dwiGradOverplus;
			float[][][] dwiGradTable;
			int dwiNumGrad;
			int[] dwiTRB = new int[2];
			int[] dwiBW = new int[2];
			int dwiReducedAcqTime;
			int dwiSTDStart;
			int dwiPHCStart;
			String dwiSSHFname;
			int dwiSSHtrb;
			int dwiSSHNumSlice;
			int dwiSSHSliceThickness;
			int dwiSSHNGrad;
			float[] dwiSSHVoxMPS=new float[3];
			int dwiAcqVoxP;
			int dwiNumShots;
		 */
	}
	
	//*******Begin Reference getters
	
	
	
	
	//*******End Reference getters
	
	
	public void setNavEPIFactor(int factor){
		this.navEPIFactor=factor;
	}

}
