package edu.vanderbilt.masi.algorithms.dti;

public class ReferenceUtils {
	float[][][] NOI_REAL;
	float[][][] NOI_IMAG;
	float[][] PSI_REAL;
	float[][] PSI_IMAG;
	
	private int numCoils;
	
	/**
	 * Default constructor set the data arrays. Set 
	 * @param NOI_REAL a nKX,nLocation,nCoils array of the real data
	 * @param NOI_IMAG a nKX,nLocation,nCoils array of the imag data
	 */
	public ReferenceUtils(float[][][] NOI_REAL,float[][][] NOI_IMAG){
		this.NOI_REAL = NOI_REAL;
		this.NOI_IMAG = NOI_IMAG;
		this.numCoils = 8;		//TESTING
		computeNoiseCorrMatrix();
	}
	
	
	/**
	 * Method to compute the noise correlation matrix which is an nCoils x nCoils array.
	 * Set two nC x nC arrays 1 fore real 1 for imag
	 */
	public void computeNoiseCorrMatrix(){
		float[][] PSI_REAL = new float[numCoils][numCoils];
		float[][] PSI_IMAG = new float[numCoils][numCoils];
		//Don't want all the data, just :,1,1:numCoils;
		//These should be the same, but lets not assume. 
	
		
		float[] num_real = new float[NOI_REAL.length];
		float[] num_imag = new float[NOI_IMAG.length];
		float[] denom_real_lh = new float[NOI_REAL.length];
		float[] denom_imag_lh = new float[NOI_IMAG.length];
		float[] denom_real_rh = new float[NOI_REAL.length];
		float[] denom_imag_rh = new float[NOI_IMAG.length];
		
		
		for (int i=0; i < numCoils; i++){
			for (int j =0; j< numCoils; j++){
				
				//Real data i column
				for (int k=0;k<NOI_REAL.length;k++){
					
					
					num_real[k] = NOI_REAL[k][0][j]*NOI_REAL[k][0][i] - NOI_IMAG[k][0][j]*-1*NOI_IMAG[k][0][i];
					num_imag[k] = NOI_REAL[k][0][j]*NOI_IMAG[k][0][i]+NOI_IMAG[k][0][j]*-1*NOI_REAL[k][0][i];
					denom_real_lh[k] = NOI_REAL[k][0][i]*NOI_REAL[k][0][i] - NOI_IMAG[k][0][i]*-1*NOI_IMAG[k][0][i];
					denom_real_rh[k] = NOI_REAL[k][0][j]*NOI_REAL[k][0][j] - NOI_IMAG[k][0][j]*-1*NOI_IMAG[k][0][j];
					denom_imag_lh[k] = NOI_REAL[k][0][i]*-1*NOI_IMAG[k][0][i]+NOI_IMAG[k][0][i]*NOI_REAL[k][0][i];
					denom_imag_rh[k] = NOI_REAL[k][0][j]*-1*NOI_IMAG[k][0][j]+NOI_IMAG[k][0][j]*NOI_REAL[k][0][j];
				}
				
				float sumNum_Real = 0;
				float sumDenom_Real_lh = 0;
				float sumDenom_Real_rh = 0;
				float sumNum_Imag = 0;
				float sumDenom_Imag_rh = 0;
				float sumDenom_Imag_lh = 0;
				for (int k=0;k<denom_real_lh.length;k++){
					sumDenom_Real_lh+= denom_real_lh[k];
					sumDenom_Imag_lh+= denom_imag_lh[k];
					sumDenom_Real_rh+= denom_real_rh[k];
					sumDenom_Imag_rh+= denom_imag_rh[k];
					sumNum_Real+= num_real[k];
					sumNum_Imag+= num_imag[k];
				}
				float tempRealDenom = sumDenom_Real_lh*sumDenom_Real_rh-sumDenom_Imag_lh*sumDenom_Imag_rh;
				float tempImagDenom = sumDenom_Real_lh*sumDenom_Imag_rh+sumDenom_Imag_rh*sumDenom_Real_rh;
				
				float p = (float) (1/Math.sqrt(2)*Math.sqrt(Math.sqrt(tempRealDenom*tempRealDenom+tempImagDenom+tempImagDenom)+tempRealDenom));
				float q = (float) ((int) Math.signum(tempImagDenom)/Math.sqrt(2)*Math.sqrt(Math.sqrt(tempRealDenom*tempRealDenom+tempImagDenom+tempImagDenom)-tempRealDenom));
				if (Float.isNaN(q)){
					q=0;
				}
				
				
				PSI_IMAG[i][j] = (-1*sumNum_Real*q+sumNum_Imag*p)/(p*p+q*q);
			    PSI_REAL[i][j] = (sumNum_Real*p+sumNum_Imag*q)/(p*p+q*q);
				
			}
			}
		this.PSI_REAL = PSI_REAL;
		this.PSI_IMAG = PSI_IMAG;
	}
	
	public void setNumCoils(int numCoils){
		this.numCoils=numCoils;
	}
	
	public float[][] getRealPSI(){
		return this.PSI_REAL;
	}
	
	public float[][] getImagPSI(){
		return this.PSI_IMAG;
	}

}
