package edu.vanderbilt.masi.algorithms.labelfusion;

import java.util.Arrays;
import edu.jhu.ece.iacl.jist.structures.image.ImageData;
import edu.vanderbilt.masi.algorithms.labelfusion.ObservationBase;
import edu.jhu.ece.iacl.jist.utility.JistLogger;

public class MajorityVote extends LabelFusionBase {
	
	public MajorityVote (ObservationBase obs_in,
						 String outname) {
		
		super(obs_in, outname);
		JistLogger.logOutput(JistLogger.INFO, "\n+++ Initializing Majority Vote +++");
		setLabel("MajorityVote");
		
	}
	
	public ImageData run () {
		
		JistLogger.logOutput(JistLogger.INFO, "\n+++ Running Majority Vote +++");
		
		// initialize some variables
		float [] lp = new float [obs.num_labels()];
		
		// iterate over every voxel
		for (int x = 0; x < obs.dimx(); x++) {
			print_status(x, obs.dimx());
			for (int y = 0; y < obs.dimy(); y++)
				for (int z = 0; z < obs.dimz(); z++) 
					for (int v = 0; v < obs.dimv(); v++)
						if (!obs.is_consensus(x, y, z, v)) {
							
							// initialize the label probabilities
							Arrays.fill(lp, 0f);
							
							// add up the votes from each rater
							for (int j = 0; j < obs.num_raters(); j++)
								if(obs.get_local_selection(x, y, z, v, j)) {
									short [] obslabels = obs.get_all(x, y, z, v, j);
									float [] obsvals = obs.get_all_vals(x, y, z, v, j);
									for (int i = 0; i < obslabels.length; i++)
										lp[obslabels[i]] += obsvals[i];
								}
							
							// save the estimate
							estimate.set(x+obs.offx(), y+obs.offy(), z+obs.offz(), v+obs.offv(), get_estimate_voxel(lp));
						}
		}
		
		// remap the estimate to the original label space
		obs.remap_estimate(estimate);
		
		return(estimate);
	}
	
	public SparseMatrix5D get_sparse_label_probabilites() {
		
		// initialize some variables
		SparseMatrix5D sparseW;
		sparseW = new SparseMatrix5D(obs.dimx(), obs.dimy(), obs.dimz(), obs.dimv(), obs.num_labels());
		float [] lp = new float [obs.num_labels()];
		
		// initialize the sparse W matrix
		for (int x = 0; x < obs.dimx(); x++) {
			print_status(x, obs.dimx());
			for (int y = 0; y < obs.dimy(); y++)
				for (int z = 0; z < obs.dimz(); z++)
					for (int v = 0; v < obs.dimv(); v++)
						if (!obs.is_consensus(x, y, z, v)) {
							
							// initialize the label probabilities
							Arrays.fill(lp, 0f);
							
							// add up the votes from each rater
							for (int j = 0; j < obs.num_raters(); j++) {
								short [] obslabels = obs.get_all(x, y, z, v, j);
								float [] obsvals = obs.get_all_vals(x, y, z, v, j);
								for (int i = 0; i < obslabels.length; i++)
									lp[obslabels[i]] += obsvals[i];
							}
							
							sparseW.init_voxel(x, y, z, v, lp);
						}
		}
		
		return(sparseW);
	}

	protected void set_label_probabilities(int x,
			                               int y,
			                               int z,
			                               int v,
			                               float [] lp) {
		float sum = 0;
		
		// initialize the label probabilities
		Arrays.fill(lp, 0f);
		
		// add up the votes from each rater
		for (int j = 0; j < obs.num_raters(); j++) {
			short [] obslabels = obs.get_all(x, y, z, 0, j);
			float [] obsvals = obs.get_all_vals(x, y, z, 0, j);
			for (int i = 0; i < obslabels.length; i++) {
				lp[obslabels[i]] += obsvals[i];
				sum += obsvals[i];
			}
		}
		
		// normalize the label probabilities
		for (int l = 0; l < obs.num_labels(); l++)
			lp[l] /= sum;
	}
}
