package edu.vanderbilt.masi.algorithms.labelfusion.simple;

import java.util.List;

import edu.jhu.ece.iacl.jist.structures.image.ImageData;
import edu.jhu.ece.iacl.jist.utility.JistLogger;

public class LocalSIMPLE extends SIMPLE {
	
	public LocalSIMPLE(List<ImageData> labList, List<ImageData> imgList, ImageData targetImg, int maxIt, float epsIn){
		super(labList, maxIt, epsIn);
		JistLogger.logOutput(JistLogger.WARNING, "Running Locally Weighted SIMPLE");
		JistLogger.logFlush();
		obs = new LocalSIMPLELabelVolume(labList, imgList, targetImg);
	}

	@Override
	public boolean hasGlobalWeights() {
		return true;
	}

	@Override
	protected float getWeight(int x, int y, int z, int r) {
		return obs.getLocalWeight(x, y, z, r) * this.weights[r];
	}

}
