package edu.vanderbilt.masi.algorithms.labelfusion.simple;

public class Patch implements Comparable<Patch> {
	
	private int x,y,z,c,lab;
	private float nlWeight;
	private float diceWeight;
	private float prevDiceWeight;
	
	public Patch(float nlWeightIn, int xIn, int yIn, int zIn, int cIn, int labIn){
		diceWeight = 1;
		prevDiceWeight = 1;
		nlWeight = nlWeightIn;
		x = xIn;
		y = yIn;
		z = zIn;
		c = cIn;
		lab = labIn;
	}
	
	public int getX(){ return this.x; }
	public int getY(){ return this.y; }
	public int getZ(){ return this.z; } 
	public int getC(){ return this.c; }
	public float getWeight(){ return this.diceWeight * this.nlWeight; }
	public float getDiceWeight(){ return this.diceWeight; }
	public void setDiceWeight(float w){
		this.prevDiceWeight = this.diceWeight;
		this.diceWeight = w;
	}
	public float getWeightDifference(){ return Math.abs(this.diceWeight - this.prevDiceWeight); }
	public int getLab(){ return this.lab; }
	@Override
	public int compareTo(Patch o) {
		if(this.nlWeight > o.nlWeight)  return 1 ;
		else if(this.nlWeight < o.nlWeight) return -1;
		return 0;
	}

}
