package edu.vanderbilt.masi.algorithms.regression;

import java.util.*;

public class DataCollection {
	private List<DataItem> dc;
	private int maxBoxCount;
	
	public DataCollection(int boxCount) {
		dc = new ArrayList<DataItem>();
		maxBoxCount = boxCount;
	}
	
	public void AddDataItem(int[][][] matrix,int[][] box) {
		DataItem di = new DataItem();
		di.Load(matrix, box, maxBoxCount);
		dc.add(di);
	}
	
	public void AddDataItem(DataItem item) {
		dc.add(item);
	}
	
	public void LoadTestData(int[][][] matrix) {
		dc.clear();
		DataItem di = new DataItem();
		di.LoadTestData(matrix);
		dc.add(di);
	}
	
	public void Clear() {
		dc.clear();
	}
	
	public DataItem GetDataItem(int index) {
		return dc.get(index);
	}
	
	public int GetDataItemCount() {
		return dc.size();
	}
	
	public int GetDataCount() {
		int sum = 0;
		for (DataItem item : dc) {
			sum += item.GetDataCount();
		}
		return sum;
	}
	
	public int GetBoxCount() {
		return maxBoxCount;
	}
	
	public float GetDataPoint(int i) {
		DataItem di = new DataItem();
		for (DataItem item : dc) {
			if (i < item.GetDataCount()) {
				di = item;
				break;
			}
			else
				i -= item.GetDataCount();
		}
		return di.GetDataPoint(i);
	}
	
	public int GetxDim() {
		return dc.get(0).GetxDim();
	}

	public int GetyDim() {
		return dc.get(0).GetyDim();
	}

	public int GetzDim() {
		return dc.get(0).GetzDim();
	}
	
	public int GetX(int i) {
		DataItem di = new DataItem();
		for (DataItem item : dc) {
			if (i < item.GetDataCount()) {
				di = item;
				break;
			}
			else
				i -= item.GetDataCount();
		}
		return di.GetX(i);
	}
	
	public int GetY(int i) {
		DataItem di = new DataItem();
		for (DataItem item : dc) {
			if (i < item.GetDataCount()) {
				di = item;
				break;
			}
			else
				i -= item.GetDataCount();
		}
		return di.GetY(i);
	}
	
	public int GetZ(int i) {
		DataItem di = new DataItem();
		for (DataItem item : dc) {
			if (i < item.GetDataCount()) {
				di = item;
				break;
			}
			else
				i -= item.GetDataCount();
		}
		return di.GetZ(i);
	}
	
	public double[] GetVector(int index) {
		double[] result = new double[3];
		result[0] = GetX(index);
		result[1] = GetY(index);
		result[2] = GetZ(index);
		
		return result;
	}
	
	public double GetTarget(int dataIndex, int boxIndex, int vecIndex) {
		double[] vec = GetVector(dataIndex);
		double target = GetBoxPoint(dataIndex, boxIndex)[vecIndex];
		target = vec[vecIndex / 2] - target;
		return target;
	}
	
	private int[] GetBoxPoint(int dataIndex, int boxIndex) {
		DataItem di = new DataItem();
		for (DataItem item : dc) {
			if (dataIndex < item.GetDataCount()) {
				di = item;
				break;
			}
			else
				dataIndex -= item.GetDataCount();
		}
		return di.GetBoxPoint(boxIndex);
	}
}

