package edu.vanderbilt.masi.algorithms.regression;

import java.util.*;

public class DataItem {
	private int xDim;
	private int yDim;
	private int zDim;
	
	private List<Float> data;
	private List<int[]> box;
	
	public DataItem Load(int[][][] matrix,int[][] box, int boxCount)
	{
		data = new ArrayList<Float>();
		this.box = new ArrayList<int[]>();
		xDim = matrix.length;
		yDim = matrix[0].length;
		zDim = matrix[0][0].length;
		
		for (int i = 0; i < zDim; ++i)
		{
			for (int j = 0; j < yDim; ++j) 
			{
				for (int k = 0; k < xDim; ++k)
				{
					data.add((float) matrix[k][j][i]);
				}
			}
		}
		
		for (int i = 0; i< boxCount; ++i)
		{
			if (i < box.length) 
				this.box.add(box[i]);
			else {
				int[] temp = new int[box[0].length];
				this.box.add(temp);
			}
		}
		return this;
	}
	
	public DataItem LoadTestData(int[][][] matrix) {
		data = new ArrayList<Float>();
		xDim = matrix.length;
		yDim = matrix[0].length;
		zDim = matrix[0][0].length;
		
		for (int i = 0; i < zDim; ++i)
		{
			for (int j = 0; j < yDim; ++j) 
			{
				for (int k = 0; k < xDim; ++k)
				{
					data.add((float) matrix[k][j][i]);
				}
			}
		}
		return this;
	}
	
	public int GetDataCount() {
		return data.size();
	}
	
	public int GetBoxCount() {
		return box.size();
	}
	
	public float GetDataPoint(int i) {
		return data.get(i);
	}
	
	public int[] GetBoxPoint(int i) {
		return box.get(i);
	}

	public int GetxDim() {
		return xDim;
	}

	public int GetyDim() {
		return yDim;
	}

	public int GetzDim() {
		return zDim;
	}
	
	public int GetX(int index) {
		return (index % (xDim * yDim)) % xDim;
	}
	
	public int GetY(int index) {
		return (index % (xDim * yDim)) / xDim;
	}
	
	public int GetZ(int index) {
		return index / (xDim * yDim);
	}
	
	public double[] GetVector(int index) {
		double[] result = new double[3];
		result[0] = GetX(index);
		result[1] = GetY(index);
		result[2] = GetZ(index);
		
		return result;
	}
	
	public double GetTarget(int dataIndex, int boxIndex, int vecIndex) {
		double[] vec = GetVector(dataIndex);
		double target = GetBoxPoint(boxIndex)[vecIndex];
		target = vec[vecIndex / 2] - target;
		return target;
	}
}
