package edu.vanderbilt.masi.algorithms.regression;

import org.w3c.dom.*;

public class Node {
	private Boolean bIsLeaf;
	private Boolean bIsSplit;
	private int[] boxIndexs = new int[2];
	
	public FeatureResponse Feature;
	public float Threshold;
	public StatisticsAggregator TrainingDataStatistics;
	
	public void InitializeLeaf(StatisticsAggregator trainingDataStatistics) {
		bIsLeaf = true;
		bIsSplit = false;
		Feature = new FeatureResponse();
		Threshold = 0.0f;
		TrainingDataStatistics = trainingDataStatistics.DeepClone();
		boxIndexs = trainingDataStatistics.GetTwoBoxId();
	}
	
	void InitializeSplit(
			FeatureResponse feature,
			float threshold,
			StatisticsAggregator trainingDataStatistics) {
      	bIsLeaf = false;
		bIsSplit = true;
		Feature = feature;
		Threshold = threshold;
		TrainingDataStatistics = trainingDataStatistics.DeepClone();
    }
	
	public Boolean IsLeaf() {
		return bIsLeaf;
	}
	public Boolean IsSplit() {
		return bIsSplit;
	}
	
	public Boolean IsNull()	{
		return !bIsLeaf && !bIsSplit;
	}
	
	public int GetFirstBoxId() {
		return boxIndexs[0];
	}
	
	public int GetSecondBoxId() {
		return boxIndexs[1];
	}
	
	public void CreateNodeElement(Document doc, Element nodeElement) {
		if (bIsLeaf) {
			nodeElement.setAttribute("Flag", "leaf");
			nodeElement.setAttribute("BoxID0", Integer.toString(boxIndexs[0]));
			nodeElement.setAttribute("BoxID1", Integer.toString(boxIndexs[1]));
		}
		else
			nodeElement.setAttribute("Flag", "split");
		nodeElement.setAttribute("Threshold", Float.toString(Threshold));
		
		Element featureElement = doc.createElement("Feature");
		Feature.createFeatureElement(doc, featureElement);
		nodeElement.appendChild(featureElement);
		
		Element statisticsElement = doc.createElement("Statistics");
		TrainingDataStatistics.CreateStatisticsElement(doc, statisticsElement);
		nodeElement.appendChild(statisticsElement);
	}
	
	public void XmlParse(Element nodeElement) {
		String strFlag = nodeElement.getAttribute("Flag");
		if (strFlag.equals("leaf")) {
			bIsLeaf = true;
			bIsSplit = false;
			boxIndexs[0] = Integer.parseInt(nodeElement.getAttribute("BoxID0"));
			boxIndexs[1] = Integer.parseInt(nodeElement.getAttribute("BoxID1"));
		}
		else {
			bIsLeaf = false;
			bIsSplit = true;
		}
		
		Threshold = Float.parseFloat(nodeElement.getAttribute("Threshold"));
		
		Element featureElement = 
				(Element)nodeElement.getElementsByTagName("Feature").item(0);
		Feature = new FeatureResponse();
		Feature.XmlParse(featureElement);
		
		Element statisticsElement = 
				(Element)nodeElement.getElementsByTagName("Statistics").item(0);
		int boxCount = Integer.parseInt(
				statisticsElement.getAttribute("BoxCount"));
		TrainingDataStatistics = new StatisticsAggregator(boxCount);
		TrainingDataStatistics.XmlParse(statisticsElement);
	}
	
	////////////////////////////////////////////
	public double[] GetBoxesVariance() {
		return TrainingDataStatistics.GetTargetsVariance();
	}
	
	public double GetBoxVariance(int boxIndex) {
		return TrainingDataStatistics.GetTargetVar(boxIndex);
	}
	
	public double[] GetBoxMean(int boxIndex) {
		return TrainingDataStatistics.GetTargetMean(boxIndex);
	}
}