package edu.vanderbilt.masi.plugins.classification;

import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmRuntimeException;
import edu.jhu.ece.iacl.jist.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.jist.pipeline.DevelopmentStatus;
import edu.jhu.ece.iacl.jist.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation.AlgorithmAuthor;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamBoolean;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamFile;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamFileCollection;

public class BuildClassifier2 extends ProcessingAlgorithm {
	// Input Parameters
		public ParamFile input_classifier;
		public ParamFileCollection features;

		// Output Parameters
		public ParamFileCollection output_classifier;

		/****************************************************
		 * CVS Version Control
		 ****************************************************/
		private static final String cvsversion = "$Revision: 1.1 $";
		private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "").replace(" ", "");
		private static final String shortDescription = "Builds Classifiers using python scikit-learn";
		private static final String longDescription = "";
	@Override
	protected void createInputParameters(ParamCollection inputParams) {
		AlgorithmInformation info = getAlgorithmInformation();
		info.setWebsite("https://masi.vuse.vanderbilt.edu/");
		info.setAffiliation("MASI - Vanderbilt");
		info.add(new AlgorithmAuthor("Andrew Plassard","andrew.j.plassard@vanderbilt.edu","https://masi.vuse.vanderbilt.edu/index.php/MASI:Andrew_Plassard"));
		info.setDescription(shortDescription);
		info.setLongDescription(shortDescription + longDescription);
		info.setVersion(revnum);
		info.setEditable(false);
		info.setStatus(DevelopmentStatus.BETA);

		inputParams.setPackage("MASI");
		inputParams.setCategory("Classification");
		inputParams.setLabel("Build Classifier2");
		inputParams.setName("Build_Classifier2");

		inputParams.add(input_classifier = new ParamFile("Input Classifier"));
		input_classifier.setMandatory(true);
		input_classifier.setLoadAndSaveOnValidate(false);
		
		inputParams.add(features = new ParamFileCollection("Input Features"));
		features.setMandatory(true);
		
	}

	@Override
	protected void createOutputParameters(ParamCollection outputParams) {
		outputParams.add(output_classifier = new ParamFileCollection("Trained Classifiers"));

	}

	@Override
	protected void execute(CalculationMonitor arg0)
			throws AlgorithmRuntimeException {
		// TODO Auto-generated method stub

	}

}
