package edu.vanderbilt.masi.plugins.external;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmRuntimeException;
import edu.jhu.ece.iacl.jist.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.jist.pipeline.DevelopmentStatus;
import edu.jhu.ece.iacl.jist.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation.AlgorithmAuthor;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamBoolean;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamFile;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamInteger;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamModel;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamOption;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamString;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamVolume;
import edu.jhu.ece.iacl.jist.utility.JistLogger;

public class FSLFlirt extends ProcessingAlgorithm{
	private static final String cvsversion = "$Revision: 1.1 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "") .replace(" ", "");
	
	//The inputs
	ParamFile in;
	ParamFile ref;
	ParamFile init;
	ParamBoolean omat;
	ParamBoolean out;
	ParamOption datatype;
	ParamOption cost;
	ParamOption searchcost;
	ParamBoolean usesqform;
	ParamBoolean displayinit;
	ParamOption anglerep;
	ParamOption interp;
	ParamInteger sincwidth;
	ParamOption sincwindow;
	ParamInteger bins;
	ParamInteger dof;
	ParamBoolean noresample;
	ParamBoolean forcescaling;
	ParamInteger minsampling;
	ParamBoolean applyxfm;
	ParamInteger applyisoxfm;
	ParamInteger paddingsize;
	ParamString searchrx;
	ParamString searchry;
	ParamString searchrz;
	ParamBoolean nosearch;
	ParamInteger coarsesearch;
	ParamInteger finesearch;
	ParamFile schedule;
	ParamVolume refweight;
	ParamVolume inweight;
	ParamBoolean noclamp;
	ParamBoolean noresampblur;
	ParamBoolean twoD;
	ParamInteger verbose;
	ParamBoolean v;
	ParamBoolean i;
	ParamBoolean version;
	
	//The outputs
	ParamVolume outputVol;
	ParamFile outputMat;
	ParamFile stdout;
	ParamFile stderr;
	

	
	
	
	@Override
	protected void createInputParameters(ParamCollection inputParams) {
		// TODO Auto-generated method stub
		inputParams.add(in=new ParamFile("in Volume"));
		inputParams.add(ref=new ParamFile("ref Volume"));
		inputParams.add(init=new ParamFile("init matrix"));
		init.setMandatory(false);
		inputParams.add(omat=new ParamBoolean("omat matrix"));
		inputParams.add(out=new ParamBoolean("out volume"));
		List<String> datatypeOpts = new ArrayList<String>(5);
		datatypeOpts.add("double");
		datatypeOpts.add("short");
		datatypeOpts.add("int");
		datatypeOpts.add("float");
		datatypeOpts.add("char");
		inputParams.add(datatype=new ParamOption("datatype output data type",datatypeOpts));
		List<String> costOpts = new ArrayList<String>(6);
		costOpts.add("mutualinfo");
		costOpts.add("corratio");
		costOpts.add("normcorr");
		costOpts.add("normmi");
		costOpts.add("leastsq");
		costOpts.add("labeldiff");
		inputParams.add(cost=new ParamOption("cost function",costOpts));
		inputParams.add(searchcost=new ParamOption("searchcost function",costOpts));
		inputParams.add(usesqform=new ParamBoolean("usesqform"));
		inputParams.add(displayinit=new ParamBoolean("displayinit display initialization"));
		List<String> angleOpts = new ArrayList<String>(2);
		angleOpts.add("euler");
		angleOpts.add("quaternion");
		inputParams.add(anglerep=new ParamOption("anglerep angle representation",angleOpts));
		List<String> interpOpts = new ArrayList<String>(3);
		interpOpts.add("trilinear");
		interpOpts.add("nearestneighbour");
		interpOpts.add("sinc");
		inputParams.add(interp=new ParamOption("interp interpolation method",interpOpts));
		inputParams.add(sincwidth=new ParamInteger("sincwidth"));
		List<String> windowOpts = new ArrayList<String>(3);
		windowOpts.add("rectangular");
		windowOpts.add("hanning");
		windowOpts.add("blackman");
		inputParams.add(sincwindow=new ParamOption("sincwindow",windowOpts));
		inputParams.add(bins=new ParamInteger("bins number of bins"));
		inputParams.add(dof=new ParamInteger("dof number of DOF"));
		inputParams.add(noresample=new ParamBoolean("noresample do not change input sampling"));
		inputParams.add(forcescaling=new ParamBoolean("forcescaling force rescaling regardless of resolution"));
		inputParams.add(minsampling=new ParamInteger("minimum sampling size"));
		inputParams.add(applyxfm=new ParamBoolean("minsampling apply a transform"));
		inputParams.add(applyisoxfm=new ParamInteger("applyisoxfm apply isotropic transform"));
		inputParams.add(paddingsize=new ParamInteger("paddingsize window padding size"));
		inputParams.add(searchrx=new ParamString("searchrx search angle in x default is -90 90"));
		searchrx.setMandatory(false);
		inputParams.add(searchry=new ParamString("searchry search angle in y default is -90 90"));
		searchry.setMandatory(false);
		inputParams.add(searchrz=new ParamString("searchrz search angle in z default is -90 90"));
		searchrz.setMandatory(false);
		inputParams.add(nosearch=new ParamBoolean("nosearch sets search angle to 0 for x y z"));
		inputParams.add(coarsesearch=new ParamInteger("coarsesearch perform a coarse search"));
		inputParams.add(finesearch=new ParamInteger("finesearch perform a fine search"));
		inputParams.add(schedule=new ParamFile("schedule schedule file"));
		schedule.setMandatory(false);
		inputParams.add(refweight=new ParamVolume("refweight reference weight volumes"));
		refweight.setMandatory(false);
		inputParams.add(inweight=new ParamVolume("inweight input weight volumes"));
		inweight.setMandatory(false);
		inputParams.add(noclamp=new ParamBoolean("noclamp don't use intensity clamping"));
		inputParams.add(noresampblur=new ParamBoolean("noresampblur dont resample "));
		inputParams.add(twoD=new ParamBoolean("2d use a 2d model"));
		inputParams.add(verbose=new ParamInteger("verbose set the verbose level"));
		inputParams.add(v=new ParamBoolean("v set verbose to 1"));
		inputParams.add(i=new ParamBoolean("i pause at each stage"));
		inputParams.add(version=new ParamBoolean("version print version number"));
		
		inputParams.setPackage("MASI");
		inputParams.setCategory("External.FSL");
		inputParams.setLabel("FSL Flirt");
		inputParams.setName("FSL_Flirt");

		AlgorithmInformation info = getAlgorithmInformation();
		info.setWebsite("https://masi.vuse.vanderbilt.edu/");
		info.setAffiliation("MASI - Vanderbilt");
		info.add(new AlgorithmAuthor("MASI","Steve Damon","Electrical Engineering"));
		info.setDescription("run FSL flirt");
		info.setLongDescription("run FSL Flirt");
		info.setVersion(revnum);
		info.setEditable(true);
		info.setStatus(DevelopmentStatus.ALPHA);

	}

	@Override
	protected void createOutputParameters(ParamCollection outputParams) {
		// TODO Auto-generated method stub
		outputParams.add(outputVol = new ParamVolume("Registered Vol"));
		outputParams.add(outputMat = new ParamFile("output transformation matrix"));
		outputParams.add(stderr = new ParamFile("stderr"));
		outputParams.add(stdout = new ParamFile("stdout"));
		outputVol.setMandatory(true);
		outputMat.setMandatory(false);
		stderr.setMandatory(true);
		stdout.setMandatory(true);
	}

	@Override
	protected void execute(CalculationMonitor monitor)
			throws AlgorithmRuntimeException {
		
		Boolean doOutputMtx = (Boolean) inputParams.getFirstChildByLabel("omat matrix").getValue();
		File outputMtx = new File(this.getOutputDirectory()+File.separator+"transform.mtx");
		File outputFile = new File(this.getOutputDirectory()+File.separator+"registered.nii.gz");
		String str = "flirt";
		Vector<ParamModel> mod =inputParams.getAllDescendants();
		for (int i=2;i<mod.size();i++){
			String flag = getCliTag(mod.get(i).getName());
			Object value =mod.get(i).getValue();
			if (value==null){//skip nulls
				continue;
			}else if (value.toString().equals("0") || value.toString().equals("")|| value.toString().equals("false")){ //skip zeros, empty strings, or false
				continue;
			}else{
				str+=" "+flag+" "+mod.get(i).getValue().toString();
			}
		}
		
		
		//handle optional output
		if (doOutputMtx){
			str+=" -omat "+outputMtx.getAbsolutePath();
		}
		str+=" -o "+ outputFile.getAbsolutePath();
		
		System.out.println(str);
		
		JistLogger.logOutput(JistLogger.INFO,"*************************Begin External CMD STDOUT*************************");
		File thisOut = new File(this.getOutputDirectory()+File.separator+"fsl.out");
		File thisErr = new File(this.getOutputDirectory()+File.separator+"fsl.err");
		Process p;
		String line;
		try {
			p = Runtime.getRuntime().exec(str);
			BufferedWriter writer = new BufferedWriter(new FileWriter(thisOut));
			BufferedWriter writerErr = new BufferedWriter(new FileWriter(thisErr));
			BufferedReader in = new BufferedReader(new InputStreamReader(p.getInputStream()));
			BufferedReader err = new BufferedReader(new InputStreamReader(p.getErrorStream()));
	       while ((line = in.readLine()) != null) {
	         writer.write(line+"\n");
	         JistLogger.logOutput(JistLogger.INFO,line+"\n");
	       }
	       in.close();
	       writer.close();
	       while ((line = err.readLine())!=null){
	    	   writerErr.write(line+"\n");
	    	   JistLogger.logError(JistLogger.SEVERE, line+"\n");
	       }
	       err.close();
	       writerErr.close();
	       //p.waitFor();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} 
		JistLogger.logOutput(JistLogger.INFO,"**************************End External CMD STDOUT**************************");
		
		
		outputVol.setValue(outputFile.getAbsolutePath());
		stderr.setValue(thisErr);
		stdout.setValue(thisOut);
		if (doOutputMtx){
			str+=" -omat "+outputMtx.getAbsolutePath();
			outputMat.setValue(outputMtx);
		}
		
	}
	
	protected String getCliTag(String s){
		String[] parts = s.split(" ");
		return "-"+parts[0];
	}

}
