package edu.vanderbilt.masi.plugins.labelfusion;

import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmRuntimeException;
import edu.jhu.ece.iacl.jist.pipeline.CalculationMonitor;
import edu.jhu.ece.iacl.jist.pipeline.DevelopmentStatus;
import edu.jhu.ece.iacl.jist.pipeline.ProcessingAlgorithm;
import edu.jhu.ece.iacl.jist.pipeline.AlgorithmInformation.AlgorithmAuthor;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamCollection;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamFile;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamFloat;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamInteger;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamString;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamVolume;
import edu.jhu.ece.iacl.jist.pipeline.parameter.ParamVolumeCollection;
import edu.vanderbilt.masi.algorithms.labelfusion.SimplifiedMultiSetSTAPLE;

public class PluginSimplifiedMultiSetSTAPLE extends ProcessingAlgorithm {

	private static final String cvsversion = "$Revision: 1.2 $";
	private static final String revnum = cvsversion.replace("Revision: ", "").replace("$", "").replace(" ", "");
	private static final String shortDescription = "Runs the simplified Multi-Set STAPLE Algorithm.";
	private static final String longDescription = "";
	
	// Input arguments
	public ParamVolumeCollection obsVals;
	public ParamFile raterMap;
	public ParamFile initialTheta;
	public ParamString targetSegmentation;
	public ParamInteger maxIter;
	public ParamFloat consensusThresh;
	public ParamFloat epsilon;
	public ParamFloat regularization;
	
	// Output Parameters
	public ParamVolume labels;
	public ParamVolume labelProbabilities;
	
	@Override
	protected void createInputParameters(ParamCollection inputParams) {
		AlgorithmInformation info = getAlgorithmInformation();
		info.setWebsite("https://masi.vuse.vanderbilt.edu/");
		info.setAffiliation("MASI - Vanderbilt");
		info.add(new AlgorithmAuthor("Andrew Plassard","andrew.j.plassard@vanderbilt.edu","https://masi.vuse.vanderbilt.edu/index.php/MASI:Andrew_Plassard"));
		info.setDescription(shortDescription);
		info.setLongDescription(shortDescription + longDescription);
		info.setVersion(revnum);
		info.setEditable(true);
		info.setStatus(DevelopmentStatus.BETA);
		
		inputParams.setPackage("MASI");
		inputParams.setCategory("Label Fusion");
		inputParams.setName("SMS_STAPLE");
		inputParams.setLabel("Simplified Multi-Set STAPLE");
		
		inputParams.add(obsVals = new ParamVolumeCollection("Observed Rater Volumes"));
		obsVals.setMandatory(true);
		
		inputParams.add(raterMap = new ParamFile("Map of raters to atlas class"));
		raterMap.setMandatory(true);
		
		inputParams.add(initialTheta = new ParamFile("Initial Theta Values"));
		initialTheta.setMandatory(true);
		
		inputParams.add(targetSegmentation = new ParamString("Target Segmentation Class"));
		targetSegmentation.setMandatory(true);
		
		inputParams.add(maxIter = new ParamInteger("Maximum Number of Iterations"));
		maxIter.setMandatory(false);
		maxIter.setValue(100);
		
		inputParams.add(consensusThresh = new ParamFloat("Consensus level for voxels"));
		consensusThresh.setMandatory(false);
		consensusThresh.setValue(0.99f);
		
		inputParams.add(regularization = new ParamFloat("Value to regularize confusion matrix towards truth"));
		regularization.setMandatory(false);
		regularization.setValue(10f);		
		
		inputParams.add(epsilon = new ParamFloat("Convergence Threshold"));
		epsilon.setMandatory(false);
		epsilon.setValue(1e-4);
		
	}

	@Override
	protected void createOutputParameters(ParamCollection outputParams) {
		
		outputParams.add(labels = new ParamVolume("Labels"));
		outputParams.add(labelProbabilities = new ParamVolume("Probabilities"));

	}

	@Override
	protected void execute(CalculationMonitor monitor)
			throws AlgorithmRuntimeException {
		
		SimplifiedMultiSetSTAPLE SMSS = new SimplifiedMultiSetSTAPLE(obsVals.getImageDataList(),
				raterMap.getValue(),initialTheta.getValue(),maxIter.getValue(),
				consensusThresh.getValue(),epsilon.getValue(),targetSegmentation.getValue(),regularization.getValue());
		labels.setValue(SMSS.getSegmentation());
		labelProbabilities.setValue(SMSS.getProbabilities());
	}

}
