package edu.vanderbilt.masi.utilities;

import edu.jhu.ece.iacl.jist.pipeline.AbstractCalculation;

public abstract class AndrewUtils extends AbstractCalculation{
	
	private int r,c,s,v; // rows columns slices volumes
	
	public AndrewUtils(){
		super();
	}
	
	public AndrewUtils(int rows,int cols,int slices,int vols){
		this();
		this.r = rows;
		this.c = cols;
		this.s = slices;
		this.v = vols;
	}
	
	public AndrewUtils(int rows,int cols,int slices){
		this(rows,cols,slices,1);
	}
	
	public AndrewUtils(int rows,int cols){
		this(rows,cols,1);
	}
	
	public static float calculateSTD(float[] arr, float mean){
		float std = 0;
		for(float f: arr)
			std += Math.pow(f - mean, 2);
		std = (float) Math.sqrt(std / (arr.length-1));
		return std;
	}
	
	public static float calculateSTD(float[] arr){
		float mean = calculateMean(arr);
		return calculateSTD(arr, mean);
	}
	
	public static float calculateMean(float[] arr){
		float mean = 0;
		for(float f: arr)
			mean+= f;
		mean = mean / arr.length;
		return mean;
	}

}
