/*
 * OPALE is a scientific library under LGPL. Its main goal is to
 * develop mathematical tools for any scientist.
 *
 * Copyright (C) 2002 Opale Group
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * You can visit the web site http://opale.tuxfamily.org to obtain more
 * informations about this program and/or to contact the authors by mail
 * developers@opale.tuxfamily.org.
 */

package otests.matrix.BandLU;

import opale.tools.*;
import opale.mathtools.*;
import opale.matrix.*;
import opale.matrix.solver.*;


public class BandLU implements OTest
{
public  void run(String path)
	{
	int size = 100;
	BandMatrix A = new BandMatrix (size,3);

	for (int i=0;i<size;i++)
		{
		A.set(i,i,2);
		if (i>0) A.set(i,i-1,-7);
		if (i<size-1) A.set(i,i+1,-7);
		 }
	//System.out.println(A);
	//System.out.println(A.get(2,2));
	
	DVect b=new DVect(size);
	DVect x=new DVect(size);

	
	b.set(0,1);
	b.set(1,0);
	
	
	BandMatrix AA = (BandMatrix) A.clone();	 
	SolverLUBand lu = new SolverLUBand();
	lu.decomp(A);
	//System.out.println(A);
	System.out.println("det = "+lu.determinant());
	lu.solve(null,b,x);
	//System.out.println(x);

	
	
	DVect err = new DVect(size);
	DVect Ax = new DVect(size);
	Ax = AA.mul(x);
	for (int i=0;i<size;i++)
		{
		err.set(i,Ax.get(i)-b.get(i));
		}
	
	System.out.println("Err = "+err.getMax());
	
	}
public void stop()
	{
	}
	
}
	
