import java.io.*;
import javax.xml.parsers.*;
import javax.xml.transform.*;
import javax.xml.transform.stream.*;
import org.w3c.dom.*;
import org.xml.sax.*;

public final class XmlDoc {
        private static final DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        private static final TransformerFactory transFactory = TransformerFactory.newInstance();
        private final DocumentBuilder docBuilder;
        private final Transformer transformer;
        private final File xmlDirectory;
        private final File htmlDirectory;

        public static void main(String arg[]) {
                try {
                        XmlDoc xmldoc = new XmlDoc(arg[0], arg[1], arg[2]);
                        xmldoc.generateIndex(arg[3], arg[4]);
                        xmldoc.transform();
                } catch(Exception e) {
                        e.printStackTrace();
                }
        }
        public XmlDoc(String xmlDirectory, String stylesheet, String outDirectory) throws ParserConfigurationException, TransformerConfigurationException {
                this.xmlDirectory = new File(xmlDirectory);
                this.htmlDirectory = new File(outDirectory);
                docBuilder=docFactory.newDocumentBuilder();
                transformer = transFactory.newTransformer(new StreamSource(stylesheet));
        }
        public void generateIndex(String root, String child) throws IOException {
                File index = new File(xmlDirectory, "index.xml");
                PrintWriter writer = new PrintWriter(new FileWriter(index));
                writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
		writer.println("<!-- Auto-generated by "+getClass().getName()+" -->");
                writer.println("<"+root+" xmlns:xlink=\"http://www.w3.org/1999/xlink\">");
                String filenames[] = xmlDirectory.list();
                for(int i=0; i<filenames.length; i++) {
                        if(filenames[i].endsWith(".xml") && !filenames[i].startsWith("index")) {
                                String name[] = parse(filenames[i]);
                                writer.println("   <"+child+" name=\""+name[0]+"\" symbol=\""+name[1]+"\" xlink:href=\""+filenames[i]+"\"/>");
                        }
                }
                writer.println("</"+root+">");
                writer.close();
        }
        private String[] parse(String xmlfile) {
                try {
                        Document doc=docBuilder.parse(new File(xmlDirectory, xmlfile));
                        Node root=doc.getDocumentElement();
                        NodeList nl=root.getChildNodes();
                        String name=findStringValue(nl,"name");
                        String symbol=findStringValue(nl,"symbol");
                        return new String[] {name, symbol};
                } catch(IOException e) {
                        return null;
                } catch(SAXException e) {
                        return null;
                }
        }
        private static String findStringValue(NodeList nl,String name) {
                Node item;
                for(int i=0;i<nl.getLength();i++) {
                        item=nl.item(i);
                        if(item.getNodeName().equals(name))
                                return item.getFirstChild().getNodeValue();
                }
                return "";
        }
        public void transform() throws TransformerException {
                String filenames[] = xmlDirectory.list();
                for(int i=0; i<filenames.length; i++) {
                        if(filenames[i].equals("index.xml")) {
                                Transformer indexTransformer = transFactory.newTransformer(new StreamSource(htmlDirectory+"/index.xsl"));
                                transform(indexTransformer, filenames[i]);
                        } else if(filenames[i].endsWith(".xml"))
                                transform(filenames[i]);
                }
        }
        private void transform(String xmlfile) throws TransformerException {
                transform(transformer, xmlfile);
        }
        private void transform(Transformer transformer, String xmlfile) throws TransformerException {
                StreamSource source = new StreamSource(new File(xmlDirectory, xmlfile));
                StreamResult result = new StreamResult(new File(htmlDirectory, xmlfile.substring(0, xmlfile.indexOf('.'))+".html"));
                transformer.transform(source, result);
        }
}
